/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* first APL2 V1.0.0 ***************************************************
* Yields first item of rite.	If empty, yields the prototype.		 *
* Called from execmonj, nreduces.                                      *
***********************************************************************/
#define INCLUDES APLCB+STRING
#include "includes.h"
Aplcb first(rite)
Aplcb rite;
{
	Aplcopy; Errstop; First; Getcb; Iscalar; Take;
     extern int aplerr;
	Aplcb out;

	if (rite->aplcount)
     	if (rite->aplflags & APLAPL) {
          	out = aplcopy(*(rite->aplptr.aplapl));
               if (out != NULL)
               	out->aplflags |= APLTEMP;
          }
		else {
          	out = take(iscalar(1),rite);
          	rite = NULL;
     	}
	else switch(rite->aplflags & (APLMASK + APLAPL)) {
		case APLAPL:
			out = first(*(rite->aplptr.aplapl));
			break;
		case APLINT:
		case APLNUMB:
			out = iscalar(0);
			break;
		case APLCHAR:
			out = getcb(NULL, 1, APLCHAR + APLTEMP, 1, NULL);
			if (aplerr == 0)
				strcpy(out->aplptr.aplchar," ");
			break;
		default:
			out = NULL;
			aplerr = 999; /* internal error */
			break;
	}
	return(errstop(0,NULL,rite,out));
}
