/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* formatl APL2 V1.0.0 *************************************************
*   Called by formatp and formatq to obtain either the next field from *
* the model (left argument to Format-by-Example), or the next string of*
* column dividers (blanks, standalone decorator characters).  A field  *
* is a sequence of characters containing at least one digit ('0' thru  *
* '9') and bounded by either blanks or a special field boundary mark   *
* (the digit '6').  Examples of fields in " 555 x -551.20CR" are "555" *
* and "-551.20CR".                                                     *
*   The pointer to the character in the input just beyond the last     *
* character in the current string is returned.  The current string is  *
* copied to *to.  *start will point to the first control character ('0'*
* thru '9', '.' or ','), or will be NULL if the current string         *
* contains no control characters.                                      *
*   Argument start is used to determine if pseudo-standalone decorator *
* characters are expected next.  If *start isn't null, and the first   *
* character pointed to by *from is non-blank, it signifies the prior   *
* field was terminated with a 6 control digit.  All characters until   *
* the next control character are considered a decorator string.        *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
char *formatl(to,from,start)
char *to,*from,**start;
{
	int divider=0,offset=-1;
	char *cp,*orgto=to,*orgfrom=from,*orgstart=*start;

	*start = NULL;
	if (orgstart != NULL && *from != ' ') /* decorator after "6"? */
		divider = 2; /* column divider, maybe not blank delimited */
	while('\0' != (*(cp = to++) = *from++)) {
		if (*cp == ' ') { /* it's a blank */
			if (*start != NULL) break; /* found end of field */
			divider = 1; /* this string is a column divider */
			offset = -1;
		}
		else { /* it's a non-blank */
			if (offset == -1 || divider == 2)
				offset = cp - orgto; /* possible end divider */
			if ((*cp >= '0' && *cp <= '9')) {
				if (divider) { /* found end of column divider */
					*(orgto + offset) = '\0'; /* delimit column div. */
					return(orgfrom + offset); /* all done */
				}
				if (*cp == '6') { /* end of field */
					*(cp+1) = '\0'; /* add delimiter */
					return(from); /* all done */
				}
				if (*start == NULL)
					*start = cp; /* a(1st digit control field) */
			}
		}
	}
	*cp = '\0'; /* end of field - add delimiter */
	return(from-1);
}
