/*Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/** formatz APL2 V1.0.0 ************************************************
* Called from formatg to format an element when the input is nested,   *
* and therefore may be a combination of simple numeric scalars and     *
* character data.                                                      *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
formatz(rite,cp,width,precisn,digits,fch,colch)
Aplcb rite;		/* Value to be formatted. */
char *cp; 	/* Output location. */
int width;	/* Width of output. */
int precisn;	/* Places to output right of decimal point. */
int digits;	/* Places to output left of decimal point. */
char *fch;	/* Lfc string. */
int colch;	/* 1 = Entire column is char, 0 otherwise. */
{
	Chrcopy; Formath;
	extern int aplerr;
	char ch,*ip,*jp,*kp,*op;
	int i,j,k,m,type;
	double d;

	type = rite->aplflags & APL_NUMERIC;
	if (type) {
		if (type == APLINT)
			d = *(rite->aplptr.aplint);
		else d = *(rite->aplptr.apldata);
		formath(d,cp,width,precisn,digits,fch);
		return;
	}
	/* rite m/b char data. */
	if (rite->aplcount > width) { /* Overflow? */
		if ('0' == (ch = *(fch+3))) /* Is Lfc[4] == '0'? */
			aplerr = 29; /* model width is too small */
		else /* Fill with overflow indicator. */
			cp = chrcopy(cp,&ch,width,0); /* Fill. */
		return; /* Return after overflow condition. */
	}
	i = width - rite->aplcount;
	if (colch) { /* If entire column is char, left justify. */
		cp = chrcopy(cp, rite->aplptr.aplchar, rite->aplcount, 1);
		if (i) {
			ch = ' ';
			cp = chrcopy(cp, &ch, i, 0); /* Fill right. */
		}
	}
	else { /* Right justify. */
		if (i) {
			ch = ' ';
			cp = chrcopy(cp, &ch, i, 0); /* Fill right. */
		}
		cp = chrcopy(cp, rite->aplptr.aplchar, rite->aplcount, 1);
	}
}
