/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* formdfv APL2 V1.0.0 *************************************************
* Formdfv is called by formdfu and formdfw if rite has rank > 2 to     *
* determine how many blank lines need to be added between adjacent     *
* rows to represent interdimensional spacing.  Planes of a             *
* 3-dimensional array are separated by a blank line.  For higher rank  *
* arrays, each successive plane is separated by an additional line.    *
* Formdfv s/b called once for each row of output.  It will return the  *
* number of blank lines that should follow the current row.            *
***********************************************************************/
#define INCLUDES STDIO+APLCB
#include "includes.h"
int formdfv(rite,cntcb)
Aplcb rite,cntcb;
{
     int *cntp,*dimp,*dims,rowspaces = 0;

     dims = rite->apldim; /* Start of dimension array. */
     dimp = dims + rite->aplrank - 2;	/* Second last dimension.          */
     cntp = cntcb->aplptr.aplint;	/* One counter for each dimension  */
					/* of rite, less 1.                */
     while (++(*cntp) == *dimp) {	/* Bump counter pointed to by      */
					/* *cntp, and compare to dimension */
					/* pointed to by *dimp.            */
          rowspaces++; /* Interdimensional spacing. */
          *cntp = 0; /* Reset the counter for this dimension to 0. */
          if (dimp == dims) break; /* Stop loop if dimp points at 1st dim. */
          dimp--; /* Point dimp to next dim, e.g. if was 2, is now 1. */
          cntp++; /* Point to next counter. */
     }
     return(rowspaces);
}
