/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* formdfx APL2 V1.0.0 *************************************************
* Formdfx is called by formdfu after widths/heights/spacing determined.*
* It obtains final output aplcb, and copies formatted data to it.	 *
***********************************************************************/
#define INCLUDES STDIO+APLCB
#include "includes.h"
Aplcb formdfx(v,cols,rows,rowso,frmcb,colbl,colwi,rowbl,rowhi,numcb,chrcb)
int v, cols, rows, rowso;
Aplcb frmcb,colbl,colwi,rowbl,rowhi,numcb,chrcb;
{
	Errstop; Formdfz; Iplus; Ireduce; Ivalue;
	extern int aplerr,indxorg;
	Aplcb fcb,*frmp,out;
	int *chrp,*colblp,colso,colspaces,*colwip,colwidth,i,icols,iplusid=0,
	irows,j,k,m,*nump,rank,*rowblp,rowheight,*rowhip,rowspaces;
	char *fch,*opcol,*opout,*oprow,*opstart;

	colso = ivalue(ireduce(iplus,&iplusid,colbl,indxorg)) +
		ivalue(ireduce(iplus,&iplusid,colwi,indxorg)) + 2;
	out = formdfz(v,colso,rowso); /* get output aplcb */
	if (aplerr) return(NULL);
	frmp = frmcb->aplptr.aplapl; /* formatted input */
	rowblp = rowbl->aplptr.aplint; /* 1st row blank lines */
	rowhip = rowhi->aplptr.aplint; /* 1st row height. */
	oprow = out->aplptr.aplchar + 1; /* 1st output row anchor */
	for (i = rows; i > 0; i--) {
		colblp = colbl->aplptr.aplint; /* 1st column spaces counter */
		colwip = colwi->aplptr.aplint; /* 1st column width counter */
		nump   = numcb->aplptr.aplint; /* 1st column numeric flag */
		chrp   = chrcb->aplptr.aplint; /* 1st column character flag */
		rowheight = *rowhip++; /* height of this row in characters */
		rowspaces = (rows > 1) ? *rowblp++ : 0;
			/* blank lines after this row */
		opcol = oprow; /* column output anchor */
		for (j = cols; j > 0; j--) {
			colwidth = *colwip++;
			colspaces = (colblp != NULL) ?  *colblp++ : 0;
			fcb = *frmp++; /* next formatted input aplcb */
			if (fcb->aplrank < 2) {irows = 1; icols = fcb->aplcount;}
			else {irows = *(fcb->apldim); icols = *(fcb->apldim + 1);}
			fch = fcb->aplptr.aplchar;
			if (*nump++ || !*chrp++)
				opout = opcol + colwidth - icols; /* right justified */
			else opout = opcol; /* left justified */
			opstart = opout; /* save start of row */
			for (k = irows; k > 0; k--) {
				for (m = icols; m > 0; m--)
					*opout++ = *fch++; /* copy char */
				opout = opstart += colso; /* start of next row */
			}
			opcol += colwidth + colspaces;
		}
		oprow += colso * (rowheight + rowspaces); /* new row anchor */
	}
	return(errstop(0,NULL,NULL,out));
}
