/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* funcexee APL2 V1.0.0 ************************************************
* Called by funcexec after stop control has been handled to execute    *
* the next function statement.                                         *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLFUNCI+APLTOKEN+TREE+APLDEBUG
#include "includes.h"
int funcexee(trace,stmtno)
Aplcb trace;	/* Trace control vector. */
int stmtno;	/* Next statement to be executed. */
{
	Funcexed; Funcexef;
	extern Treelist treehdr;
	extern int aplerr;
	Aplcb out;
	Apltoken curtok,gotok;
	Aplfunc fp;
	int tokcnt;
#if APL_DEBUG
void mem_check(void);
mem_check();
#endif

	fp = treehdr->avlfun; /* function definition */
	treehdr->lastfun = treehdr->avloff = 0;
	tokcnt = *(fp->functokc + stmtno); /* count of tokens */
	curtok = *(fp->functokp + stmtno) + 
		tokcnt - 1; /* leftmost token in stmt */
	if (curtok->token_code == RIGHT_ARROW) {
		gotok = curtok--;
		tokcnt--;
	}
	else gotok = NULL; /* no branch on this statement */
	if (curtok->token_code == CAP_NULL) { /* apl comment? */
		out = NULL;
		if (gotok != NULL) {
			aplerr = 95; /* bad syntax */
			treehdr->avloff = curtok->token_offset;
		}
	}
	else 
		out = funcexed(curtok,tokcnt);
#if APL_DEBUG
mem_check();
#endif
	return(funcexef(trace,stmtno,fp,out,gotok));
}
