/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* funcsusq APL2 V1.0.0 ************************************************
* Called by funcsusp to process the current terminal input.            *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLFUNCI+STDIO+TREE
#include "includes.h"
int funcsusq(out,pstmtno)
Aplcb out;		/* current input statement */
int *pstmtno;		/* statement number field for suspended functions */
{
	Apledit; Aplscan; Aplwksp; Drop; Endoper; Execute; Executf;
     Funcgoto; Getchrv; Iscalar;
	extern Treelist treehdr;
	extern int aplerr;
	char *cp,*cpend,*cs;
	int i,loop=1,stmtno=0,tempsave;

	cp = out->aplptr.aplchar; /* point to input line */
	cpend = cp + out->aplcount; /* end of input line */
	i = aplscan(&cp,cpend); /* find first token code */
	switch(i) {
		case RIGHT_ARROW:
          	if (treehdr->treeflag & SUSPNDED)
				treehdr->treeflag -= SUSPNDED; /* clear to prior suspended */
			loop = 0; /* stop loop */
			if (cp == cpend) { /* right arrow standing alone */
				endoper(out);
				aplerr = 997; /* clear state indicator */
				*pstmtno = 0; /* get out of function */
			}
			else if (NULL != treehdr->avlfun) {
				tempsave = out->aplflags & APLTEMP; /* Save. */
				cs = out->aplptr.aplchar++; /* Save, and bump. */
				out->aplcount--; /* Decrement for right arrow. */
				*pstmtno = 1+funcgoto(treehdr->avlfun,
					executf(out),*pstmtno); /* Get stmtno to goto. */
				if (tempsave == 0) { /* Restore values in out. */
					out->aplptr.aplchar = cs;
					out->aplcount++;
				}
			}
			else
				aplerr = 120; /* no suspended function for branch */
			break;
		case RIGHT_PAREN:
			loop = aplwksp(out,cp,cpend);
			if (!loop) aplerr = 998; /* must be )off */
			break;
		case DEL:
			apledit(out,cp,cpend);
			break;
		default: 
			endoper(execute(out));
	} /* end switch */
	return(loop);
}
