/* Copyright (C) 1996 by Thomas Glen Smith.  All Rights Reserved. */
/* getvect APL2 V1.0.0 *************************************************
* Sends a prompt to the standard output file and obtains from standard *
* input a character string containing zero or more floating constants. *
* The string will be edited, and the user prompted for corrections if  *
* necessary. When all constants are valid, they will be converted to   *
* internal double floating point.  An aplcb will be initialized to     *
* point to this vector, and a pointer to the aplcb will be returned.   *
***********************************************************************/
#define MAXLINE 256
#define INCLUDES APLCB+STDIO
#include "includes.h"
Aplcb getvect(prompt)
char *prompt;
{
     Endoper; Vector;
	Aplcb out=NULL;
	char c,line[MAXLINE],*lp;
	int i,j,linelen;

	line[0]='\0';
	printf("\n%s\n",prompt);
	linelen=gettext(line,MAXLINE);
	while (1) {
		lp=line;
		out=vector(&lp,lp+linelen,0);
		if (linelen==(i=lp-line))
			break; /* input ok */
		/* invalid input */
		endoper(out);
		out=NULL;
		printf("Bad data, reenter:\n");
		linelen=edline(line,i,MAXLINE,1);
	}
	return(out);
}
