/* Copyright (C) 1995 by Thomas Glen Smith.	All Rights Reserved. */
/* grade2a APL2 V1.0.0 *************************************************
* Called from grade2 after rite has been converted to a matrix of	 *
* indices into the transpos of left of each character in rite, the     *
* result stored in out1, and a copy in out2.  Grade2a sorts,           *
* column-by-column, with a "leveling" applied after each column so     *
* that for e.g. left#2 3R'abcABC' and rite#3 3R'AbcabcAbb', leftWrite  *
* yields 1 2 3, but WleftIrite yields 1 3 2.                           *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb grade2a(out1,out2,up,rows,cols,div)
Aplcb out1;	/* Rite, converted to matrix of indices into left. */
Aplcb out2;	/* Copy of out1. */
int up;		/* Ascending=1, Descending=0. */
int rows;		/* Number of rows in out1, out2. */
int cols;      /* Number of cols in out1, out2. */
int div;		/* Leveling factor. */
{
	Endoper; Grade;
	extern int indxorg;
	Aplcb dimcb=NULL,out3;
	int i,*ip,j,k,m,n,*op,*sp;

	m = cols - 2; /* Original number of cols */
	for(i = 0; i < m; i++) { /* Once for each original col. */
		out3 = out1; out1 = out2; out2 = out3; /* Flip out1/2. */
		ip = out1->aplptr.aplint + i; /* Head of next column. */
		for(j = 0; j < rows; j++) { /* Make 2d last column 1 2 ..., */
			*(ip + m - i) = (up) ? j : rows - j; /* or ...2 1, */
			ip += cols; /* Depending on up. */
		}
		endoper(dimcb);
		dimcb = grade(out1,up); /* Go sort. */
		if (dimcb == NULL) break;
		sp = dimcb->aplptr.aplint; /* Vector of sort indices. */
		op = out2->aplptr.aplint; /* Output location. */
		for(j = 0; j < rows; j++) { /* Rearrange the rows. */
			ip = out1->aplptr.aplint + (*sp++ - indxorg) * cols;
			for(k = 0; k < cols; k++) {
				if (k == i)  /* Column just sorted? */
					*ip = (*ip - indxorg) / div;
				*op++ = *ip++; /* Copy out1 row to out2. */
			}
		}
	}
	if (dimcb != NULL) {
		op = dimcb->aplptr.aplint;
		ip = out2->aplptr.aplint + cols - 1; /* Original row indices. */
		while(rows--) {
			*op++ = *ip;
			ip += cols;
		}
	}
	return(dimcb);
}
