/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* monadic APL2 V1.0.0 *************************************************
* Maintained for compatibility with CAPLIB.                            *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb monadic(oper,rite)
double (*oper)(); /* operator */
Aplcb rite; /* operand */
{
	Getcb; Errinit; Errstop; Intcopy; Real;
	extern int aplerr;
	double *dataout,*datarite;
	int *dimptr,*dimrite,i;
	Aplcb out;

	if (errinit())
		return(errstop(0,NULL,rite,NULL));
	if (!(rite->aplflags & APLNUMB)) {
		rite=real(rite);
		if (aplerr)
			return(NULL);
	}
	out = getcb(NULL,rite->aplcount,APLNUMB+APLTEMP,
       rite->aplrank,NULL);
	if (out == NULL)
		return(errstop(0,NULL,rite,NULL));
	if (!out->aplcount)
		return(errstop(0,NULL,rite,out));
	if (out->aplrank>1)
		dimptr = intcopy(out->apldim,rite->apldim,
            out->aplrank,1);
	dataout = out->aplptr.apldata;
	datarite = rite->aplptr.apldata;
	for (i = out->aplcount; i > 0; i--)
		*dataout++ = (*oper)(*datarite++);
	return(errstop(0,NULL,rite,out));
}
