/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* quadrec APL2 V1.0.0 *************************************************
* Called from quadoutc initially, and recursively called by itself to  *
* print on standard output an APL variable.                            *
***********************************************************************/
#define INCLUDES STDIO+APLCB
#include "includes.h"
quadrec(rank,dimptr,pcp,lasttime)
int rank;      /* Number of dimensions pointed to by dimptr. */
int *dimptr;   /* Dimensions of input pointed to by pcp. */
char *pcp[];   /* Character data to be displayed. */
int lasttime;  /* 1 if last time call. */
{
	Aplnewl; Aplputch;
     extern int aplcurs;
     int i,last;

     if (dimptr == NULL) {
          aplputch(**pcp);
          aplcurs++; /* Bump count of characters in output line. */
     }
     else for (i=*dimptr; i>0; i--) {
          if (rank > 1) {
               last = (i == 1 && lasttime == 1);
               quadrec(rank-1,dimptr+1,pcp,last);
               if (!last) aplnewl(); /* Define a new line. */
          }
          else {
               aplputch(*(*pcp)++);
               aplcurs++; /* Bump count of characters in output line. */
          }
     }
}
