/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* quoteit APL2 V1.0.0 *************************************************
* Called by apledps.                                                   *
* line1 is set to line2 as a quoted string, e.g. "abc" becomes "'abc'" *
* and "don't" becomes "'don''t'".  Line1 had better be long enough.    *
***********************************************************************/
#define INCLUDES STRING
#include "includes.h"
void quoteit(line1,line2)
char *line1,*line2;
{
	int i;
	char ch,*in,*out;

	in = line2;
	out = line1;
	i = strlen(line2);
	*out++ = '\''; /* beginning quote */
	while (i--) {
		if ('\'' == (ch = *in++))
			*out++ = '\''; /* double up embedded quotes */
		*out++ = ch;
	}
	*out++ = '\''; /* ending quote */
	*out++ = '\0'; /* line terminator */
}
