/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* ravel2a APL2 V1.0.0 *************************************************
* Called by ravel2 to get the output aplcb.                            *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLCB
#include "includes.h"
Aplcb ravel2a(rite, axes, lodim, comcnt, newaxis)
Aplcb axes,rite; /* Original arguments.                               */
int	lodim,      /* Index (org 0) of lowest dimension being combined. */
	comcnt,     /* Count of dimensions being combined.               */
	newaxis;    /* New axis value.                                   */
{
	Dtacopy; Errstop; Getcb; Intcopy;
	extern int aplerr;
	Aplcb out;
	int datatyp,i,*ip;
     void *dataptr;

	for (;;) {
     	if (aplerr) break;
		datatyp = rite->aplflags & (APLMASK + APLAPL);
		out = getcb(NULL,rite->aplcount,datatyp + APLTEMP,
          	rite->aplrank-comcnt+1,NULL);
		if (aplerr) break;
		dataptr=dtacopy(out->aplptr.apldata,rite->aplptr.apldata,
			out->aplcount,1,datatyp);
		if (aplerr) break;
		if (lodim)
			ip = intcopy(out->apldim,rite->apldim,lodim,1);
		else ip = out->apldim;
		*ip++ = newaxis; /* new dimension */
		if ((i = lodim + comcnt) < rite->aplrank)
			ip = intcopy(ip,rite->apldim+i,rite->aplrank-i,1);
		break;
	}
	return(errstop(0,axes,rite,out));
}
