/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* scalaz APL2 V1.0.0 **************************************************
* Called from scalax to perform a builtin APL dyadic scalar function   *
* when axes were speciied.									 *
***********************************************************************/
#define INCLUDES APLCB+FUNCODES+FUNSTRUC
#include "includes.h"
Aplcb scalaz(pep,left,rite,axcb,big,lit,bigx,litx,leftx,ritex,datatyp)
void (*pep)(void*,void*,void*);
Aplcb left,rite,axcb,*big,*lit;
int *bigx,*litx,*leftx,*ritex,datatyp;
{
	Endoper; Getcb; Indexno; Indices; Intcopy;
	extern int aplerr, indxorg;
	Aplcb bigax, out;
	int i,*ip,j,k;

	out = getcb(NULL, (*big)->aplcount, datatyp + APLTEMP,
		(*big)->aplrank, NULL);
	if (out == NULL)
		return(NULL);
     if (out->aplrank > 1)
     	ip = intcopy(out->apldim,(*big)->apldim,out->aplrank,1);
	bigax = getcb(NULL,out->aplrank,APLTEMP+APLINT,1,NULL);
	if (bigax == NULL)
     	return(NULL);
	i = indxorg - 1;
	ip = intcopy(bigax->aplptr.aplint, &i, bigax->aplcount, 0);
	j = 1;
	for (i = 0; i < out->aplcount; i++) {
		indices( /* bump indexes for big */
			bigax->aplptr.aplint, /* index array to bump */
			out->apldim, /* dimensions */
			&j, /* current dimension index - used by indices */
			out->aplrank, /* number of dimensions */
			indxorg); /* index origin to use */
		*bigx = indexno( /* get index for big */
			out->aplrank, /* number of dimensions */
			NULL, /* index to dimensions */
			bigax->aplptr.aplint, /* indexes */
			out->apldim, /* dimensions */
			indxorg); /* index origin to use */
		*litx = indexno( /* get index for lit */
			(*lit)->aplrank, /* number of dimensions */
			axcb->aplptr.aplint, /* index to dimensions */
			bigax->aplptr.aplint, /* indexes */
			(*lit)->apldim, /* dimensions */
			indxorg); /* index origin to use */
		(*pep)( /* go perform dyadic scalar function */
			left->aplptr.aplchar + *leftx * left->aplsize,
			rite->aplptr.aplchar + *ritex * rite->aplsize,
			out ->aplptr.aplchar + i * out ->aplsize);
	}
	endoper(bigax);
	return(out);
}
