/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* slashtrc APL2 V1.0.0 ************************************************
* Called from slashtra to handle reduce/scan operator transform.		 *
***********************************************************************/
#define INCLUDES APLTOKEN+APLTOKCD+APLCHDEF+FUNSTRUC+APLDERIV+APLCB\
+TREE+FUNCODES
#include "includes.h"
void slashtrc(tok,funtok,dp)
Apltoken tok; /* token for slash, slash bar, slope, slope bar */
Apltoken funtok; /* token left of slash */
Aplderiv dp; /* derived function structure */
{
	Execfree; Execdyas; Getcode; Reducef; Scanfrnt;
	extern int aplerr;
	extern Treelist treehdr;
	void *fun;

	switch(((Codes *)(dp->deriv_op))->funky_code) {
		case SLASH:
		case SLASH_BAR:
			dp->deriv_func = reducef;
			break;
		case SLOPE:
		case SLOPE_BAR:
			dp->deriv_func = scanfrnt;
			break;
		default:
			aplerr = 999; /* internal error */
			exit(999);
	} /* end switch */
	if (funtok) {
		dp->deriv_left.funcode = getcode(&(dp->deriv_left.fun), funtok);
		execfree(funtok);
		if (DERIVED_FUNCTION == dp->deriv_left.funcode) {
			dp->deriv_left.type = DRV;
			dp->deriv_left.func.drv =
				((Aplderiv)(dp->deriv_left.fun))->deriv_func;
			((Aplderiv)(dp->deriv_left.fun))->deriv_flags |= DERPERM;
		}
		else dp->deriv_left.type = execdyas(dp->deriv_left.fun,
			&(dp->deriv_left.sdp),&(dp->deriv_left.func));
	}
	else aplerr = 79; /* missing function */
	if (aplerr) return; /* bad scalar */
	tok->token_code = DERIVED_FUNCTION;
	tok->token_ptr.token_function = dp;
}
