/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* transpos APL2 V1.0.0 ************************************************
* Interchanges elements of an APL variable along two or more           *
* coordinates.  The simplest case is a matrix, in which the rows       *
* and columns can be interchanged, e.g. ABC becomes ADG.               *
*                                       DEF         BEH                *
*                                       GHI         CFI                *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb transpos(left,rite)
Aplcb left,rite;
{
	Errinit; Errstop; Temp; Transpot; Vectin;
     extern int indxorg;
	int indxsave,tempsave;
     Aplcb out;

	if (errinit())
		return(errstop(0,left,rite,NULL));
/*	indxsave = indxorg; *//* save current index origin */
/*	indxorg = 1; *//* all work is relative 1 */
	if (0 == rite->aplrank)
		rite = temp(vectin(rite)); /* vectors only */
	if (tempsave = rite->aplflags & APLTEMP)
		rite->aplflags -= APLTEMP; /* temporarily permanent */
	out = transpot(left,rite);
	rite->aplflags += tempsave;
/*	indxorg = indxsave; *//* restore indxorg */
	return(errstop(0,NULL,rite,out));
}
