;   FILENAME: SPP.ASM
;

jumps      ; Have TASM automatically resolve out of range jumps

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "    definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

model	MDL,pascal	       ; Define the memory model
P286

Version EQU "1.00"

ideal

stack   4096           ; Allocate 4K stack

dataseg

STitle		db	9,"SuperProPlay Advanced v1.0By Joshua C. Jensen",0
BottomLine	db	"`F1`-`~?  `F2`-`~?  `F3`-`~?  `F4`-`~?  `F5`-`~?  `F6`-`~?  `F7`-`~?  `F8`-`~?  `F10`-`HELP",0
TopFileLine	db	"~~~~~ͻ",0
NameLine	db	" `NAME~- EXT ` `kbs ` `MODULE NAME~- ` `DRIVE `~ `File `0000 `of `0000 `",0
AfterNameLine	db	"~~~~~͹",0
BlankFileLine   db      "~ ~ ~ ~ ~ ",0
BottomFileLine	db	"~~~~~ͼ",0
TopBlankLine	db	"O~P ",0

db  '\'
HomeDirectory	db	MAX_PATH_LENGTH dup (0)
OldDrive	db	0

db  '\'
SPPDirectory	db	MAX_PATH_LENGTH dup (0)
SPPEnv		db	3,"SPP"

NoOpenModule	db	"Couldn't load in module...Press a key.",0

codeseg

SizeOfProg	dw	0

include "stdlib.inc"
include "globals.inc"
include "keytask.inc"
include "pps.inc"

codeseg

proc    WriteStandardInfo
	call	ms_hide
	call	Write,0,0,seg TopBlankLine,offset TopBlankLine
	call	Write,0,23,seg STitle,offset STitle
        call    Write,0,24,seg BottomLine,offset BottomLine
        call    WriteMemLeft,0
        call    ms_show
	ret
endp    WriteStandardInfo

proc    MainScreen
	call	ms_hide
	call	WriteStandardInfo
	call	Write,0,1,seg TopFileLine,offset TopFileLine
	call	Write,0,2,seg NameLine,offset NameLine
	call	Write,0,3,seg AfterNameLine,offset AfterNameLine
        mov     cx,4
@@LineLoop:
	call	Write,0,cx,seg BlankFileLine,offset BlankFileLine
	inc	cx
	cmp	cx,22
	jnz	@@LineLoop
	call	Write,0,22,seg BottomFileLine,offset BottomFileLine
	call	ms_show
	ret
endp    MainScreen

proc	CheckArrowKeys
	cmp	ax,4800h
        jnz     @@DownKey
        cmp     [Word CurFile],0
        jz      @@Beep
        dec     [Word CurFile]
        mov     bx,[CurFile]
        sub     bx,[TopFile]
        jns     @@PrintIt
        dec     [Word TopFile]
        jmp     @@PrintIt
@@DownKey:
        cmp     ax,5000h
        jnz     @@HomeKey
        mov     bx,[NumFiles]
        dec     bx
        cmp     [CurFile],bx
        jz      @@Beep
        inc     [Word CurFile]
        mov     bx,[CurFile]
        sub     bx,[TopFile]
        cmp     bx,18
        jl      @@PrintIt
        inc     [Word TopFile]
        jmp     @@PrintIt
@@HomeKey:
        cmp     ax,4700h
        jnz     @@EndKey
        cmp     [Word CurFile],0
        jnz     @@SetTop
        cmp     [Word TopFile],0
        jz      @@Beep
@@SetTop:
        mov     [Word CurFile],0
        mov     [Word TopFile],0
        jmp     @@PrintIt
@@EndKey:
        cmp     ax,4F00h
        jnz     @@PgUpKey
        mov     bx,[NumFiles]
        dec     bx
        cmp     [CurFile],bx
        jnz     @@SetBottom
        sub     bx,[TopFile]
        cmp     bx,18
        jl      @@Beep
@@SetBottom:
        mov     bx,[NumFiles]
        dec     bx
        mov     [CurFile],bx
        sub     bx,17
        js      @@FixBottom
        mov     [TopFile],bx
        jmp     @@PrintIt
@@FixBottom:
        mov     [Word TopFile],0
        jmp     @@PrintIt
@@PgUpKey:
        cmp     ax,4900h
        jnz     @@PgDnKey
        cmp     [Word CurFile],0
        jz      @@Beep
        sub     [Word CurFile],18
        js      @@FixPgUp
        sub     [Word TopFile],18
        js      @@FixPgUp2
        jmp     @@PrintIt
@@FixPgUp:
        mov     [Word CurFile],0
@@FixPgUp2:
        mov     [Word TopFile],0
        jmp     @@PrintIt

@@PgDnKey:
        cmp     ax,5100h
	jnz	@@ExitError
        mov     dx,[NumFiles]
        dec     dx
        cmp     [CurFile],dx
        jz      @@Beep
        add     [Word CurFile],18
        cmp     [CurFile],dx
        jg      @@FixPgDn
        add     [Word TopFile],18
        cmp     [Word TopFile],dx
        jg      @@FixPgDn2
        jmp     @@PrintIt
@@FixPgDn:
        mov     [Word CurFile],dx
@@FixPgDn2:
        sub     dx,17
        js      @@FixPgDn3
        mov     [TopFile],dx
        jmp     @@PrintIt
@@FixPgDn3:
        mov     [Word TopFile],0
        jmp     @@PrintIt
@@Beep: clc
	ret
@@PrintIt:
        call    DisplayFiles,[Word FileSeg+2],[Word FileSeg],[Word TopFile]
        call    DisplayFileMax,[Word CurFile],[Word NumFiles]
	clc
	ret
@@ExitError:
	stc
	ret
endp    CheckArrowKeys

proc    SelectFile
	uses	ds
	mov	ax,size FStruc
	mul	[CurFile]
        lds     di,[FileSeg]
        add     di,ax
	mov	dx,di
        cmp     [di+FStruc.TypeOfFile],F_Directory
	jnz	@@MustBeAModule
	mov	AH,3Bh
        int     21h             ;2-Change_Directory
        call    ReadFiles
	call	MainScreen
	call	DisplayAll
        ret
@@MustBeAModule:
	push	ds di dx
	call	sd_CloseAllMusic
	pop	dx di ds
@@LoadTheModule:
	call	sd_LoadModule
	jnb	@@ModuleLoadedOK
	call	WriteMemLeft,0
	call	FillBox,1,11,47,3,4F20h
	mov	bx,4Fh
	call	WriteCol,5,12,seg NoOpenModule,offset NoOpenModule
@@WaitForKey:
	call	Keys
	jz	@@WaitForKey
	call	MainScreen
	call	DisplayAll
	ret
@@ModuleLoadedOK:
	call	WriteMemLeft,0
	mov	dx,offset sd_KbdTask
	call	sd_PlayMusic
	ret
endp    SelectFile

proc    RunMain
@@TopLoop:
	call	MainScreen
	call	ReadFiles
	call	DisplayAll
	call	ms_show
@@KeyLoop:
	call	Keys
	cmp	ax,0
	jz	@@KeyLoop
	cmp	ax,27
	jnz	@@ArrowKeys
	call	sd_CloseAllMusic
	ret
@@ArrowKeys:
	call	CheckArrowKeys
	jnb	@@KeyLoop
	cmp	ax,13
	jnz	@@CheckF9
	call	SelectFile
	jmp	@@KeyLoop
@@CheckF9:
	cmp	ax,9
	jnz	@@CheckSt
	call	AltScrn1
	call	MainScreen
	call	DisplayAll
	jmp	@@KeyLoop
@@CheckSt:
	call	CheckStandardKeys
	jmp	@@KeyLoop
endp    RunMain



;Ŀ
;
;Ŀ
;

codeseg
SavedDS     dw	?	; For the control-break handler to find the path
			; variables for restoring the original path and
			; drive.


dataseg

PspAddress      dw      ?       ; Segment address of Program Segment Prefix(PSP)

codeseg

proc Main

;************************* Program Entry Point ***************************
; Execution of the program begins here.

EntryPoint:
	mov	ax, @data	; Initialize ds by moving segment address
	mov	ds, ax		; of data segment into ds register

	call	Initialize	; Initialize data structures, etc.

	call	RunMain
endp    main

proc    Terminate
	call	OffKbdTask
	call	sl_FreeAllHeap

	mov	ax, [SavedDS]
	mov	ds,ax

	mov	ah,0Eh
	mov	dl,[OldDrive]
	int	21h
	mov	ah,3Bh
	mov	dx,offset HomeDirectory - 1
	int	21h

	call	RestoreMode

;	 mov	 dx,[cs:SizeOfProg]
;	 mov	 ah,31h
;	 int	 21h
	mov	ax, 4C00h
	int	21h
endp	Terminate

proc	Initialize

	; Store the PSP address by storing es in the variable PspAddress.
	; Note that we do it this way instead of using DOS function 62h because
	; the function is only available on DOS 3.0 or later.

	mov	[PspAddress], es
	push	es
	mov	ax, seg PSPAddress
	mov	es, ax
	mov	bx, [es:PSPAddress]
	mov	es, bx
	mov	ax, zzzzzseg
	sub	ax, bx
	mov	bx,ax
	inc	bx			;Safety margin
	inc	bx
	mov	[cs:SizeOfProg],bx
	mov	ah, 4ah 		;Memory block resize opcode
	int	21h
	pop	es

	mov	ax,ds
	mov	[SavedDS],ax

	call	DetermineDisplay
	call	SetMode
	call	SetCursor,CursorOff

	mov	ah,47h
	mov	dl,0
	mov	si,offset HomeDirectory
	int	21h
	mov	ah,19h
	int	21h
	mov	[OldDrive],al

	mov	ax,[PspAddress]
	mov	cx,MAX_PATH_LENGTH
	push	ds
	pop	es
	mov	si,offset SPPEnv
	mov	di,offset SPPDirectory
	call	sl_EnvString
	mov	di,offset SPPDirectory
	cmp	[Byte di],0
	je	@@1
        mov     cx,MAX_PATH_LENGTH
@@LookLoop:
	cmp	[Byte di],0
	je	@@FoundIt
	inc	di
	loop	@@LookLoop
@@FoundIt:
	cmp	[Byte di-01h],'\'
	je	@@1
	mov	[Byte di],'\'
	mov	[Byte di+01h],0

@@1:
	call	HowMuchMemory
	mov	bx,255
	call	sd_InitSound
	call	sl_InitHeap

	xor	dx,dx
	mov	ax,size FStruc
	mov	bx,[MaxFiles]
	mul	bx
	call	sl_Allocate,ax,seg FileSeg,offset FileSeg

	mov	ax,@data
        mov     ds,ax
	call	ms_init
	call	SetKbdTask
	ret
endp	Initialize

segment zzzzzseg   ; Dummy final segment for calculating program size
                   ; to release memory back to DOS.
LastBytes	db	16 dup (?)
ends    zzzzzseg

endif   ; ifndef MDL

end EntryPoint
