// Converts MOD to M32   Version 1.01  32bit
// Not that good but I'm lazy.  I wanted to do the more important things
// like the actual m32 player!

// Warning : contains Watcom #pragma stuff  (BCC32.exe will not compile)

#include <qlib.h>
#include <file.h>

struct patst {
  byte b1,b2,b3,b4,b5,b6;
} pat1,pat2;

byte buf [1024];
//the mod 31 struct
struct modst {
   byte name[20];                              // 0
   struct {
     byte name[22];                                // 20
     word len;                                     // 42
     byte fine;
     byte vol;                                     // 44
     word rep;                                     // 46
     word replen;                                  // 48
   } instr[31];
   byte songlen;
   byte unknown;  //?   off=952d 3b8h
   byte songdat[128];
   dword mk;                                // Contains M.K.
   // patterns     (npat = largest found in playseq)
   // samples
};

word asm(word b);

#pragma aux asm = "xchg al,ah", parm [ax] modify [ax];

// M32 struc
struct m32st {
  byte head[6];       // header 'M32v1',26
  byte name[20];      // mod name ASCIIZ
  byte npat;          // number of patterns
  byte nch;           // # of channels (2/4/8/16/32)
  byte res;           // sound res. (8/16)
  word freq;          // sound freq (11K/22K/44.1K/other)
  byte spd;           // speed for note count (4=1/16th of second (min))
  byte nfreq;         // note freq.  (64 or 50)   50 for mods
  byte saminc;        // samples in file  (1=yes 0=no)
  byte reserved[3];   // reserved!!!
  byte songdat[256];  // 0=end of song  /292
  struct {  //36  //9180
    byte name[18];  //instrs name
    word vol;    //volume (0-255)  (in file!)
    dword slen;  //sample begin  (length)
    dword send;  //sample end    (0)
    dword repb;  //begin         (offset in own sample)
    dword reps;  //stop          (length of repeat)
  }instr[255];
  // offset=9472 so far?
  // patterns  (offset = 8442)
  // samples (offset = 8442 + (npat * nch * 64 * 5)
};

struct modst mod;
struct m32st m32;

void ee (byte errn) {
  switch (errn) {
    case 1:
    case 2:
      printf("Error:loading or saving MOD or M32 files!");
      break;
    case 3:
      printf("Error:MOD file not a mod file!");
      break;
  }
  exit(errn);
}

byte str1[80],str2[80];

void main (byte argc,byte **args) {
  int f1,f2;
  word a,b,c;
  dword t,sl,c1;
  byte b1;

  clrscr();
  printf(" MOD to M32 Converter : Version 1.01 32bit   by : Peter Quiring\n");
  if (argc<3) {
    printf("Usage: MOD2M32 modfile m32file [freq] [spd]\n");
    printf(" Defaults : freq=15872 and spd=4\n");
    printf(" use 0 to fill unwanted arguments\n");
    exit(0);
  }
  // 1 2 3 4 5
  strcpy(str1,args[1]);
  strcat(str1,".mod");
  strcpy(str2,args[2]);
  strcat(str2,".m32");

  f1=open(str1,O_BINARY|O_RDONLY);
  if (f1==-1) ee(1);
  f2=creat(str2,FA_ARCH);
  if (f2==-1) ee(2);
  close(f2);
  f2=open(str2,O_BINARY|O_WRONLY);
  if (f2==-1) ee(2);
  read(f1,&mod,sizeof(mod));

  // general stats.

  m32.saminc=1;
  m32.nfreq=50;
  memcpy(m32.name,mod.name,20);
  for(a=19;m32.name[a]==32;a--);
  a++;
  for(;a<20;m32.name[a]=0,a++);
  b=0;
  for(a=0;a<mod.songlen;a++) {
    m32.songdat[a]=mod.songdat[a]+1;
    if ((m32.songdat[a]-1)>b) b=m32.songdat[a];
  }
  for(;a<255;a++) m32.songdat[a]=0;
  m32.npat=b+1;
  m32.nch=4;
  m32.res=8;
  a=atoi(args[3]);
  a=(a/128)*128;
  if (a>0) m32.freq=a;
    else m32.freq=15862;
  //MOD's use 15909 but my sample speed must be / 128
  a=atoi(args[4]);
  if (a) m32.spd=a; else m32.spd=4;
  strcpy(m32.head,"M32v1");
  m32.head[5]=26;

  // instruments

  printf("Converting:%s => %s\n",str1,str2);
  for(a=0;a<31;a++) {
    memcpy(m32.instr[a].name,mod.instr[a].name,19);
    for(b=18;m32.instr[a].name[b]==32;b--);
    b++;
    for(;b<20;m32.instr[a].name[b]=0,b++);
    b=mod.instr[a].len;
    b=asm(b);
    m32.instr[a].slen=b*2;
    m32.instr[a].send=0;
    b=mod.instr[a].rep;
    b=asm(b);
    m32.instr[a].repb=b*2;
    b=mod.instr[a].replen;
    b=asm(b);
    m32.instr[a].reps=b*2;
    if (!m32.instr[a].repb) m32.instr[a].reps=0;
    m32.instr[a].vol=(mod.instr[a].vol)*4;
  }
  for(a=31;a<255;a++) {
    m32.instr[a].slen=0;
    m32.instr[a].send=0;
    m32.instr[a].repb=0;
    m32.instr[a].reps=0;
  }
  write(f2,&m32,sizeof(m32));

  //convert pattern
  //# of patterns to convert = npat
  //no fx converted (very little)

  //MOD format
  //pat1.b1=instr. / freq.
  //pat1.b2=freq.  / freq.
  //pat1.b3=instr. / eff.
  //pat1.b4=eff. data

  //M32 format
  //pat2.b1=instr. (0-255)
  //pat2.b2=freq. lo
  //pat2.b3=freq. hi
  //pat2.b4=fx cmd
  //pat2.b5=fx data #1
  //pat2.b6=fx data #2

  pat2.b4=0;
  pat2.b5=0;
  pat2.b6=0;

  for (a=0;a<m32.npat;a++) {
    for (c=0;c<64*4;c++) {
      read(f1,&pat1,4);
      pat2.b1=(pat1.b1&0xf0);
      pat2.b1+=(pat1.b3&0xf0)>>4;  //instr.
      b=((pat1.b1&0xf)<<8)+(pat1.b2);  //freq
      //358h=slow  97h=fast (amiga?)
      //358h=fast  97h=slow (mine!)
      b=0x358-(b-0x97);
      b-=90;
      pat2.b2= b&0x00ff;
      pat2.b3=(b&0xff00)>>8;
      write(f2,&pat2,6);
    }
  }
  //copy samples
  sl=0;  //sample length
  do{
    a=read(f1,buf,1024);
    //convert to unsigned!
    for (b=0;b<a;b++) {(*(buf+b))^=128;}
    if (a==0) break;
    sl+=a;
    write(f2,buf,a);
  }while(1);
  t=0;
  for (a=0;a<255;a++){
    t+=m32.instr[a].slen;
  }
  printf("Complete!\n");
  printf("  Stats:\n");
  printf("  no. patterns:%b\n",m32.npat);
  printf("  Sample len (is)    :%d\n",sl);   // what it is
  printf("  Sample len (should):%d",t);    // what it should be
  if (sl==t) printf(" Ok!\n");
  else if (sl>t) printf(" Too much?\n");
  else {
    printf(" Bad MOD format error! (output padded w/80h)\n");
    b1=0x80;
    for (c1=0;c1<t-sl;c1++) write(f2,&b1,1);
  }
  close(f1);
  close(f2);
}
