;loads a BMP into buf and the palette (if 8bpp) into bmppal

;supports -8bit and 24bit only

;does not support -8bit compression   (24bit can not be compressed)

.data
  bmppal db 768 dup (?)

  bmp4 db 256*4 dup (?)   ;RGBquad pal form (Win 3.0 BMP)
    ;b,g,r,reserved
;  bmp3 db 256*3 dup (?)   ;RGBtri pal form (OS/2 BMP)
    ;b,g,r

; * = ignored!
  win struct
    siz dd ?    ;40
    x dd ?
    y dd ?
    planes dw ?  ;1    ;*
    bpp dw ?
    comp dd ?    ;0=none  1=RLE8  2=RLE4
    size_image dd ?    ;*
    xpm dd ?           ;*
    ypm dd ?           ;*
    clrused dd ?       ;*
    clrimp dd ?        ;*
  win ends
  os2 struct
    siz dd ?    ;12
    x dw ?
    y dw ?
    planes dw ?  ;1    *
    bpp dw ?
  os2 ends
  head_main db 14 dup (?) ;main header  (always 1st)
  siz dd ?  ;1st element of win/os2  (to detect which one it is)
  head_win win <>    ;Win 3.0 BMP info block (2nd part if Win 3.0)
  head_os2 os2 <>    ;OS/2 info block (2nd part if OS/2)
; then palette and image
; palette 

;NOTE : Win 3.0 BMP uses a 4byte palette (B,G,R,resv)
;       OS/2 pal (B,G,R)
;     : to distingush between Win3.0 and OS/2 read 1 dword after main header
;         ==40 if Win3.x
;         ==12 if OS/2  (it's the size element of each mapinfo)

  bmp_x dw ?
  bmp_y dw ?
  bmp_bpp dw ?
  bmp_bypp dd ?
  h dw ?
.code
load_bmp proc,fil:dword,buf:dword
  pushad
  callp open,fil,0
  .if eax==ERROR
    popad
    mov eax,ERROR
    ret
  .endif
  mov h,ax
  callp read,h,offset head_main,sizeof head_main+4
  callp lseek,h,sizeof head_main,SEEK_SET
  .if siz==14  ;OS2
    callp read,h,offset head_os2,sizeof head_os2
    mov ax,head_os2.x
    mov bmp_x,ax
    mov ax,head_os2.y
    mov bmp_y,ax
    mov ax,head_os2.bpp
    mov bmp_bpp,ax
  .elseif siz==40  ;win 3.0
    callp read,h,offset head_win,sizeof head_win
    mov ax,wptr head_win.x
    mov bmp_x,ax
    mov ax,wptr head_win.y
    mov bmp_y,ax
    mov ax,wptr head_win.bpp
    mov bmp_bpp,ax
    .if head_win.comp
bad:
      callp printf,"\nInvalid BMP\n"
bad2:
      call end_it
    .endif
  .else
    callp printf,"\nUnknown file type!"
    jmp bad2
  .endif
  .if bmp_bpp==8
    .if siz==14  ;OS2 == RGB tri
      call do_tri 
    .else        ;Win == RGB quad (dumb!)
      call do_quad
    .endif
    mov bmp_bypp,1
  .elseif bmp_bpp==24
    ;no pal!
    mov bmp_bypp,3
  .else
    callp printf,"\nUnknown bpp (8/24 only!)"
    jmp bad2
  .endif

  movzx eax,bmp_x
  movzx ebx,bmp_y
  mul bmp_bypp
  mov xresb,eax     ;x*bpp
  mul ebx
  .if !bufsiz
    mov bufsiz,eax
    callp close,h
    popad
    xor eax,eax
    ret
  .endif
  callp read,h,buf,bufsiz
  .if eax!=bufsiz
    callp printf,"Bad BMP!"
    jmp bad2
  .endif
  callp invert_bmp,buf
  callp close,h
  popad
  xor eax,eax
  ret
load_bmp endp

do_quad proc
  callp read,h,offset bmp4,256*4
  mov ecx,256
  mov esi,offset bmp4
  mov edi,offset bmppal
@@:
  lodsb
  shr al,2  ;convert to 0-63 values
  mov [edi+2],al
  lodsb
  shr al,2  ;convert to 0-63 values
  mov [edi+1],al
  lodsb
  shr al,2  ;convert to 0-63 values
  mov [edi],al
  inc esi
  add edi,3
  dec ecx
  jnz @b
  ret
do_quad endp

do_tri proc
  callp read,h,offset bmppal,256*3
  mov ecx,256
  mov esi,offset bmppal
  mov edi,offset bmppal
@@:
  mov al,[esi]
  shr al,2  ;convert to 0-63 values
  mov bl,[esi+2]
  shr bl,2  ;convert to 0-63 values
  mov [edi+2],al
  mov [edi],bl
  shr bptr[edi+1],2
  add esi,3
  add edi,3
  dec ecx
  jnz @b
  ret
do_tri endp

