include qlib.inc
include error.inc
include file.inc
include string.inc
include math.inc
include key.inc

HEAP_MAX equ -1         ;max that will be alloced for heap
HEAP_MIN equ 1024 * 4   ;min size needed to run
HEAP_BASE equ 1024 * 0  ;If you need conventional RAM free then set this to
                        ;640K and recompile

.code  ;the 1st code!
  db 'QLIB',0  ;not needed but keep at least a dword here or debugger crashes
.data
  dd 0   ;must stay here
  _argv dd offset _args   ;this is argv!
  _args dd 64 dup (0) ; the pointers
  atexit dd _atexit1  ;proc to call to deinit stuff (may be chained just like
                      ; INTs are done)
  serror dw 0         ;system error (extended error code) see error.inc

.stack 16*1024  ;default 16K stack

.data?
  _argstr db 128 dup (?) ; arguments copied from PSP
  _argc dd ?             ; # of arguments
  _base dd ?             ;linear base of program segment
  _pmmode db ?           ;mode  1=raw 2=XMS 4=VCPI 8=DPMI
  _filename dd ?         ;pts to filename as loaded (also @ _argv[0*4])
  _size dd ?             ;size of the EXE file after LINKing
  _fpu db ?              ;80387 FPU?  0=no 1=yes
  _os db ?               ;I wanna do an OS detection thing
    ;0-DOS16
    ;1-Windows 3.x
    ;2-Windows 95
    ;3-Windows NT
    ;4-OS/2
    ;5-Desqview
  align 4 ;for speed!
  selcode dw ?           ;selctor for code
  seldata dw ?           ; " data
  selzero dw ?           ; " zero base
  dw ? ;make all perfectly aligned!
  _environ dd ?          ; environment offset
  _psp dd ?              ; PSP offset
  _ds dw ?  ; both loaded into Sregs during a real mode switching for
  _es dw ?  ; certain ints (10h,33h). Use it to send info to RM interrpt handlers
            ; both are set to the 8K block of RAM used in DOS32 file io

;private data
  ;saved vectors
  _int_10h df ?   ;df=6 bytes(for sel:offset)
  _int_33h df ?
  _int_21h df ?

  align 4
  rmcs callstruct <>  ;RM call struct
  _int dw ? ;interrupt # to call
  _saved_ints db 1024 dup (?) ;saved RM ints

include string.inc
include malloc.asm
include os.asm 
include mathinit.asm
include key.asm
.code

extern main:near

align 4
_entry32:
  cld

  mov eax,0ffffffffh
  push eax
  push ds
  pop ds
  pop eax
  mov ax,0ee00h
  int 31h
  mov _pmmode,dl
  mov selzero,bx
  mov gs,bx

  mov ax,0ee02h
  int 31h
  mov _base,ebx
  mov _size,edx
  mov _psp,esi
  mov _environ,edi
  mov _filename,ecx
  mov _es,ax
  mov _ds,ax

  mov selcode,cs
  mov seldata,ds

;save ALL RM INTS
  mov esi,0
  mov edi,offset _saved_ints
  mov ds,selzero
  mov ecx,256
  rep movsd   ;save 1024 bytes!!!
  mov ds,cs:seldata

;save selected PM ints
  mov ax,204h
  mov bl,21h
  int 31h
  ;cx:edx
  mov wptr[_int_21h+4],cx
  mov dptr[_int_21h+0],edx

  mov ax,204h
  mov bl,10h
  int 31h
  ;cx:edx
  mov wptr[_int_10h+4],cx
  mov dptr[_int_10h+0],edx

  mov ax,204h
  mov bl,33h
  int 31h
  mov wptr[_int_33h+4],cx
  mov dptr[_int_33h+0],edx

;set PM ints
  mov ax,205h
  mov bl,10h
  mov edx,offset _int10h
  mov cx,cs
  int 31h

  mov ax,205h
  mov bl,33h
  mov edx,offset _int33h
  mov cx,cs
  int 31h
  
;init all necessary
  call math_init
  .if eax==ERROR
    mov _fpu,0
  .else
    mov _fpu,1
  .endif
  call key_init

  ;setup _argv & _argstr
  mov esi,_psp
  add esi,80h
  mov edi,offset _argstr
  lodsb  ;al=size!
  xor ecx,ecx
  mov edx,1
  and al,7fh ;ensure no error
  jz done
  mov ebx,_argv  ;the [_argv+0] = file name (set later)
  add ebx,4

@@1:
  cmp byte ptr[esi],32   ;seperators
  jz @f
  cmp byte ptr[esi],255
  jz @f
  or ecx,ecx
  jnz notnew
  ;new string
  inc ecx
  inc edx
  mov [ebx],edi
  add ebx,4
notnew:
  movsb
  dec al
  jz done
  jmp @@1
@@:
  xor ecx,ecx  ;not at start
  mov byte ptr [edi],0
  inc edi
  inc esi
  dec al
  jz done
  jmp @@1
done:
  mov byte ptr [edi],0
  mov _argc,edx

  mov esi,_environ
;search for double 0
  dec esi
@@:
  inc esi
  cmp word ptr[esi],0
  jnz @b
  add esi,4  ;skip 0/0/word
  mov _filename,esi
  mov ebx,_argv
  mov [ebx+0],esi

;  mov edx,"\n$"  ;print enter after the DOS32 logo cause it leaves some
;  mov ah,9       ;char colors after it.
;  int 21h

  call os_detect

;debugger here
  extern debug_run:near
  call debug_run

  call malloc_init    ;debug must come before malloc_init so that debugger can
                      ; get some RAM before malloc_init grabs it all.

  xor eax,eax
  xor ebx,ebx
  xor ecx,ecx
  xor edx,edx
  xor ebp,ebp
  xor esi,esi
  xor edi,edi
;call main() procedure here
  int 3  ;call up debugger if it is loaded
         ;if nodebug.obj is loaded then DOS32 will just ignore this INT 3
         ;you'll see this INT 3 when you debug (better than before!)

  push _argv
  push _argc
  call main
  add esp,8
  push eax   ;got this from OBJ hacks... anyways...
  call exit
;end of _entry32

uninitall proc
  pushad
@@:
  call [atexit]
  cmp atexit,nullproc
  jnz @b
  popad
  ret
uninitall endp

exit proc,el:byte
  mov ds,cs:seldata
  mov es,seldata
  mov fs,seldata
  mov gs,selzero

  call uninitall

;  If your video card is trashed after debugging unrem below 2 lines
;   I had a problem with my CL-VLB but now I've got a CL-PCI and no probs
;  mov ax,3    ;the debugger leaves my video card in such an aweful state
;  int 10h     ; don't trace over this oviously

  mov al,el
  mov ah,4ch
  int 21h   ;this is the only place I allow this to be done. Don't do it in
            ; your own code!  Or things will not get uninit
exit endp

abort proc
  mov edx,"Abnormal program termination\n$"
  mov ah,9
  int 21h
  callp exit,3
abort endp

getint proc,v:byte
  pushad
  mov ax,204h
  mov bl,v
  int 31h
  mov [esp+7*4],cx   ;ax
  mov [esp+5*4],edx  ;edx
  popad
  ret
getint endp ;ax:edx = vector

setvect proc,v:byte,off:dword
  callp setint,v,cs,off
  ret
setvect endp

getvect proc uses edx,v:byte
  callp getint,v
  mov eax,edx
  ret
getvect endp

setint proc,v:byte,s:word,off:dword
  pushad
  mov ax,205h
  mov bl,v
  mov cx,s
  mov edx,off
  int 31h
  jc notgood
  popad
  xor eax,eax
  ret
notgood:
  popad
  mov eax,ERROR
  mov serror,0
  ret
setint endp ;ax=0

getrmint proc uses ebx,v:byte
  movzx ebx,v
  shl ebx,2
  xor edx,edx
  xor eax,eax
  cli
  mov dx,gs:[ebx]   ;offset   ;FIXED V1.2 : was using eax after I loaded it
  mov ax,gs:[ebx+2] ;seg
  sti
  ret
getrmint endp  ;ax:dx = vektor

setrmint proc uses ebx,v:byte,s:word,off:word
  movzx eax,v
  shl eax,2   ;*4
  cli
  mov bx,off
  mov gs:[eax],bx
  mov bx,s
  mov gs:[eax+2],bx
  sti
  xor eax,eax
  ret
setrmint endp

;calls your PMODE function when seg:off (which is returned from here)
; is run by something (just set a RM int to what is returned)
; note: your proc must end with 'retf'

;this is for FAR CALL stack frame (I think I use this for the mouse callback
;  thingy)
;ax:dx = RM seg:off to call far
alloc_rmcallback proc,off:dword
  ;off = your procedure
  pushad
  mov ax,0ee20h  ;was 303h w/PMODE V3.07
  mov esi,off
  int 31h
  jc notgood
  mov [esp+7*4],cx  ;ax
  mov [esp+5*4],dx  ;dx
  popad
  movzx eax,ax
  movzx edx,dx
  ret
notgood:
  popad
  mov eax,ERROR
  mov serror,0
  ret
alloc_rmcallback endp

;this is for IRET stack frame (use this one mostly for RM INTS)
alloc_rmintcallback proc,off:dword
  ;off = your procedure
  pushad
  mov ax,0ee21h  ;was 303h w/PMODE V3.07
  mov esi,off
  int 31h
  jc notgood
  mov [esp+7*4],cx  ;ax
  mov [esp+5*4],dx  ;dx
  popad
  movzx eax,ax
  movzx edx,dx
  ret
notgood:
  popad
  mov eax,ERROR
  mov serror,0
  ret
alloc_rmintcallback endp

;returns:
;  successful: eax - environment string after the = sign
;  error : eax=ERROR  (not NULL anymore!! - everything uses ERROR from now on)
getenv proc uses ecx esi edi,nam:dword
  local siz:word
  callp strlen,nam
  mov siz,ax
  mov edi,_environ
@@top:
  cmp byte ptr [edi],0
  jz @@bad
  mov cx,siz
  mov esi,nam
@@:
  cmp byte ptr [edi],'='
  jz @f
  cmpsb
  jnz @f
  dec cx
  jnz @b
  jmp @@gotit
@@: ;not the one
  dec edi
@@:
  inc edi
  cmp byte ptr [edi],0
  jnz @b
  inc edi
  jmp @@top
@@gotit:
  inc edi ;skip the =
  mov eax,edi  ;FIXED Ver1.1 !!!
  ret
@@bad:
  mov eax,ERROR
  ret
getenv endp

lock_ram proc,off:dword,siz:dword
  .if _pmmode<8
    xor eax,eax
    ret
  .endif
  pushad
  mov ax,600h
  mov ebx,off
  mov esi,siz
  mov cx,bx
  mov di,si
  shr ebx,16
  shr esi,16
  int 31h
  jc bad
  popad
  xor eax,eax
  ret
bad:
  popad
  mov eax,ERROR
  mov serror,0
  ret
lock_ram endp

unlock_ram proc,off:dword,siz:dword
  .if _pmmode<8
    xor eax,eax
    ret
  .endif
  pushad
  mov ax,601h
  mov ebx,off
  mov esi,siz
  mov cx,bx
  mov di,si
  shr ebx,16
  shr esi,16
  int 31h
  jc bad
  popad
  xor eax,eax
  ret
bad:
  popad
  mov eax,ERROR
  mov serror,0
  ret
unlock_ram endp

nullproc proc
  ret
nullproc endp

_atexit1 proc private
  mov atexit,nullproc  ;your proc should restore the atexit you saved during
                       ;init.

  ;restore all RM ints
  mov esi,offset _saved_ints
  mov edi,0
  mov es,selzero
  mov ecx,256
  rep movsd
  mov es,seldata
  call _atexit2
  ret
_atexit1 endp

_atexit2 proc private
  mov ax,205h
  mov bl,10h
  mov cx,wptr[_int_10h+4]
  mov edx,dptr[_int_10h+0]
  int 31h

  mov ax,205h
  mov bl,33h
  mov cx,wptr[_int_33h+4]
  mov edx,dptr[_int_33h+0]
  int 31h

  mov ax,205h
  mov bl,21h
  mov cx,wptr[_int_21h+4]
  mov edx,dptr[_int_21h+0]
  int 31h
  ret
_atexit2 endp

  align 4
_int10h:
  sti
  push ds
  push es
  mov ds,cs:seldata
  mov es,seldata
  mov _int,10h
  jmp _gen_int
  
  align 4
_int33h:
  sti
  push ds
  push es
  mov ds,cs:seldata
  mov es,seldata
  mov _int,33h
  jmp _gen_int

  align 4
_gen_int:   ;general int
  ;ds & es must == seldata
  push edi
  mov edi,offset rmcs
  pop dptr[edi+0h]
  mov dptr[edi+4h],esi
  mov dptr[edi+8h],ebp
  mov dptr[edi+0ch],0
  mov dptr[edi+10h],ebx
  mov dptr[edi+14h],edx
  mov dptr[edi+18h],ecx
  mov dptr[edi+1ch],eax
  mov wptr[edi+20h],0  ;flags
  mov ax,_es
  mov wptr[edi+22h],ax
  mov ax,_ds
  mov wptr[edi+24h],ax
  mov wptr[edi+26h],0  ;FS
  mov wptr[edi+28h],0  ;GS
  mov wptr[edi+2ah],0  ;IP ;
  mov wptr[edi+2ch],0  ;CS ;ignored
  mov wptr[edi+2eh],0  ;SP ;
  mov wptr[edi+30h],0  ;SS ;dito (but must be 0)

  mov ax,300h
  mov bx,_int
  mov cx,0
  int 31h
  jc bad_gen_int
  mov esi,dptr[edi+4]
  mov ebp,dptr[edi+8]
  mov ebx,dptr[edi+10h]
  mov edx,dptr[edi+14h]
  mov ecx,dptr[edi+18h]
  mov al,bptr[edi+20h]
  and al,1  ;mask carry flag
  ; current stack
  ; ESP=>es,ds,off,sel,flags
  and bptr[esp+16],0feh
  or [esp+16],al   ;set carry from interrupt
  mov eax,dptr[edi+1ch]
  mov edi,dptr[edi]

  pop es
  pop ds
  iretd    ;flags updated from above.

bad_gen_int:
  ; BUG : this may crash a lot o things! If I can't call a simple INT
  ;  most likely the system has become unstable for some unseen reason!!!
@@:
  call [atexit]
  cmp atexit,nullproc
  jnz @b
  call abort

end _entry32
