;Grafical User Interface  Ver 1.00
 ;only for 256 color modes!

include qlib.inc
include video.inc
include gui.inc
include guim.inc
include file.inc
include string.inc
include key.inc

;define lists/sliders/etc that are active Updating massive lists and SUCH
.data
  cfg gui_cfg <>
  curdir1 db 128 dup (?)  ;temp for CD (used in gui_filelist)

;  mb1 db ?  ;Mouse button status#1  (0=nothing  1=on) Not used (I just use the reg cl)
  mb2 db ?  ;Mouse button status#2  (0=nothing  1=on)  ;button #2 will cause
    ;a reaction to a button without having to release (it's used to move
    ; down lists fast and cause a button to be used rapidly)  Using button #1
    ; must be pushed/released for each action to be done
    ; on RET : eax=ID#           if mba=1 or mb2=1
    ;          edx=string (if type=2 (list)) 
    ;     else eax=0
align 4
  mx dd ?   ;current loc
  my dd ?
  msx dd ?  ;start click here
  msy dd ? 
  mrx dd ?  ;released here
  mry dd ?  
  mna2 db 0  ;used to tell when we have pushed in button #1
  mna db 0  ;mouse not avail.  is set when button#1 is released
            ;and is not recogizied until this =0 (this is used to tell
            ;when the above is available)
  mnab2 db 0  ;thingy for button #2 (like mna is to #1)
  id dd 0  ;ID # of button currently being pushed
  typ db ? ;current type being used
  vcopy db 0  ;indicates that a v_copy is needed at beginning of gui_update
  win dd 0  ;current LIST of objects
  fileblk ffblk <>
  drvtab db 26 dup (0)  ;=1 if drive exists

;cursors for the file lists
  a_sizx equ 9
  a_sizy equ 9
  a_up label byte
    db 1,1,1,1,1,1,1,1,1
    db 1,1,1,1,0,1,1,1,1
    db 1,1,1,0,0,0,1,1,1
    db 1,1,0,0,0,0,0,1,1
    db 1,0,0,0,0,0,0,0,1
    db 1,0,0,0,0,0,0,0,1
    db 1,0,0,0,0,0,0,0,1
    db 1,0,0,0,0,0,0,0,1
    db 1,1,1,1,1,1,1,1,1
  a_dw label byte
    db 1,1,1,1,1,1,1,1,1
    db 1,0,0,0,0,0,0,0,1
    db 1,0,0,0,0,0,0,0,1
    db 1,0,0,0,0,0,0,0,1
    db 1,0,0,0,0,0,0,0,1
    db 1,1,0,0,0,0,0,1,1
    db 1,1,1,0,0,0,1,1,1
    db 1,1,1,1,0,1,1,1,1
    db 1,1,1,1,1,1,1,1,1

include gui-en.asm
include gui-dis.asm
include gui-edit.asm

.code

gui_user  proto

drvsetup proc private
  local drv:byte,tmp:byte
  mov ah,19h  ;get current drive
  int 21h
  mov tmp,al
  mov ebx,offset drvtab+2
  mov drv,2  ;BUG : Skipping DRIVE A,B until I can detect which is REALLY
             ;avail.  Trying to read from a floppy drive pops up that damn
             ;"insert disk" while the kbd IRQ is grabbed (system halted!)
@@:
  mov ah,0eh  ;set current drive
  mov dl,drv
  int 21h
  mov ah,19h  ;get current drive
  int 21h
  cmp al,drv   ;if get!=set then that drive is not present
               ;does not even cause a search for media (ie. floppies donot spin)
  setz byte ptr[ebx]  ;set means that drive exists!
@@loop:
  inc ebx
  inc drv
  cmp drv,26
  jnz @b
  mov ah,0eh  ;set current drive
  mov dl,tmp
  int 21h
  ret
drvsetup endp

gui_init proc,config:dword
  pushad
  mov esi,config
  mov edi,offset cfg
  mov ecx,sizeof cfg
  rep movsb

  mov id,0

  call drvsetup

  callp mouse_setuser,offset gui_user

  mov esi,cfg.font
  movzx eax,[esi].fnthead.x
  mov cfg.fontx,eax
  movzx eax,[esi].fnthead.y
  mov cfg.fonty,eax
              
  popad
  xor eax,eax
  ret
gui_init endp

gui_user proc private ;called duing mouse actitity  DURING IRQ!!!!!!
  ;can't call back user cause he'll try and load a file or somethin'
  ;ax=x bx=y cx=buttons

  movzx eax,ax
  movzx ebx,bx

  mov mb2,cl
  and mb2,2
  mov mx,eax
  mov my,ebx

  .if mna
    mov mb2,0  ;wait till click is used
    mov mnab2,0
    ret
  .endif

  .if cl&1  ;button one is in!
    .if (!mna)&&(!mna2)
      inc mna2
      mov msx,eax  ;click Start
      mov msy,ebx
    .endif
  .else     ;button one is out!
    .if mna2
      dec mna2
      inc mna
      mov mrx,eax  ;click Release
      mov mry,ebx
    .endif
  .endif
  .if mna||mna2  ;button 1 is in use
    mov mb2,0
    mov mnab2,0
  .else
    .if mb2
      .if !mnab2
        inc mnab2
        mov msx,eax  ;click Start
        mov msy,ebx
      .else
        mov mrx,eax  ;click release
        mov mry,ebx
      .endif
    .else
      mov mnab2,0
    .endif
  .endif
  ret
gui_user endp

gui_update proc,vp:dword   ;call to GET status and update lists/buttons etc.
  ; vp=1 if do v_copy regardless if GUI needs to or not
  ;   =0 do v_copy only if needed
  ;ret : eax=ID # of button/list
  ;      edx=list entry name (only if eax=ID # of a list)
  local oldfont:dword
  pushad
  call ggetfnt
  mov oldfont,eax
  callp gsetfnt,cfg.font

  xor al,al
  xchg al,mna
  .if (!al)&&(!mb2)
    jmp fail
  .endif
    
  mov esi,win
  mov eax,msx
  mov ebx,msy
  mov ecx,mrx
  mov edx,mry
@@:
  .if !esi
    jmp fail
  .endif
  test [esi].datx.en,1
  jz fail2
  cmp eax,[esi].datx.x1
  jb fail2
  cmp eax,[esi].datx.x2
  ja fail2
  cmp ebx,[esi].datx.y1
  jb fail2
  cmp ebx,[esi].datx.y2
  ja fail2

  cmp ecx,[esi].datx.x1
  jb fail2
  cmp ecx,[esi].datx.x2
  ja fail2
  cmp edx,[esi].datx.y1
  jb fail2
  cmp edx,[esi].datx.y2
  ja fail2

  mov edx,[esi].datx.id
  mov id,edx
  mov dl,[esi].datx.typ
  mov typ,dl
  jmp @f
fail2:
  mov esi,[esi].datx.next
  jmp @b

@@:
  ;eax/ebx = mouse pt. (used in list selections)

  .if typ==1
    mov eax,id
    xor edx,edx
    jmp done
  .elseif typ==2
    mov ecx,[esi].dat2.x2
    sub ecx,a_sizx
    .if eax<ecx
      ;selecting entry
      mov eax,ebx
      sub eax,[esi].dat2.y1
      mov ebx,cfg.fonty
      xor edx,edx
      div ebx
      ;eax=entry#
      add eax,[esi].dat2.pos
      mov edx,eax
      imul edx,14  ;size of each entry
      add edx,[esi].dat2.list
      mov eax,id
      jmp done
    .else
      ;slider/cursors
      mov ecx,[esi].dat2.y1
      add ecx,a_sizy
      .if ebx<ecx
        .if [esi].dat2.pos
          dec [esi].dat2.pos
          callp gui_enable,id  ;reenable just to reprint it
          mov vcopy,1
        .endif
        jmp fail ;nothing to return
      .endif
      mov ecx,[esi].dat2.y2
      sub ecx,a_sizy
      .if ebx>ecx
        mov eax,[esi].dat2.pos
        .if eax<[esi].dat2.listsiz
          inc [esi].dat2.pos
          callp gui_enable,id
          mov vcopy,1
        .endif
      .else
        ;slider!  Ignore for now... BUG!!
      .endif
      jmp fail  ;nothin to ret
    .endif
  .elseif typ==3
    call edit_str  ;found in gui-edit.asm
    mov eax,id ;to indicate that it has been edited
    xor edx,edx
    jmp done
  .endif
  ;else unknown & fail
fail:
  xor eax,eax
  xor edx,edx
done:
  mov dptr[esp+7*4],eax
  mov dptr[esp+5*4],edx
  callp gsetfnt,oldfont
  .if (vcopy)||(vp)  ;due to an element being enabled/disabled ;list movement etc.
    mov vcopy,0
    call v_copy
  .endif
  popad
  ret
gui_update endp

gui_addlist proc,list:dword
  ;alloc RAM,validate as much as possible
  pushad
  mov esi,list
@@:
  mov dl,[esi].datx.typ
  .if dl==2   ;file lists
    .if !([esi].dat2.list)
      callp malloc,(512*14+1)
      .if eax==ERROR
        popad
        mov eax,ERROR
        ret
      .endif
      mov [esi].dat2.list,eax
    .endif
    mov ecx,[esi].dat2.x1
    mov eax,cfg.fontx
    imul eax,14   ;# chars wide  "\12345678.123"
    add ecx,eax
    add ecx,a_sizx ;and size of bar/arrows
    mov [esi].dat2.x2,ecx
    mov eax,[esi].dat2.y2
    sub eax,[esi].dat2.y1
    inc eax
    xor edx,edx
    mov ecx,cfg.fonty
    div ecx
    mov [esi].dat2.yl,eax
    mul cfg.fonty
    add eax,[esi].dat2.y1
    mov [esi].dat2.y2,eax
  ;valid somethings
    lea ebx,[esi].dat2.cd
    .if !bptr[ebx]
      callp strcpy,ebx,"C:\"  ;default cd if none given (that's bad!!)
    .endif
  .elseif dl==3
    ;calc xl
    mov eax,[esi].dat3.x2
    sub eax,[esi].dat3.x1
    sub eax,2  ;the boarders
    xor edx,edx
    mov ecx,cfg.fontx
    div ecx
    mov [esi].dat3.xl,eax
  .endif
  mov ecx,[esi].datx.next
  .if ecx
    mov esi,ecx
    jmp @b
  .endif

  or [esi].datx.en,2   ;indicates end of list
  .if !win
    mov eax,list
    mov win,eax
    popad
    xor eax,eax
    ret
  .endif
  mov esi,win
  ;search for last entry and patch to pt to list (make sure that enable=2)
  ; to indicate it's an end of list
@@:
  mov ecx,[esi].datx.next
  .if ecx
    mov esi,ecx
    jmp @b
  .endif

  mov eax,list
  mov [esi].datx.next,eax
  popad
  xor eax,eax
  ret
gui_addlist endp

gui_uninit proc
  pushad
  callp mouse_setuser,NULLPROC
  call mouse_off
@@:
  mov esi,win
@@:
  .if !esi
    jmp @f
  .endif
  .if [esi].datx.typ==2
    callp free,[esi].dat2.list
  .endif
  mov esi,[esi].datx.next
  jmp @b
@@:
  popad
  xor eax,eax
  ret
gui_uninit endp

gui_filelist proc,_id:dword,fls:byte,dirs:byte,drvs:byte
  local ls:dword ;listsiz
  pushad
  mov ls,0
  mov esi,win
  mov eax,_id
@@:
  .if !esi
    popad
    mov eax,ERROR
    ret
  .endif
  .if [esi].datx.id==eax
    jmp @f
  .endif
  mov esi,[esi].datx.next
  jmp @b
@@:
  .if [esi].datx.typ!=2
    popad
    mov eax,ERROR
    ret
  .endif
  mov ebx,[esi].dat2.list
  mov ecx,512-26  ;MAX # of dirs/files
  .if dirs
    lea eax,[esi].dat2.cd
    callp strcpy,offset curdir1,eax
    callp strcat,offset curdir1,"\\*.*"
    callp findfirst,offset curdir1,10h,offset fileblk
@@:
    .if eax==ERROR
      jmp @f
    .endif
    .if fileblk.ff_attrib==10h
      inc ls
      dec ecx
      mov bptr[ebx],'\'
      inc ebx
      callp strcpy,ebx,offset fileblk.ff_name
      add ebx,13
    .endif
    .if !ecx
      jmp @f
    .endif
    callp findnext,offset fileblk
    jmp @b
  .endif
@@:
  .if fls && ecx
    lea eax,[esi].dat2.cd
    callp strcpy,offset curdir1,eax
    callp strcat,offset curdir1,"\\"
    callp strcat,offset curdir1,[esi].dat2.msk
    callp findfirst,offset curdir1,0h,offset fileblk
@@:
    .if eax==ERROR
      jmp @f
    .endif
    inc ls
    dec ecx
    callp strcpy,ebx,offset fileblk.ff_name
    add ebx,14
    .if !ecx
      jmp @f
    .endif
    callp findnext,offset fileblk
    .if eax!=ERROR
      jmp @b
    .endif
  .endif
@@:
  .if drvs
    mov cl,'A'  ;Drive letter
    mov edx,offset drvtab
@@:
    .if byte ptr[edx]
      mov bptr[ebx+0],'['
      mov bptr[ebx+1],cl
      mov bptr[ebx+2],':'
      mov bptr[ebx+3],']'
      mov bptr[ebx+4],0
      inc ls
      add ebx,14
    .endif
    inc cl
    inc edx
    .if cl<='Z'
      jmp @b
    .endif
  .endif
  mov bptr[ebx],0  ;EOL
  mov eax,ls
  mov [esi].dat2.listsiz,eax
  popad
  xor eax,eax
  ret
gui_filelist endp

end
