;Mixing routines

; mix 8bit samples into 16bit stereo

; this one will produce best results!

.code
align 4
mix_8_16 proc private
  local len:word    ;=350 or 448
  local sndr:dword  ;current sample sound
  local sndl:dword  ;current sample sound

  mov ax,m32_size
  mov len,ax
  mov edi,m32_buf1_rel
  cmp m32_cbuf,0
  jz start
  mov edi,m32_buf2_rel
start:
  mov cl,m32_header.nch
  mov ebx,offset trkl
  mov sndl,0  ;temp data (output to [EDI])
  mov sndr,0  ;temp data (output to [EDI])
m32_mixstart:
  cmp [ebx].m32_trks.on,0  ;channel on?
  jz skipch
  mov esi,[ebx].m32_trks.off ;channel in use?
  cmp esi,0
  jz skipch
  mov ax,[ebx].m32_trks.freq
  add [ebx].m32_trks.of,al  ;overflow
  movzx edx,ah
  adc esi,edx
  ;check if over
  cmp esi,[ebx].m32_trks.send  ;channel past end?
  jb @f
  cmp [ebx].m32_trks.repb,0
  jz skipch ;no repeat
  mov esi,[ebx].m32_trks.repb ;begin
  mov eax,[ebx].m32_trks.reps ;stop
  mov [ebx].m32_trks.send,eax
@@:
  mov [ebx].m32_trks.off,esi
  mov al,[esi]

  ;3 imuls / sample!  ahhhhh.......
  xor al,80h  ;convert to signed
  movsx ax,al
  imul word ptr[ebx].m32_trks.vol
  movsx ax,ah
  push ax
    ;left
    imul word ptr[ebx].m32_trks.voll
    xor ax,8000h
    movzx eax,ax
    add sndl,eax
  pop ax
    ;right
    imul word ptr[ebx].m32_trks.volr
    xor ax,8000h
    movzx eax,ax
    add sndr,eax
  jmp @f

skipch:
  mov [ebx].m32_trks.off,0
  add sndr,8000h
  add sndl,8000h
@@:
  add ebx,sizeof m32_trks
  dec cl
  jnz m32_mixstart

  mov cl,bitsht
  mov eax,sndl
  shr eax,cl
  mov [edi],ax
  inc edi
  inc edi
  mov eax,sndr
  shr eax,cl 
  mov [edi],ax
  inc edi
  inc edi
  dec len
  jnz start

  ret
mix_8_16 endp

