include qlib.inc  ;setup
include file.inc
include string.inc
include private.inc

.data
  ;used by sscanf & str2num
_str2num_siz_ dd ?    ;this is how many letters str2num_* used from src

.code
num2str_1:
  ;ds:esi=string start
  ;ecx=# of bytes to output
  ;ax=number
  ;bx=base # (10 or 16)
  add esi,ecx
  dec esi
  mov byte ptr[esi+1],0
num2str_2:
  xor dx,dx
  div bx
  cmp dl,10
  jb @f
  add dl,7   ;'A'-'0'-10
@@:
  add dl,48  ;'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz num2str_2
  ret

num2str_d proc,a:dword,off:dword
  pushad
  mov ebx,10
  mov esi,off
  add esi,9  ;one less!
  mov byte ptr [esi+1],0
  mov eax,a
  mov ecx,10
@@:
  sub edx,edx
  div ebx
  add dl,'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz @b
  popad
  xor eax,eax
  ret
num2str_d endp

num2str_ds proc,a:dword,off:dword
  pushad
  mov ebx,10
  mov esi,off
  mov eax,a
  mov dl,'+'
  test eax,80000000h
  jz @f
  mov dl,'-'
  neg eax
@@:
  mov byte ptr [esi],dl
  add esi,10    ;one less
  mov byte ptr [esi+1],0
  mov ecx,10
@@:
  sub edx,edx
  div ebx
  add dl,'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz @b
  popad
  ret
num2str_ds endp

num2str_dh proc,a:dword,off:dword
  pushad
  mov ebx,10h
  mov esi,off
  add esi,7   ;always one less
  mov byte ptr [esi+1],0
  mov eax,a
  mov ecx,8
@@:
  sub edx,edx
  div ebx
  cmp dl,10
  jb temp1
  add dl,7     ;(17) ;'A'-'0' but already at A
temp1:
  add dl,48    ;'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz @b
  popad
  ret
num2str_dh endp

num2str_db proc,a:dword,off:dword
  pushad
  mov esi,off
  add esi,31
  mov byte ptr [esi+1],0
  mov eax,a
  mov ecx,32
@@:
  mov dl,al
  shr eax,1
  and dl,1
  add dl,'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz @b
  popad
  ret
num2str_db endp

num2str_bs proc,a:byte,off:dword
  pushad
  mov al,a
  mov esi,off
  xor ah,ah
  mov dl,'+'
  test al,10000000b
  jz @f
  mov dl,'-'
  neg al
@@:
  mov byte ptr [esi],dl
  inc esi
  mov ecx,3
  mov bx,10
  call num2str_1
  popad
  ret
num2str_bs endp

num2str_b proc,a:byte,off:dword
  pushad
  mov al,a
  mov esi,off
  xor ah,ah
  mov ecx,3
  mov bx,10
  call num2str_1
  popad
  ret
num2str_b endp

num2str_bh proc,a:byte,off:dword
  pushad
  mov al,a
  mov esi,off
  xor ah,ah
  mov ecx,2
  mov bx,10h
  call num2str_1
  popad
  ret
num2str_bh endp

num2str_bb proc,a:byte,off:dword
  pushad
  mov esi,off
  add esi,7
  mov byte ptr [esi+1],0
  mov al,a
  mov ecx,8
@@:
  mov dl,al
  shr al,1
  and dl,1
  add dl,'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz @b
  popad
  ret
num2str_bb endp

num2str_ws proc,a:word,off:dword
  pushad
  mov ax,a
  mov esi,off
  mov dl,'+'
  test ah,10000000b
  jz @f
  mov dl,'-'
  neg ax
@@:
  mov byte ptr [esi],dl
  inc esi
  mov ecx,5  
  mov bx,10
  call num2str_1
  popad
  ret
num2str_ws endp

num2str_w proc,a:word,off:dword
  pushad
  mov ax,a
  mov esi,off
  mov ecx,5  
  mov bx,10
  call num2str_1
  popad
  ret
num2str_w endp

num2str_wh proc,a:word,off:dword
  pushad
  mov ax,a
  mov esi,off
  mov ecx,4  
  mov bx,10h
  call num2str_1
  popad
  ret
num2str_wh endp

num2str_wb proc,a:word,off:dword
  pushad
  mov esi,off
  add esi,15
  mov byte ptr [esi+1],0
  mov ax,a
  mov ecx,16
@@:
  mov dl,al
  shr ax,1
  and dl,1
  add dl,'0'
  mov [esi],dl
  dec esi
  dec ecx
  jnz @b
  popad
  ret
num2str_wb endp

strcpy proc,s1off:dword,s2off:dword
  ;s1=s2
  pushad
  mov edi,s1off
  mov esi,s2off
@@:
  movsb
  cmp byte ptr[esi-1],0
  jnz @b
  popad
  mov eax,s1off
  ret
strcpy endp

strcat proc,s1off:dword,s2off:dword
  ;s1=s1+s2
  pushad
  mov edi,s1off
  mov esi,s2off
@@:  
  cmp byte ptr[edi],0
  jz strcat_1
  inc edi
  jmp @b
@@:
  movsb
strcat_1:
  cmp byte ptr[esi],0
  jnz @b
  mov byte ptr[edi],0
  popad
  mov eax,s1off
  ret
strcat endp

strlen proc,off:dword
  pushad
  mov esi,off
  xor eax,eax
@@:
  cmp byte ptr[esi],0
  jz @f
  inc eax ;length
  inc esi
  jmp @b
@@:
  mov [esp+7*4],eax
  popad
  ret
strlen endp

strcmp proc,p1:dword,p2:dword
  pushad
  mov esi,p1
  mov edi,p2
@@:
  cmpsb
  ja above
  jb below
  cmp byte ptr[esi-1],0
  jnz @b
  popad
  xor eax,eax
  ret
above:
  popad
  mov eax,1   ;p1 > p2
  ret
below:
  popad
  mov eax,-1    ;p1 < p2
  ret
strcmp endp

;this is atol!!
str2num proc,s:dword
  local _neg:byte
  pushad
  mov esi,s
  dec esi
@@:
  inc esi
  cmp bptr[esi],0
  jz bad
  cmp bptr[esi],'+'
  jz start
  cmp bptr[esi],'-'
  jz start
  cmp bptr[esi],'0'
  jb @b
  cmp bptr[esi],'9'
  ja @b
  jmp start
bad:
  popad
  mov _str2num_siz_,0
  xor eax,eax
  ret
start:
  mov _neg,0
  .if bptr[esi]=='-'
    inc _neg
    inc esi
  .elseif bptr[esi]=='+'
    inc esi ;ignore it
  .endif
  xor ebx,ebx
  mov edi,esi
  dec edi
@@:
  cmp bptr[esi],0
  jz cont
  cmp bptr[esi],'0'
  jb cont
  cmp bptr[esi],'9'
  ja cont
  inc esi
  inc bl
  jmp @b
cont:
  cmp bl,10
  ja bad ;to many digits!
  cmp bl,0
  jz bad ;no digits (could happen eg: + w/o any #s )
  dec esi
  mov _str2num_siz_,esi
  mov eax,s
  sub _str2num_siz_,eax
  inc _str2num_siz_  ;total size!
  ;go till esi=edi
  mov ebx,1
  xor ecx,ecx  ;total
@@:
  xor eax,eax
  mov al,[esi]
  sub al,'0'
  mul ebx
  add ecx,eax
  mov eax,10
  mul ebx
  mov ebx,eax
  dec esi
  cmp esi,edi
  jnz @b
done:
  mov eax,ecx
  .if _neg
    neg eax
  .endif
  mov [esp+7*4],eax
  popad
  ret
str2num endp

;this is atoh???  Hex version
str2num_h proc uses ebx ecx edx esi edi,s:dword
  pushad
  mov esi,s
@@:
  mov al,bptr[esi]
  cmp al,0
  jz bad
  .if (al>='0') && (al<='9')
    jmp start
  .endif
  .if (al>='A') && (al<='F')
    jmp start
  .endif
  .if (al>='a') && (al<='f')
    jmp start
  .endif
  inc esi
  jmp @b
bad:
  popad
  mov _str2num_siz_,0
  xor eax,eax
  ret
start:
  xor bl,bl
  mov edi,esi
  dec edi
@@:
  cmp bl,8
  ja bad     ;to many digits!
  mov al,[esi]
  cmp bptr[esi],0
  jz cont
  .if (al>='A') && (al<='F')
    inc bl
    inc esi
    jmp @b
  .endif
  .if (al>='a') && (al<='f')
    inc bl
    inc esi
    jmp @b
  .endif
  .if (al>='0') && (al<='9')
    inc bl
    inc esi
    jmp @b
  .endif
cont:
  cmp bl,0
  jz bad     ;no digits
  dec esi
  mov _str2num_siz_,esi
  mov eax,s
  sub _str2num_siz_,eax
  inc _str2num_siz_
  ;go till esi=edi
  mov ebx,1
  xor ecx,ecx  ;total
@@:
  xor eax,eax
  mov al,[esi]
  .if (al>='A') && (al<='F')
    add al,'a'-'A'
  .endif
  .if (al>='0') && (al<='9')
    sub al,'0'
  .endif
  .if (al>='a') && (al<='f')
    sub al,'a'+10
  .endif
  mul ebx
  add ecx,eax
  mov eax,16
  mul ebx
  mov ebx,eax
  dec esi
  cmp esi,edi
  jnz @b
done:
  mov [esp+7*4],ecx  ;save EAX for ret
  popad
  ret
str2num_h endp

;binary version
str2num_b proc uses ebx ecx edx esi edi,s:dword
  pushad
  mov esi,s
  dec esi
@@:
  inc esi
  cmp bptr[esi],0
  jz cont2
  cmp bptr[esi],'+'
  jz bad
  cmp bptr[esi],'-'
  jz bad
  cmp bptr[esi],'0'
  jb @b
  cmp bptr[esi],'1'
  ja @b
cont2:
  dec esi
  jmp start
bad:
  popad
  mov _str2num_siz_,0
  xor eax,eax
  ret
start:
  xor ebx,ebx
  mov edi,esi
  dec edi
@@:
  cmp bptr[esi],0
  jz cont
  cmp bptr[esi],'0'
  jb cont
  cmp bptr[esi],'1'
  ja cont
  inc esi
  inc bl
  jmp @b
cont:
  cmp bl,32
  ja bad ;to many digits!
  cmp bl,0
  jz bad ;no digits
  dec esi
  mov _str2num_siz_,esi
  mov eax,s
  sub _str2num_siz_,eax
  inc _str2num_siz_
  ;go till esi=edi
  mov ebx,1
  xor ecx,ecx  ;total
@@:
  xor eax,eax
  mov al,[esi]
  sub al,'0'
  mul ebx
  add ecx,eax
  mov eax,2
  mul ebx
  mov ebx,eax
  dec esi
  cmp esi,edi
  jnz @b
done:
  mov [esp+7*4],ecx  ;save eax
  popad
  ret
str2num_b endp

end

