include qlib.inc
include file.inc
include string.inc
include video.inc
include key.inc
include error.asm

.data
cursor8a label byte
  db 16,16,16,16,16,16,16,16,00
  db 16,01,01,01,01,01,16,00,00
  db 16,01,01,01,01,16,00,00,00
  db 16,01,01,01,01,16,00,00,00
  db 16,01,01,01,01,01,16,00,00
  db 16,01,16,16,01,01,01,16,00
  db 16,16,00,00,16,01,01,01,16
  db 16,00,00,00,00,16,01,16,00
  db 00,00,00,00,00,00,16,00,00

cursor8b label byte
  db 01,16,16,16,16,16,16,16,00
  db 16,01,01,01,01,01,16,00,00
  db 16,01,01,01,01,16,00,00,00
  db 16,01,01,01,01,16,00,00,00
  db 16,01,01,01,01,01,16,00,00
  db 16,01,16,16,01,01,01,16,00
  db 16,16,00,00,16,01,01,01,16
  db 16,00,00,00,00,16,01,16,00
  db 00,00,00,00,00,00,16,00,00

;RGB       B    G    R
cursor24a db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (0f0h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (0f0h),3 dup (000h)
          db 3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (0f0h)

cursor24b db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (0f0h),3 dup (000h),3 dup (000h)
          db 3 dup (0f0h),3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (0f0h),3 dup (000h)
          db 3 dup (0f0h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (000h),3 dup (0f0h)

ccol db 0   ;current color(for color rotation)
but db 0

.data?
a db ?
temp db 10 dup (?)
linearaddr dd ?
tvid dd ?
mode db ?
.data
font8 equ "norm.fnt"
font24 equ "font24.fnt"
fontbuf dd 0

.code
sleep proc
  .repeat
    call getch
  .until al
  ret
sleep endp

getsize proc
  .if mode==0
    mov ecx,320*200
  .elseif mode==1
    mov ecx,320*200*3
  .elseif mode==2
    mov ecx,320*400*3
  .elseif mode==3
    mov ecx,640*480*3
  .endif
  ret
getsize endp

user proc
  ;x=AX;
  ;y=BX;
  ;but=CX;
  mov but,cl
  .if (ax>160)
    .if mode==0
      callp mouse_setcursor,offset cursor8a,9,9,0,0
    .else
      callp mouse_setcursor,offset cursor24a,8,8,0,0
    .endif
  .else
    .if mode==0
      callp mouse_setcursor,offset cursor8b,9,9,0,0
    .else
      callp mouse_setcursor,offset cursor24b,8,8,0,0
    .endif
  .endif
  ret
user endp

main proc
  call mouse_init
  exit_on_error "Mouse Driver not installed"
top:
  callp setgmode,3
  callp printf,"Grafix Test DEMO  Ver 1.0\n\n"
  callp printf,"  Select an option:\n\n"
  callp printf,"    1) VGA (320x200x256)\n"
  callp printf,"    2) VESA 2.0 (320x200x24bit)\n"
  callp printf,"    3) VESA 2.0 (320x400x24bit)\n"
  callp printf,"    4) VESA 2.0 (640x480x24bit)\n"
  callp printf,"    Q) Quit\n:>";
@@:
  call getch
  .if (al=='Q')||(al=='q')
    callp setgmode,3
    callp printf,"Goodbye..."
    callp exit,0
  .endif
  .if (al>='1')&&(al<='4')
    jmp @f
  .endif
  jmp @b
@@:
  mov mode,al
  sub mode,'1' ;makes it 0-3

  callp mouse_setuser,offset user
  .if mode==0
    callp mouse_setcursor,offset cursor8a,9,9,0,0
  .else
    callp mouse_setcursor,offset cursor24a,8,8,0,0
  .endif

  .if mode==0
    callp setgmode,13h
  .elseif mode==1
    mov eax,10fh  ;the 4000h is not required anymore. It's always assumed
  .elseif mode==2
    mov eax,138h
  .elseif mode==3
    mov eax,112h
  .endif
  .if mode>0
    call checkvbemode
    ;eax=linear frame buffer  (==-1 if error)
    mov linearaddr,eax
    exit_on_error "VESA:Unable to setup VESA mode\n You may need to load UniVBE to get VBE 2.0 support!"
    
    call setvbemode
  .endif

  call getsize
  callp malloc,ecx
  g_exit_on_error
  mov tvid,eax

  call getsize
  mov edi,tvid
  mov al,81h
  rep stosb

  callp gset,tvid

  .if mode==0
    mov ebx,offset font8
  .else
    mov ebx,offset font24
  .endif
  callp gloadfnt,ebx
  mov fontbuf,eax
  g_exit_on_error "Unable to load FONT file!"

  .if mode==0
    callp gprintxy,10,10,"VGA 320x200x256 w/mouse support"
  .else
    callp gprintxy,10,10,"VESA w/mouse support"
  .endif
  callp gprintxy,10,20,"w/ TEXT Grafix support"
  callp gprintxy,10,30,"by : PETER QUIRING"
  callp gprintxy,10,40,"Press ESC to move on..."
  callp gprintxy,10,50,"Window : (50,50)-(220,120)"

  call v_copy

  callp mouse_setwin,50,50,220,120  ;must reset size before mouse_on
  callp mouse_setspd,1,1
  call mouse_on
  call sleep

  callp gprintxy,10,60,"Half Speed"
  call v_copy
  callp mouse_setspd,2,2
  call sleep

  callp gprintxy,10,70,"Full Window"
  call v_copy
  .if mode==0
    callp mouse_setwin,0,0,319,199
  .elseif mode==1
    callp mouse_setwin,0,0,319,199
  .elseif mode==2
    callp mouse_setwin,0,0,319,399
  .elseif mode==3
    callp mouse_setwin,0,0,639,479
  .endif
  call sleep

  callp gprintxy,10,80,"Moved to (100,100)"
  call v_copy
  callp mouse_setpos,100,100
  call sleep

  .if mode
    jmp done
  .endif
  callp gprintxy,10,90,"Hold in buttons to change color:"
  callp gprintxy,10,100,"Press a key to quit"
  call v_copy
  mov ccol,1
  .repeat
    mov cl,but
    .if (cl & 1)
      inc ccol
    .endif
    .if (cl & 2)
      dec ccol
    .endif
    .if ccol==64
      mov ccol,0
    .elseif ccol==255
      mov ccol,63
    .endif

    callp setcol,1,0,0,ccol
    call getch
  .until al
done:
  call mouse_off
  callp setgmode,3
  callp free,tvid
  callp free,fontbuf
  jmp top

  ret
main endp

end

