include qlib.inc
include math.inc
include string.inc
include video.inc
include key.inc

.data
  x dw ?
  y dw ?
  v dd ?
  d REAL8 ?
  vid dd 0a0000h
  m_pi REAL8 3.141592654
  _2 dd 2
  _180 dd 180
  _80 dd 80
  result dd ?
  vidtmp dd ?

.code

show proc,a:byte
  mov x,0
@@:
  fild _2
  fild x
  fmulp st(1),st
  fild _180
  fdivp st(1),st
  fld m_pi
  fmulp st(1),st
  fstp d
  wait
  .if a==0
    callp sin,d
  .elseif a==1
    callp cos,d
  .elseif a==2
    callp tan,d
  .endif
  mov dptr[d],eax
  mov dptr[d+4],edx
  fld d
  fild _80
  fmulp st(1),st
  fistp result
  wait
  mov eax,result
  add eax,100
  .if eax<200
    imul eax,320
    movzx ebx,x
    add eax,ebx
    add eax,vid
    mov bptr[eax],31
  .endif
  inc x
  .if x<180
    jmp @b
  .endif
  ret
show endp

clrit proc
  mov edi,vidtmp
  mov ecx,320*200/4
  mov eax,0
  rep stosd
  callp hline,0,100,180,1
  callp vline,45,90,110,1
  callp vline,90,80,120,1
  callp vline,135,90,110,1
  callp vline,0,50,150,1
  ret
clrit endp

main proc
  mov eax,_base
  sub vid,eax

  .if !_fpu
    callp printf,"No 80387 detected!\n"
    callp exit,0
  .endif

  callp gloadfnt,"norm.fnt"
  .if eax==ERROR
    callp printf,"Unable to load font"
    callp exit,0
  .endif
  callp malloc,320*200
  .if eax==ERROR
    callp printf,"no ram"
    callp exit,0
  .endif
  mov vidtmp,eax
  callp gset,eax
  mov edi,vidtmp
  mov ecx,320*200/4
  mov eax,0
  rep stosd

  callp setgmode,13h
  call clrit
  callp gprintxy,0,0,"Trig: sin()"
  call v_copy
  callp show,0
@@:
  call getch
  cmp al,0
  jz @b
  callp clrit
  callp gprintxy,0,0,"Trig: cos()"
  call v_copy
  callp show,1
@@:
  call getch
  cmp al,0
  jz @b
  callp clrit
  callp gprintxy,0,0,"Trig: tan()"
  call v_copy
  callp show,2
@@:
  call getch
  cmp al,0
  jz @b
  
  callp setgmode,3
  ret
main endp

end


