#include "realcnvt.h"

/*  converts IEEE 8-byte real to pascal 6-byte real  */

void doubletopasreal(pasreal *New, double Old) {
  char    Sign;
  int     Exp;
  int     X;
  unsigned char *NewNum, *OldNum;

  NewNum = (char *) New;
  OldNum = (char *) &Old;

  Sign = OldNum[7] & 0x80;
  Exp  = ((OldNum[7] & 0x7F) << 4) + (OldNum[6] >> 4) + 0x81 - 0x3FF;

  for (X = 5; X >= 1; X--) {
    NewNum[X] = OldNum[X+1] << 4;
    NewNum[X] |= OldNum[X] >> 4;
  }

  for (X = 1; X < 5; X++) {
    NewNum[X] >>= 1;
    NewNum[X] |= NewNum[X+1] << 7;
  }
  NewNum[5] >>= 1;

  NewNum[5] |=  Sign;
  NewNum[0] =   Exp;
}
