{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{                                                                       }
{ SB Midi in/out functions                                              }
{                                                                       }
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}


Function  Sbmidi_out_shortmsg(midi_status,midi_data1,midi_data2:byte):Integer;
Begin
     Sbmidi_out_shortmsg:=-1;

     { return value -1=output failure }

     If midi_status<128 then
     begin
       Sbmidi_out_shortmsg:=2;
     exit;
     end;

     If (midi_data1>127) or (midi_data2>127) then
     begin
       Sbmidi_out_shortmsg:=3;
     exit;
     end;
     If (_UARTMode) and (_MIDIin) then
     begin
       Bitti;
       If Err Then exit;
       Port[_ct_io_addx + $0C]:=Midi_Status;
       Bitti;
       If (Midi_Status<$F6) then
       begin
           If Err Then exit;
           Port[_ct_io_addx + $0C]:=Midi_data1;
           Case Midi_status of
           $80..$BF,$E0..$EF,$F2:
             begin
               Bitti;
               If Err Then exit;
               Port[_ct_io_addx + $0C]:=Midi_data2;
             end;
           end;
       end
     end else
     begin
      Bitti;
      If Err Then exit;
      Port[_ct_io_addx + $0C]:=$38;
      Bitti;
      If Err Then exit;
      Port[_ct_io_addx + $0C]:=Midi_Status;
      If (midi_status<$F6) then
      begin
       Bitti;
       If Err Then exit;
       Port[_ct_io_addx + $0C]:=$38;
       Bitti;
       If Err Then exit;
       Port[_ct_io_addx + $0C]:=Midi_data1;
          Case Midi_status of
          $80..$BF,$E0..$EF,$F2:
            begin
              Bitti;
              If Err Then exit;
              Port[_ct_io_addx + $0C]:=$38;
              Bitti;
              If Err Then exit;
              Port[_ct_io_addx + $0C]:=Midi_data2;
            end;
          end;
      end;
     end;
     Sbmidi_out_shortmsg:=0;
End;

{--------------------------------------------------------------------------}

Function  Sbmidi_out_longmsg(midi_msg:pointer; msg_length:Integer):integer;
var Psg,Pof:Word;
Begin
     Sbmidi_out_longmsg:=-1;

     { return value -1=output failure }

     Psg:=Seg(midi_msg^);
     Pof:=Ofs(midi_msg^);
     If msg_length>0 then
     begin
      For T:=1 to msg_length do
      begin
       Delay(_midi_send_wait);
       If (_UARTMode) and (_MIDIin) then
       begin
        Bitti;
        If err then exit;
        Port[_ct_io_addx + $0c]:=mem[Psg:Pof+t-1];
       end else
       begin
        Bitti;
        If Err Then exit;
        Port[_ct_io_addx + $0C]:=$38;
        Bitti;
        If err then exit;
        Port[_ct_io_addx + $0c]:=mem[Psg:Pof+t-1];
       end;
      end;
     end;
     Sbmidi_out_longmsg:=0;
End;

{--------------------------------------------------------------------------}

Procedure SBMidi_Start_Input;
Begin
   If NOT _MIDIin then
   begin
     cli;
     Midi_In_mask1:=Port[$021];
     Midi_In_mask2:=Port[$0a1];
     Case _ct_int_num of
     2 :IRQ:=$0a;
     3 :IRQ:=$0b;
     5 :IRQ:=$0d;
     7 :IRQ:=$0f;
     10:IRQ:=$72;
     end;
     Getintvec(IRQ,Midi_In_addr);
     Setintvec(IRQ,Addr(Midi_Coming));
     Case _ct_int_num of
     2 :Port[$21]:=Midi_In_mask1 xor 4;
     3 :Port[$21]:=Midi_In_mask1 xor 8;
     5 :Port[$21]:=Midi_In_mask1 xor 32;
     7 :Port[$21]:=Midi_In_mask1 xor 128;
     10:Begin
         Port[$0a1]:=Midi_In_mask2 xor 4;
         Port[$21]:=Midi_In_mask1 xor 4;
        end;
     end;
     Dummy := Port[_ct_io_addx + $0e];
     If _ct_int_num=10 then
     begin
      Port[$A0]:=$20;
      Port[$20]:=$20;
     end else
     begin
      Port[$20]:=$20;
     end;
     sti;
     _MIDIin:=True;
     bitti;
     port[_ct_io_addx + $0c]:=$f2;
     bitti;
     If _UARTMode then port[_ct_io_addx + $0c]:=$35 else port[_ct_io_addx + $0c]:=$31;
     MidiBuf[2049]:=0;
     MidiBuf[2050]:=0;
     If _ct_int_num=10 then
     begin
      Port[$A0]:=$20;
      Port[$20]:=$20;
     end else
     begin
      Port[$20]:=$20;
     end;
     Dummy := Port[_ct_io_addx + $0e];
     Midicount:=0;
     cli;
     GetIntVec($08,@Midi_Timer_save);
     SetIntVec($08,Addr(Midi_timer_inc));
     sti;
     Miditimer:=0;
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      t:=0;
      repeat
       bitti;
        port[_ct_io_addx]:=0;
       inc(t);
      until (t>1000) or (port[_ct_io_addx + $0e]and 128=128);
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      Dummy :=PORT[_ct_io_addx + $0E];
      repeat
        midi_code := sbmidi_get_input;
      until (midi_code=longint(0));
   end;
End;

{--------------------------------------------------------------------------}

Procedure SBMidi_Stop_Input;
Begin
   If _MIDIin then
   begin
     cli;
     Port[$21]:=Midi_In_Mask1;
     Port[$a1]:=Midi_In_Mask2;
     SetIntVec(IRQ,Midi_In_Addr);
     SetIntVec($08,@Midi_Timer_Save);
     sti;
     _Midiin:=False;
     If _UARTMode then Sbc_Dsp_Reset;
   end;
End;

{--------------------------------------------------------------------------}

Function SBMidi_Get_Input:Longint;
var m:word;
    tl:longint;
Begin
   If Midicount<1 then
   begin
    SBMidi_Get_Input:=0;
    exit;
   end;
     Tl:=Miditimer shl 8;
     Tl:=Tl+(MidiBuf[1] and $000000ff);
     SBMidi_Get_Input:=Tl;
     Dec(Midicount);
     Move(MidiBuf[2],MidiBuf[1],2048);
End;

{--------------------------------------------------------------------------}

{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{                                                                       }
{ SB Midi EXTENDED functions                                            }
{                                                                       }
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}


{**********************************************}
{ send single midi byte                        }
{**********************************************}

Function  Sbmidi_out_byte(midi_data:byte):Integer;
Begin
     Sbmidi_out_byte:=-1;

     { return value -1 = output failure }

     If (_UARTMode) and (_MIDIin) then
     begin
       Bitti;
       If Err Then exit;
       Port[_ct_io_addx + $0C]:=Midi_data;
     end else
     begin
      Bitti;
      If Err Then exit;
      Port[_ct_io_addx + $0C]:=$38;
      Bitti;
      If Err Then exit;
      Port[_ct_io_addx + $0C]:=Midi_data;
     end;
     Sbmidi_out_byte:=0;
End;
