Program FixPal;

Uses Dos,
     Crt;

Type    PaletteType = Array[1..256*3] Of Byte;

        PalType = Record
          Active    : Boolean;
          SubstVal,
          Red,
          Green,
          Blue      : Byte;
        End;

        FileInfoType = Record
          XLen,
          YLen : Integer;
        End;


  Var FileCount  : Integer;
      DispFile   : Text;
      NewPalette : Array[1..256] Of PalType;
      FileInfo : FileInfoType;
      FileInfoFile : File of FileInfoType;
      PaletteFile : File of PaletteType;
      Palette : PaletteType;
      ByteFile : File Of Byte;
      AnyByte   : Byte;
      NumPal : Integer;
      SubZero : Boolean;
      ZeroSubstVal : Byte;


  Procedure VideoMode ( Mode : Byte );

    Begin { VideoMode }
      Asm
        Mov  AH,00
        Mov  AL,Mode
        Int  10h
      End;
    End;  { VideoMode }


  Function ChangeByte ( Num : Integer ) : Byte;

    Var Str : String;
        Valu,
        Err  : Integer;

    Begin
      If NewPalette[Num].Active
        Then ChangeByte := NewPalette[Num].SubstVal
        Else Begin
          Inc(NumPal);
          NewPalette[Num].Active := True;
          If SubZero And 
             (NewPalette[Num].Red = 0) And
             (NewPalette[Num].Green = 0) And
             (NewPalette[Num].Green = 0)
            Then Begin
              ChangeByte := ZeroSubstVal;
              NewPalette[Num].SubstVal := ZeroSubstVal;
            End
            Else Begin
              With NewPalette[Num] Do
                Write('New color value for ',Num,'(',Red,',',Green,',',Blue,')? [CR=no change]: ');
              Readln(Str);
              If Length(Str)=0
                Then Begin
                  ChangeByte := Num-1;
                  NewPalette[Num].SubstVal := Num-1;
                End
                Else Begin
                  Val(Str,Valu,Err);
                  ChangeByte := Valu;
                  NewPalette[Num].SubstVal := Valu;
                End;
            End;
        End;
    End;

  Procedure ByteToFile ( AnyByte : Byte );

    Begin { ByteToFile }
      If FileCount + 1 > 19
        Then Begin
          Writeln(DispFile,AnyByte,',');
          FileCount := 0;
        End
        Else Write(DispFile,AnyByte,',');
      Inc(FileCount);
    End;  { ByteToFile } 


  Var Count,
      YCount,
      XCount  : Integer;
      Str : String;
      Valu,
      Err  : Integer;
      Key : Char;


  Begin
    Assign(PaletteFile,'PICTURE.PAL');
    Reset(PaletteFile);
    Read(PaletteFile,Palette);
    Port[$3C8] := 0;
    For Count := 1 To 256*3 Do
      Port[$3C9] := Palette[Count];
    Close(PaletteFile);

    Assign(FileInfoFile,'Graph.INF');
    Reset(FileInfoFile);
    Read(FileInfoFile,FileInfo);
    Close(FileInfoFile);

    Assign(ByteFile,'Graph.PIC');
    Reset(ByteFile);

    VideoMode($13);
    Port[$3C8] := 0;
    For Count := 1 To 256*3 Do
      Port[$3C9] := Palette[Count];
    For YCount := 1 To FileInfo.YLen Do
      For XCount := 1 To FileInfo.XLen Do
        Read(ByteFile,Mem[$A000:(YCount-1)*320+(XCount-1)]);

    Close(ByteFile);
    Repeat Until Keypressed;
    Key := ReadKey;

    VideoMode($3);

    SubZero := False;
    Write('0,0,0 color value? [CR=no change]: ');
    Readln(Str);
    If Length(Str)>0
      Then Begin
        SubZero := True;
        Val(Str,Valu,Err);
        ZeroSubstVal := Valu;
      End;

    For Count := 1 To 256 Do
      Begin
        NewPalette[Count].Red := Palette[(Count-1)*3+1];
        NewPalette[Count].Green := Palette[(Count-1)*3+2];
        NewPalette[Count].Blue := Palette[(Count-1)*3+3];
        NewPalette[Count].Active := False;
        NewPalette[Count].SubstVal := 0;
      End;


    Assign(ByteFile,'Graph.PIC');
    Reset(ByteFile);

    NumPal := 0;

    Assign(DispFile,'Graph.PAS');
    ReWrite(DispFile);
    Writeln(DispFile,'Picture : Array[1..',FileInfo.XLen*FileInfo.YLen,'] Of Byte = ');
    Writeln(DispFile,'(* Size is ',FileInfo.XLen,' by ',FileInfo.YLen,' *)');
    Write(DispFile,'(');
    FileCount := 0;
    For YCount := 1 To FileInfo.YLen Do
      For XCount := 1 To FileInfo.XLen Do
        Begin
          Read(ByteFile,AnyByte);
          ByteToFile(ChangeByte(AnyByte+1));
        End;
    Writeln(DispFile);
    Writeln(DispFile);
    Writeln(DispFile,'PicPalette : Array[1..',NumPal,'*4] Of Byte = ');
    Write(DispFile,'(');
    For Count := 1 To 256 Do
      With NewPalette[Count] Do
        If Active And (SubstVal <> 0) Then Writeln(DispFile,SubstVal,',',Red,',',Green,',',Blue,',');

    Close(DispFile);

    Close(ByteFile);
  End.
