Program ViewPictureFile;

  Uses  Dos,
        Crt;

  Type  PictureType = Array[1..32000] Of Byte;
        PaletteType = Array[1..256*3] Of Byte;

        FileInfoType = Record
          XLen,
          YLen : Integer;
        End;


  Var FileCount  : Integer;
      DispFile   : File Of Byte;


  Procedure VideoMode ( Mode : Byte );

    Begin { VideoMode }
      Asm
        Mov  AH,00
        Mov  AL,Mode
        Int  10h
      End;
    End;  { VideoMode }


  Procedure SetColor ( Color, Red, Green, Blue : Byte );

    Begin { SetColor }
      Port[$3C8] := Color;
      Port[$3C9] := Red;
      Port[$3C9] := Green;
      Port[$3C9] := Blue;
    End;  { SetColor }


  Var   Picture : PictureType;
        Palette : PaletteType;
        PictureFile : File of PictureType;
        PaletteFile : File of PaletteType;
        YCount,
        XCount,
        Count   : Integer;
        Key     : Char;
        PrevPos,
        MemPos,
        Top,
        Bottom  : Word;
        PtrCol,
        Red,
        Green,
        Blue,
        Prev    : Byte;
        FileInfo : FileInfoType;
        FileInfoFile : File of FileInfoType;

  Begin { ViewPictureFile }
    Write('Enter pointer color value: ');
    Readln(PtrCol);
    Write('Enter Red value of pointer: ');
    Readln(Red);
    Write('Enter Green value of pointer: ');
    Readln(Green);
    Write('Enter Blue value of pointer: ');
    Readln(Blue);
    Assign(PictureFile,'PICTURE.DAT');
    Reset(PictureFile);
    Assign(PaletteFile,'PICTURE.PAL');
    Reset(PaletteFile);
    Read(PaletteFile,Palette);
    Close(PaletteFile);
    VideoMode($13);
    Port[$3C8] := 0;
    For Count := 1 To 256*3 Do
      Port[$3C9] := Palette[Count];
    Read(PictureFile,Picture);
    Move(Picture,Mem[$A000:0000],32000);
    Read(PictureFile,Picture);
    Move(Picture,Mem[$A000:32000],32000);
    Close(PictureFile);

    Top := $FFFF;
    Bottom := $FFFF;
    MemPos := 0;
    SetColor(PtrCol,Red,Green,Blue);
    Prev := Mem[$A000:MemPos];
    Repeat
      Repeat Until Keypressed;
      Key := UpCase(ReadKey);
      If Ord(Key) = 0
        Then Begin
          Repeat Until Keypressed;
          Key := ReadKey;
          PrevPos := MemPos;
          Mem[$A000:MemPos] := Prev;
          Case Ord(Key) Of
{Left}      75 : Dec(PrevPos);
{Right}     77 : Inc(PrevPos);
{Up}        72 : PrevPos := PrevPos - 320;
{Down}      80 : PrevPos := PrevPos + 320;
          End;
          If (PrevPos <= 64000) And (PrevPos >= 0)
            Then Begin
              MemPos := PrevPos;
              Prev := Mem[$A000:MemPos];
            End;
          Mem[$A000:MemPos] := PtrCol;
        End
        Else Case Key Of
          'T' : Top := MemPos;
          'B' : Bottom := MemPos;
        End;
    Until (Top <> $FFFF) And (Bottom <> $FFFF) Or (Key='Q');;
    If Key <> 'Q'
      Then Begin
        Assign(FileInfoFile,'Graph.INF');
        ReWrite(FileInfoFile);
        FileInfo.XLen := (Bottom Mod 320)-(Top Mod 320);
        FileInfo.YLen := (Bottom Div 320)-(Top Div 320);
        Write(FileInfoFile,FileInfo);
        Close(FileInfoFile);
        Assign(DispFile,'Graph.PIC');
        ReWrite(DispFile);
        For YCount := Top Div 320 To Bottom Div 320-1 Do
          For XCount := Top Mod 320 To Bottom Mod 320-1 Do
            Write(DispFile,Mem[$A000:YCount*320+XCount]);
        Close(DispFile);
      End;
    VideoMode($03);
    If Key <> 'Q'
      Then Begin
        If Top > Bottom
          Then Begin
            MemPos := Top;
            Top := Bottom;
            Bottom := MemPos;
          End;
        Writeln('Top Coordinate = (',(Top Div 320)+1,',',(Top Mod 320)+1,')');
        Writeln('Bottom Coordinate = (',(Bottom Div 320)+1,',',(Bottom Mod 320)+1,')');
        Repeat Until Keypressed;
        Key := ReadKey;
      End;
  End.  { ViewPictureFile }
