{****************************************************************************}
{                                                                            }
{ MODULE:         DOSMem                                                     }
{                                                                            }
{ DESCRIPTION:    Provides a pseudo-dynamic memory manager, built on the DOS }
{                 heap. Pseudo-dynamic means that it can't be freed in       }
{                 chunks. It's possible to ask for individual chunks, but    }
{                 they are all freed at the same time as a whole.            }
{                                                                            }
{                 Blocks of memory are always justified to paragraph-bounds. }
{                                                                            }
{ AUTHOR:         Juan Carlos Arvalo                                        }
{                                                                            }
{ MODIFICATIONS:  Nobody (yet ;-)                                            }
{                                                                            }
{ HISTORY:        01-Oct-1992 First Documentation.                           }
{                 17-Oct-1992 Documentation finished.                        }
{                 01-Oct-1992 Created the routines Init & DoneDOSMem.        }
{                                                                            }
{ (C) 1992 VangeliSTeam                                                      }
{____________________________________________________________________________}

UNIT DOSMem;

INTERFACE




PROCEDURE InitDOSMem; { Initialize the DOS memory heap. }
PROCEDURE DoneDOSMem; { Release the DOS memory heap.    }

FUNCTION  DOSAlloc   (Bytes: WORD) : POINTER; { Requests a block of memory.            }
FUNCTION  DOSMemAvail              : LONGINT; { Returns the amount of free DOS memory. }
PROCEDURE DOSWipeMem;                         { Frees the whole DOS heap.              }




IMPLEMENTATION

USES Memory;

VAR
  DOSMemSeg  : WORD;    { Start segment of the reseved memory in paragraphs. }
  DOSMemSize : WORD;    { Size of the reserved memory in paragraphs.         }
  OldHeapEnd : POINTER; { Original value of the HeapEnd variable.            }




FUNCTION  DOSAlloc(Bytes: WORD) : POINTER;
  VAR
    Siz : WORD;
  LABEL
    Bien;
  BEGIN
    DOSAlloc := NIL;

    IF DOSMemSeg = 0 THEN EXIT;

    Siz := DOSMemSize;
    INC(DOSMemSize, (Bytes+15) SHR 4);

    ASM
        MOV     AH,$4A
        MOV     ES,DOSMemSeg
        MOV     BX,DOSMemSize
        INT     $21
        JNC     Bien
    END;

    DOSMemSize := Siz;
    DOSAlloc   := NIL;
    EXIT;

Bien:
    DOSAlloc := Ptr(DOSMemSeg + Siz, 0);

  END;


FUNCTION DOSMemAvail : LONGINT;
  VAR
    ParaLeft : WORD;
  BEGIN
    DOSMemAvail := 0;

    IF DOSMemSeg = 0 THEN EXIT;

    ASM
        MOV     AH,$48
        MOV     BX,$FFFF
        INT     $21
        MOV     ParaLeft,BX
    END;
    DOSMemAvail := LONGINT(ParaLeft) * 16;
  END;


PROCEDURE DOSWipeMem; ASSEMBLER;
  ASM

        MOV     DX,DOSMemSeg
        AND     DX,DX
        JZ      @@Fin

        MOV     AH,$4A
        MOV     ES,DX
        MOV     BX,1
        MOV     DOSMemSize,BX
        INT     $21
@@Fin:

  END;




PROCEDURE InitDOSMem;
  BEGIN
    IF DOSMemSeg <> 0 THEN
      BEGIN
        DOSWipeMem;
        EXIT;
      END;

    OldHeapEnd := HeapEnd;
    SetMemTop(HeapPtr);
    HeapEnd := HeapPtr;

    DOSMemSeg := 0;

    ASM

          MOV     AH,$48
          MOV     BX,$FFFF
          INT     $21
          MOV     DOSMemSize,BX
          MOV     AH,$48
          INT     $21

          MOV     DOSMemSeg,AX
    END;

    DOSWipeMem;
  END;




PROCEDURE DoneDOSMem;
  BEGIN
    IF DOSMemSeg = 0 THEN EXIT;

    ASM

                MOV     AH,$49
                MOV     ES,DOSMemSeg
                INT     $21

    END;

    HeapEnd := OldHeapEnd;
    SetMemTop(HeapEnd);

    DOSMemSeg := 0;
  END;




BEGIN

  DOSMemSeg := 0;

END.