procedure log(event_code  : log_event_type;
              number      : real;
              infostr     : anystr);

var
  now        : dt_block_type;
  time_str   : string[6];
  io_err_val : integer;

begin
  datetime(now);
  time_str := copy(dt_str(now),7,6);
  {$I-}
  writeln(log_file,time_str,' ',ord(event_code)+32,' ',number,' ',infostr);
  {$I+}
  io_err_val := ioresult;
  if io_err_val<>0
    then writeln('I/O error #',io_err_val,' on Log File');
end;
