type
  char_set   = set of char;
  anystr     = string[255];
  str80      = string[80];

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure beep;

begin
  write(#7)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure at(Y, X : integer); { Personal preference -- Y before X }

begin
  gotoXY(X,Y)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function wherex : integer; { Like IBM Turbo Pascal function }

const { See DEFMTR.ASM }
  mtr_d_seg_ptr = $3FE;  { Pointer (in segment 0) to monitor data segment }
  mtr_horp      = $0291; { Horizontal cursor position (zero relative) }

begin
  wherex := mem[memw[0:mtr_d_seg_ptr]:mtr_horp] + 1;
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function wherey : integer; { Like IBM Turbo Pascal function }

const { See DEFMTR.ASM }
  mtr_d_seg_ptr = $3FE;  { Pointer (in segment 0) to monitor data segment }
  mtr_verp      = $0292; { Vertical cursor position (zero relative) }

begin
  wherey := mem[memw[0:mtr_d_seg_ptr]:mtr_verp] + 1;
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function cursor_pos : integer; { Stuffs cursor Y and X in integer }

begin
  cursor_pos := (wherey shl 8) or wherex
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure set_cursor(p : integer); { Sets cursor Y and X from integer }

begin
  gotoxy(p and $7F,p shr 8)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure cursor_off;

begin
  write(#27,'x5')
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure cursor_on;

begin
  write(#27,'y5');
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function readchar(ok_chars : char_set) : char; { Restricts input to ok_chars }

var
  c : char;

begin
  repeat
    read(kbd,c);
    if not (c in ok_chars)
      then beep
  until c in ok_chars;
  readchar := c
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure readstr(var s : anystr); { Leaves door open for fancy string input }

begin
  readln(s)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function upcasestr(s : anystr) : anystr; { Force string to all caps }

var
  i : integer;

begin
  for i := 1 to length(s) do
    s[i] := upcase(s[i]);
  upcasestr := s
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure protect_status_line;

begin
  write(#27,'y1')
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure unprotect_status_line;

begin
  write(#27,'x1')
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure center(y,             { Blanked field & center string }
                 xl,
                 xr  : byte;
                 txt : anystr);

var
  pad : byte;
  cursor : integer;

begin
  pad := (xr-xl-length(txt)+1) shr 1;
  at(y,xl); write('':pad,txt);
  cursor := cursor_pos;
  write('':(xr-xl-length(txt)+1-pad));
  set_cursor(cursor)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure left(y,            { Left adjust string & fill right with fill char }
               xl,
               xr   : byte;
               txt  : anystr;
               fill : char);

var
  i : integer;

begin
  at(y,xl); write(txt,' ');
  for i := 1 to xr-xl-length(txt) do
    write(fill)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure right(y,           { Right adjust string & fill left with fill char }
                xl,
                xr   : byte;
                txt  : anystr;
                fill : char);

var
  i : integer;

begin
  at(y,xl);
  for i := 1 to xr-xl-length(txt) do
    write(fill);
  write(' ',txt)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}


procedure msg(txt : anystr); { Center msg on line 23 }

begin
  center(23,1,80,txt);
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

procedure show_functions(func_txt : anystr); { Display functions on line 25 }

begin
  msg('Select function');
  unprotect_status_line;
  lowvideo;
  center(25,1,80,func_txt);
  normvideo;
  at(23,1)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function get_function(func_list : anystr) : byte; { Get function key }

var
  c : char;
  i : integer;
  ok : boolean;

begin
  ok := false;
  repeat
    cursor_off;
    c := readchar([#27]);
    read(kbd,c);
    if c='?'
      then read(kbd,c);
    i := pos(c,func_list);
    if i=0
      then begin
        beep;
        ok := false
      end
      else begin
             ok := true;
             get_function := i-1
           end
  until ok;
  cursor_on
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function yes(txt : anystr) : boolean; { Display txt, get Y or N,
                                        return TRUE if Y, FALSE if N }

var
  c : char;
  cursor : integer;

begin
  cursor := cursor_pos;
  msg(txt+' (Y/N) ');
  c := readchar(['y','Y','n','N']);
  yes := (upcase(c) = 'Y');
  msg('');
  set_cursor(cursor)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

function no(txt : anystr) : boolean; { Same as "yes" except opposite logic }

begin
  no := not yes(txt)
end;

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
