{E_TYPES.INC -- Global type definitions for EMAIL (host & remote)}

type
  str5           = string[5];
  str10          = string[10];
  str12          = string[12];
  str15          = string[15];
  str20          = string[20];
  str30          = string[30];
  str80          = string[80];
  anystr         = string[255];

  char_set       = set of char;

  unit_type      = str20; {Unit}
  attn_type      = str20; {Attn name}
  host_type      = 0..255; {Host number}
  adrs_type      = record {Unit/Attn name}
                    unit      : unit_type;
                    attn      : attn_type
                   end;
  adrs_lst_type  = record
                     unit     : unit_type;
                     host     : host_type
                   end;
  unit_array_type = array[1..20] of char;
  attn_array_type = array[1..20] of char;
  typadr_type    = (unit, dist_list, conference);
  file_name_type = str12;
  file_path_type = str30;
  mail_type      = (letter, parcel, system);
  priority_type  = (bulk, routine, immediate, flash);
  time_zone_type = byte;
  ph_num_type    = string[30];
  dt_block_type    = record
                       yy,mo,dd,hh,mi,ss : integer
                     end;

  key_type       = unit_type;
  index_type     = record
                     unit         : unit_type;
                     queue_hdr_rn : integer
                   end;

  queue_hdr_type = record
                     unit               : unit_type;
                     head,
                     tail               : real;
                     time_zone          : time_zone_type;
                     pass_a_retry_count : integer;
                     pass_b_retry_count : integer;
                     phone_no           : ph_num_type;
                   end;

  mail_que_type  = record {Mail queue entry}
                     next          : real;
                     sender_adrs   : adrs_type;
                     recvr_adrs    : adrs_type;
                     host_sys      : host_type;
                     type_adrsee   : typadr_type;
                     dist_list     : file_path_type;
                     dist_length   : real;
                     type_mail     : mail_type;
                     priority      : priority_type;
                     when_mailed   : dt_block_type;
                     when_recvd    : dt_block_type;
                     mail_item     : file_path_type;
                     original_name : file_name_type;
                     mail_length   : real
                   end;

send_count_type  = record case boolean of
                     true  : (first_byte,
                              second_byte  : byte);
                     false : (int_val      : integer)
                   end;

log_event_type   = (debug,
                    open_log,
                    io_error,
                    unit_error,
                    awaiting_call,
                    connected,
                    no_connect,
                    terminate,
                    main_loop,
                    kbd_interrupt,
                    place_call,
                    bad_mail_hdr,
                    mail_hdr,
                    recv_dist_list,
                    bad_block,
                    bad_conference,
                    recv_mail_item,
                    add_to_queue,
                    erase_no_recvrs,
                    send_mail_item,
                    bad_mail_item,
                    mail_hdr_refused,
                    mail_item_refused,
                    send_count_is,
                    erase_mail_item,
                    start_pass_a,
                    start_pass_b,
                    no_contact_a,
                    no_contact_b,
                    hanging_up);

  sys_info_type = record
                    unit          : unit_type;
                    serial_no     : integer;
                    host_no       : byte;
                    host_phone_no : ph_num_type;
                    time_zone     : time_zone_type
                  end;
