{e_remote.pas     ---- EMAIL remote site system
               by ANGSC/DOSC with special thanks to 'oldest' Capt Al Morrison
  8/11/86 - 8/15/86 @ Ft Smith, AR

 22 SEPT 86 VERSION      INCORPORATING CHANGES AS FOLLOWS:
                      ACCEPTS SYSTEM MAIL, INCLUDES FILENAMES WITH IN/OUT
                       MAIL MENUS,    ???STAYS WITHIN MENU????
 25 Sep 86 Version    Added help menus -- all help now w/in e_help.inc - afab
 30 Sep 86 Version    Reworked incoming, outgoing, and nite ops.  They now
                      remain w/in an area until exit desired.  Menu items
                      don't show up unless appropriate.  Selection of an
                      inappropriate item returns to main menu rather than
                      bombing out.  Made the headings and data displays pretty
                      as well as adding provisions for additional pages of
                      mail.  Parsed the real filename out of user entry and
                      assigned it to original_name.  Reworked e_help.inc
                      again to update it to current ops.  Did some other things
                      to make things pretty, but can't remember them.
                                                                          }
{====================== PROGRAM REMOTE.PAS ==================================}
program e_remote;

    const

       logoline1 : string[25] = '         ANG EMAIL SYSTEM';
               c : char       = 'n';


{$I e_types.inc}             {global types}
{$I e_misc.inc}
{$I e_dt.inc}                {date time routines}
{$I e_scrn.inc}              {screen handling code}
{$I e_menu.inc}              {generic menu system-- menu function}
{$I e_help.inc}              {e_help      - main help file}
                             {e_help1     - help for incoming}
                             {e_help2     - help for outgoing}
                             {e_help3     - help for nite ops}
                             {e_help_adrs - help for master addressee section}
                             {e_help4     - help for the utilities}
{$I e_addres.inc}            {list address master 'address.dta' from utility}
{$I e_const.inc}             {global constants}
{$I e_mdm.inc  }             {modem routines}

    var
     ans,  i              : integer;
          ch              : char;
     queue_hdr_file       : file of queue_hdr_type;
     queue_file           : file of mail_que_type;
     queue_no             : integer;
     mail_item_file       : file of byte;
     temp_mail            : queue_hdr_type;
     mail                 : mail_que_type;
     col                  : integer;
     recn                 : integer;
     mail_queue_entry     : mail_que_type;
     mail_queue_rn        : real;
     infile, outfile      : text;
     printflag            : boolean;
     ok                   : boolean;
     sys_info_file        : file of sys_info_type;
     dist_file            : file;
     mail_file            : file;
     sys_info             : sys_info_type;
     now                  : dt_block_type;
     dist_list_file       : file of byte;
     conf_list_file       : file of byte;
     temp_size_mail       : file_path_type;


{$I e_rmque.inc}             {mail queue routines from host routines}
{$I que_test.inc}            {test program to put some queue info in}
{============================================================================}
{========================================================================}
function next_fname(first_char : char) : file_name_type;

var
  temp,
  dummy          : integer;
  now            : dt_block_type;
  next_serial_no : str5;
  yy_str         : string[2];
  julian_str     : string[3];

begin
  seek(sys_info_file,0);
  read(sys_info_file,sys_info);
  with sys_info do begin
    next_serial_no := makestr(serial_no,5);
    serial_no := succ(serial_no) mod 32767;
  end;
  seek(sys_info_file,0);
  write(sys_info_file,sys_info);
  reset(sys_info_file);  {Force update}
  date(now);
  str(now.yy,yy_str);
  julian_str := makestr(julian(now),3);
  next_fname := first_char + next_serial_no + yy_str + '.' + julian_str
end;

{==========================================================================}
{ functions from RIO.PAS   }
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function io_err(fname : file_path_type) : boolean;

var
  ok        : boolean;
  err_value : integer;

begin
  err_value := ioresult;
  if err_value<>0
    then begin
      writeln('>>>>> I/O ERROR #',err_value,' ON FILE ',fname);
{     if copy(fname,length(fname)-2,3)<>'LOG'
        then log(io_error,err_value,fname)}
    end;
  io_err := (err_value<>0)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function kbd_terminate : boolean;

var
  yorn : char;

begin
  gotoxy(23,23);
  write('Terminate night operations? (Y/N) ');
  read(kbd,yorn);
  writeln(yorn);
  kbd_terminate := (upcase(yorn)='Y');
  gotoxy(1,23);    {need to clear the message in case he stays in nite ops}
  clreol;
{ log(kbd_interrupt,null,upcase(yorn))}
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure handlecall;

type
  next_type = (id,mail_hdr,send_mail,recv_mail);

var
  more_mail        : boolean;
  response         : char;
  in_mail_queue_entry  : mail_que_type;
  out_mail_queue_entry : mail_que_type;
  mail_queue_rn    : real;
  to_queue_hdr_rn  : integer;
  len              : real;
  lenstr           : string[8];
  packet           : array[1..aux_buffer_size] of byte;
  numread          : integer;
  numbytes         : integer;
  seq_no           : byte;
  cmd              : char;
  ok,
  ok1,
  ok2,
  quit             : boolean;
  next             : next_type;
  dummy            : integer;

begin
  quit := false;
  next := id;
  get_first_queue_entry(outgoing,out_mail_queue_entry,mail_queue_rn,more_mail);
  while data_set_ready and not quit do begin
    readaux(cmd,3*seconds,ok);
WRITELN('CMD= ',ORD(CMD));
    ok := ok and (cmd=attention);
    if ok
      then begin
        readaux(cmd,1*seconds,ok);
WRITELN('CMD= ',ORD(CMD));
        if ok
          then case cmd of

            send_id :
              if next=id
                then begin
                  sendaux(recved_ok,noresponse,response);
                  send_aux_packet(sys_info.unit,sizeof(sys_info.unit),
                                  00,squeeze,ok);
                  next := mail_hdr;
                end;

            send_hdr :
              begin
                if (next<>mail_hdr) or not more_mail
                  then ok := false
                  else repeat
                    if out_mail_queue_entry.type_adrsee=dist_list
                      then begin
                        assign(dist_file,out_mail_queue_entry.dist_list);
                        {$I-} reset(dist_file); {$I+}
                        ok1 := not io_err(out_mail_queue_entry.dist_list)
                      end
                      else ok1 := true;
                    assign(mail_file,out_mail_queue_entry.mail_item);
                    {$I-} reset(mail_file); {$I+}
                    ok2 := not io_err(out_mail_queue_entry.mail_item);
                    ok := ok1 and ok2;
                    if not ok
                      then begin
                        delete_queue_entry(outgoing,mail_queue_rn,
                                           out_mail_queue_entry);
                        if ok1 and (out_mail_queue_entry.type_adrsee=dist_list)
                          then close(dist_file)
                        else if ok2
                          then begin
                            close(mail_file);
                            erase(mail_file)
                          end;
                        {NOTE:  Normally, we would now use "get_next_queue_entry",
                                but since we deleted the first record in the queue
                                we have to use "get_first...".}
                        get_first_queue_entry(outgoing,out_mail_queue_entry,
                                              mail_queue_rn,more_mail)
                      end
                    until ok or not more_mail;
                  if ok
                    then begin
                      sendaux(affirmative,noresponse,response);
                      send_aux_packet(out_mail_queue_entry,
                                      sizeof(out_mail_queue_entry),
                                      00,squeeze,ok);
                      if not ok
                        then begin
                          close(mail_file);
                          if out_mail_queue_entry.type_adrsee=dist_list
                            then close(dist_file);
                          exit
                        end;
                      next := send_mail
                    end
                    else sendaux(negative,noresponse,response)
              end;

            send_dist_list :
              if      (next=send_mail)
                  and (out_mail_queue_entry.type_adrsee=dist_list)
                then begin
                  len := out_mail_queue_entry.dist_length;
                  seq_no := 0;
                  repeat
                    blockread(dist_file,packet,num_aux_buffer_recs,dummy);
                    if len<aux_buffer_size
                      then numbytes := trunc(len)
                      else numbytes := aux_buffer_size;
                    send_aux_packet(packet,numbytes,seq_no,squeeze,ok);
                    if not ok
                      then begin
                        close(dist_file);
                        exit
                      end;
                    seq_no := succ(seq_no);
                    len := len - numbytes
                  until len=0;
                  close(dist_file)
                end;

            send_item :
              if (next=send_mail)
                then begin
                  len := out_mail_queue_entry.mail_length;
                  seq_no := 0;
                  repeat
                    blockread(mail_file,packet,num_aux_buffer_recs,dummy);
                    if len<aux_buffer_size
                      then numbytes := trunc(len)
                      else numbytes := aux_buffer_size;
                    send_aux_packet(packet,numbytes,seq_no,squeeze,ok);
                    if not ok
                      then begin
                        close(mail_file);
                        exit
                      end;
                    seq_no := succ(seq_no);
                    len := len - numbytes
                  until len=0;
                  close(mail_file);
                  delete_queue_entry(outgoing,mail_queue_rn,
                                     out_mail_queue_entry);
                  erase(mail_file);
                  next := mail_hdr;
                  {NOTE:  Normally, we would now use "get_next_queue_entry",
                          but since we deleted the first record in the queue
                          we have to use "get_first...".}
                  get_first_queue_entry(outgoing,out_mail_queue_entry,
                                       mail_queue_rn,more_mail);

                end;

            recv_hdr :
              if next=mail_hdr
                then begin
                  sendaux(affirmative,noresponse,response);
                  read_aux_packet(in_mail_queue_entry,
                                  sizeof(in_mail_queue_entry),
                                  00,unsqueeze,ok);
                  if not ok
                    then exit;
                  next := recv_mail
                end;

            recv_item :
              if next=recv_mail
                then begin
                 IF IN_MAIL_QUEUE_ENTRY.TYPE_MAIL = SYSTEM
                  THEN BEGIN
                   ASSIGN(MAIL_FILE,IN_MAIL_QUEUE_ENTRY.ORIGINAL_NAME);
                   REWRITE(MAIL_FILE);
{BIG SECTION ADDED}

                  len := in_mail_queue_entry.mail_length;
                  seq_no := 0;
                  repeat
                    if len<aux_buffer_size
                      then numbytes := trunc(len)
                      else numbytes := aux_buffer_size;
                    read_aux_packet(packet,numbytes,seq_no,unsqueeze,ok);
                    if not ok
                      then begin
                        close(mail_file);
                        erase(mail_file);
                        exit
                      end;
                    blockwrite(mail_file,packet,num_aux_buffer_recs);
                    seq_no := succ(seq_no);
                    len := len - numbytes
                  until len=0;
                  close(mail_file);
                  assign(mail_item_file,in_mail_queue_entry.mail_item);
                  reset(mail_item_file);
                  seek(mail_item_file,in_mail_queue_entry.mail_length);
                  truncate(mail_item_file);
                  close(mail_item_file);
  {DON'T ADD     add_queue_entry(incoming,in_mail_queue_entry);   }
                  next := mail_hdr
                end

               ELSE
                BEGIN
                  in_mail_queue_entry.mail_item := next_fname('M');
                  assign(mail_file,in_mail_queue_entry.mail_item);
                  rewrite(mail_file);
                  len := in_mail_queue_entry.mail_length;
                  seq_no := 0;
                  repeat
                    if len<aux_buffer_size
                      then numbytes := trunc(len)
                      else numbytes := aux_buffer_size;
                    read_aux_packet(packet,numbytes,seq_no,unsqueeze,ok);
                    if not ok
                      then begin
                        close(mail_file);
                        erase(mail_file);
                        exit
                      end;
                    blockwrite(mail_file,packet,num_aux_buffer_recs);
                    seq_no := succ(seq_no);
                    len := len - numbytes
                  until len=0;
                  close(mail_file);
                  assign(mail_item_file,in_mail_queue_entry.mail_item);
                  reset(mail_item_file);
                  seek(mail_item_file,in_mail_queue_entry.mail_length);
                  truncate(mail_item_file);
                  close(mail_item_file);
                  add_queue_entry(incoming,in_mail_queue_entry);
                  next := mail_hdr
                end
  {??->}       END;

            goodbye : quit := true;

          end
      end
  end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure await_mail;

var
  yorn : char;
  quit : boolean;

begin
  clrscr;
  gotoxy(10,10);
  writeln('Entering Night Operations ...... Press Any Key to Terminate.');
  gotoxy(10,12);
  quit := false;
  init_mdm(bd1200);                  {initialize modem 1200   6 sw up}

  repeat
    awaitcall(1*minutes);
    if data_set_ready
      then begin
        handlecall;
        hangup
      end
    else if keypressed
      then quit := kbd_terminate
  until quit;

  quit_mdm;
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}


{==========================================================================}
procedure copyfile(    origfname,
                       destfname : file_path_type;
                   var ok        : boolean        );

const
  numrecs = 128;   {Number of 128 byte blocks in buffer}
  bufsize = 16384; {128 * 128}

var
  buf : array[1..bufsize] of char;
  lenfile    : file of byte;
  len        : real;
  origfile,
  destfile   : file;
  numread    : integer;

begin
  assign(lenfile,origfname);
  {$I-} reset(lenfile); {$I+}
  ok := (ioresult=0);
  if not ok
    then exit;
  len := longfilesize(lenfile);
  close(lenfile);

  assign(origfile,origfname);
  reset(origfile);

  assign(destfile,destfname);
  {$I-} rewrite(destfile); {$I+}
  ok := (ioresult=0);
  if not ok
    then begin
      close(origfile);
      exit
    end;

  repeat
    blockread(origfile,buf,numrecs,numread);
    blockwrite(destfile,buf,numread)
  until numread=0;

  close(origfile);
  close(destfile);

  assign(lenfile,destfname);
  reset(lenfile);
  seek(lenfile,len);
  truncate(lenfile);
  close(lenfile)
end;
{============================================================================}
procedure trash(queue_no : integer);         {to scrap a mail queue hdr}
begin
   gotoxy(1,23);
   writeln('Which Rec# to trash -->                                      ',
           '                   ' );
   gotoxy(25,23);
   readln(recn);
   seek(queue_file,recn);
   read(queue_file,mail_queue_entry);
   delete_queue_entry(queue_no,recn,mail_queue_entry);   {deletes rec#}
   delete_mail_item(mail_queue_entry);                   {deletes mail item}

end;
{============================================================================}
procedure file_it;
var
  resp      : char;
  user_file : file_path_type;
begin
   gotoxy(1,23);
   writeln('Which Rec# to file -->                                      ',
           '                    ');
   gotoxy(24,23);
   readln(recn);
   seek(queue_file,recn);
   read(queue_file,mail_queue_entry);
   clrscr;
    gotoxy(1,5);
       with mail_queue_entry do begin
       writeln('rec#=',recn,' ',sender_adrs.unit,' ',
               sender_adrs.attn,' ',
               recvr_adrs.unit,' ',recvr_adrs.attn,' ');
        end;
        gotoxy(1,7);
        writeln('Is this the one? (Y/N)');
        gotoxy(23,7);
        repeat
        read(kbd,resp);
        resp := upcase(resp);
        until (resp in ['Y','N']);
          if (resp = 'Y') then begin
             gotoxy(1,9);
             writeln('Enter drive:path\filename.ext for mail item :');
             writeln('   ie.  F:\CONDOR\PROGRAM.CMD                ');
             gotoxy(46,10);
             readln(user_file);
                                  {copy the mail item to a file name}

             copyfile(mail_queue_entry.mail_item,user_file,ok);

          if ok then begin
             writeln('File successfully copied!!');
             delay(1500);
             end
           else   begin
             writeln('So sad, too bad, your mad -- file did not copy');
             delay(1500);
             end;
           end;   {response was Y or N}
  end;  {file_it}

{============================================================================}
procedure print_mail(printflag:boolean); {to print or view a mail item}
{revisions:        9-29-86  AFAB added the if statement for the view/print
                   prompt .. removed the (M)ain menu and added press any
                   key so ch <> M upon return to e_incoming thereby allowing
                   us to remain w/in e_incoming.                             }


var
textline : anystr;
count    : integer;

begin
   gotoxy(1,23);
   if printflag then
     writeln('Which Rec# to print -->                                ',
           '                    ')
   else
     writeln('Which Rec# to view  -->                                ',
           '                    ');
   gotoxy(25,23);
   readln(recn);
   seek(queue_file,recn);
   read(queue_file,mail_queue_entry);
   assign(outfile,mail_queue_entry.mail_item);
   {$I-}reset(outfile);{$I+}
   if (ioresult <> 0) then writeln('WARNING --> IO ERROR HAS OCCURRED')
   else
     clrscr;
     count := 0;
     while not eof(outfile) do begin
     readln(outfile,textline);
        if printflag then            {printflag TRUE then print file}
        writeln(lst,textline)
       else  begin
         gotoxy(1,count +1);
         writeln(textline);          {printflag FALSE then view to con}
         count := count + 1;
         if (count mod 18 = 0) then begin
                gotoxy(27,23);
                writeln('Press Any Key To Continue');
                gotoxy(53,23);
                repeat
                until keypressed;   {wait for key pressed to continue}
                reset(kbd);
             clrscr;
             count := 0;
             end;
         end;       {write to screen}
     end; {while not eof}

   close(outfile);
                gotoxy(27,23);
                writeln('Press Any Key To Continue');
                gotoxy(53,23);
             repeat
                if keypressed then exit;
             until keypressed;

end;      {of procedure print_mail}
{============================================================================}
procedure e_incoming;        {read mail items called from e_incoming}

{revisions:         9-29-86  AFAB kind of reworked the whole thing to allow
                    additional screens of incoming, make the presentation
                    pretty, and forcing it to stay in incoming until otherwise
                    desired.
                                                                             }
var
         ok,more       : boolean;
         rn, i         : integer;

begin
   clrscr;
   writeln('+=+=+=+=+=+=+=+=+=+=+=+=+=+= INCOMING MAIL ROUTINE ',
           '=+=+=+=+=+=+=+=+=+=+=+=+=+=+=');
   gotoxy(9,2);
   write('From:');
   gotoxy(29,2);
   write('To: Unit');
   gotoxy(49,2);
   write('To: Indiv/Office');
   gotoxy(69,2);
   write('Filename');

   rn   := 1;     {for incoming record}
   col  := 4;
   ch   := 'X';

   get_first_queue_entry(rn,mail_queue_entry,mail_queue_rn,ok);
                                       {gets first record <-----------****}

   more := ok;    {the flag more used for more control over termination}
                  {we needed the menu to show after not ok}
   repeat
      if (not ok) or (col > 21) then begin
         if (col > 21) and ok then begin   {there is a next page}
            gotoxy(7,23);
            writeln('(N)ext page, (F)ile, (T)rash, (P)rint, (V)iew, (H)elp,',
            ' (M)ain menu');
            gotoxy(74,23);
         end
         else if (not ok) and (more) then begin {more := ok after this routine}
            gotoxy(13,23);
            writeln('(F)ile, (T)rash, (P)rint, (V)iew, (H)elp, (M)ain menu');
            gotoxy(67,23);
         end
         else begin        {there was no incoming}
            gotoxy(29,10);
            Writeln('No Files To Read Today.');
            gotoxy(30,23);
            writeln('(H)elp, (M)ain menu');
            gotoxy(50,23);
         end;
         repeat
            read(kbd,ch);
            ch := upcase(ch);
         until (ch in ['N','F','T','P','V','H','M']);
         case ch of
            'H' :  begin
                      e_help1;
                      e_incoming;
                   end;
            'T' :  if more then begin
                      trash(1);
                      e_incoming;
                   end;
            'N' :  if ok then begin
                      ClrEos(4);
                      col := 4;
                   end
                   else exit;
            'P' :  if more then begin
                      printflag := true;
                      print_mail(printflag);
                      e_incoming;
                   end;
            'V' :  if more then begin
                      printflag := false;
                      print_mail(printflag);
                      e_incoming;
                   end;
            'F' :  if more then begin
                      file_it;
                      e_incoming;
                   end;
            'M' :  exit;
         end;
      end;  {not ok or col > 21}
      gotoxy(1,col);
      more := ok;
      if (more) and (ch <> 'M') then with mail_queue_entry do begin
         write('rec#=');
         gotoxy(6,col);  {handles up to 99 without being overwritten}
         write(trunc(mail_queue_rn));
         gotoxy(9,col);
         write(sender_adrs.attn);
         for i := (length(sender_adrs.attn)+1) to 20 do write (' ');
         write(recvr_adrs.unit);
         for i := (length(recvr_adrs.unit)+1) to 20 do write (' ');
         write(recvr_adrs.attn);
         for i := (length(recvr_adrs.attn)+1) to 20 do write (' ');
         write(original_name);
         get_next_queue_entry(recn,mail_queue_entry,mail_queue_rn,ok);
         col := col + 1;
      end;  {that entry}
   until (not more) or (ch = 'M');
end;  {end of reading mail routine}

{============================================================================}
procedure e_send_mail;        {sending a mail item}

{revisions:          9-29-86 AFAB added the routine to parse the filename
                     out of temp_file                                   }

var
   distrib          : char;
   temp_queue_entry : mail_que_type;
   free_hdr         : queue_hdr_type;
   temp_hdr         : queue_hdr_type;
   temp_file        : file_path_type;
   parse_file       : file_path_type;   {added for parsing out filename}
   temp_dist_fname  : file_path_type;
   temp_conf_fname  : file_path_type;
   old_tail         : real;
   new_rn           : real;
   dist_list_file_ln : real;
   conf_list_file_ln : real;
   mail_item_file_ln : real;
    temp_adrs        : adrs_type;
        master      : file of adrs_lst_type;
        mas         : adrs_lst_type;
        found       : boolean;
        fname       : file_path_type;
        temp_attn   : attn_type;

begin
  fillchar(temp_queue_entry,sizeof(temp_queue_entry),0);
  clrscr;
  writeln('This procedure will prompt you for information required to ');
  writeln('send a mail item or parcel to a UNIT, DISTRIBUTION LIST, or');
  writeln('CONFERENCE.  Here goes ...... ');
  gotoxy(1,5);
  write('Enter (U)nit, (D)istribution List, or (C)onference [U,D,C] : ');
  repeat
    read(kbd,ch);
    ch := upcase(ch);
  until (ch in ['U','D','C']);

  if (ch = 'D') then begin      {Distribution List handler}
    distrib := 'D';
    repeat
      gotoxy(1,7);
      write(' Enter Drive:Path\Filename for Distribution List : ');
      readln(fname);
      gotoxy(1,9);
      write('Is this the file : ',fname,' ? (Y/N) ');
      repeat
        read(kbd,ch);
        ch := upcase(ch);
      until (ch in ['Y','N']);
    until (ch = 'Y');              {he now likes the filename}

    temp_dist_fname :=  next_fname(distrib);


    copyfile(fname,temp_dist_fname,ok);        {copy fname to new file name}

    assign(dist_list_file,temp_dist_fname);
    {$I-} reset(dist_list_file); {$I+}
    ok := not io_err(temp_dist_fname);
    if ok then begin
      dist_list_file_ln := longfilesize(dist_list_file); {size of distr list}
      close(dist_list_file);
    end;


    temp_adrs.unit := 'see distribution list';
    temp_adrs.attn := 'n/a';

  end;   {Distribution List Handler section}

  if (ch = 'C') then begin        {Conference List Handler}
    distrib := 'C';

    repeat
      gotoxy(1,7);
      write(' Enter Drive:Path\Filename for Conference List : ');
      readln(fname);
      gotoxy(1,9);
      write('Is this the file : ',fname,' ? (Y/N) ');
      repeat
        read(kbd,ch);
        ch := upcase(ch);
      until (ch in ['Y','N']);
    until (ch = 'Y');              {he now likes the filename}

    temp_dist_fname :=  next_fname(distrib);

    copyfile(fname,temp_dist_fname,ok);        {copy fname to new file name}


    assign(conf_list_file,temp_dist_fname);
    {$I-} reset(conf_list_file); {$I+}
    ok := not io_err(temp_dist_fname);
    if ok then begin
      conf_list_file_ln := longfilesize(conf_list_file); {size of conf list}
      close(conf_list_file);
    end;

    temp_adrs.unit := 'see conference list';
    temp_adrs.attn := 'n/a';

  end;   {Conference List Handler section}

  if (ch = 'U') then begin          {Unit addressee handler}
    distrib := 'U';
    found := false;

    assign(master,'E_ADRS.LST');
    reset(master);
    ok := not io_err('E_ADRS.LST');
    if ok then begin


      repeat
        gotoxy(1,7);
        write(' Enter Destination Unit Designator : ');
        readln(temp_adrs.unit);
        found := false;

        if temp_adrs.unit=sys_info.unit then begin
          gotoxy(1,9);
          write('Cannot Send Mail to Yourself!  Try again.')
        end
        else begin
          seek(master,0);                       {start looking at top again}
          while not EOF(master) do begin
            read(master,mas);
            if (temp_adrs.unit = mas.unit) then begin
              gotoxy(1,9);
              write('Unit Ok! ..... continuing');
              found := true;
            end;
          end;     {while not eof(master) }

          if EOF(master) and (not found) then begin
            gotoxy(1,9);
            write('Unit Not Found.  Try again.');
          end
        end
      until found;
      close(master);                            {close master file}
    end;      { begin E_ADRS.LST exists! routine}

end;        {end of unit address handler}

gotoxy(1,11);
write(' Enter Attention to : ');
readln(temp_adrs.attn);

 gotoxy(1,13);
 write(' Enter Reply to : ');
 readln(temp_attn);

 gotoxy(1,15);
 write('Enter Drive:\Path\filename of mail : ');
 readln(temp_file);

   case distrib of
     'D'  : temp_queue_entry.type_adrsee := dist_list;
     'C'  : temp_queue_entry.type_adrsee := conference;
     'U'  : temp_queue_entry.type_adrsee := unit;
    end;  {end of case}

temp_size_mail      := next_fname('M');
copyfile(temp_file,temp_size_mail,ok);   {copy file to M0014686.201}

    assign(mail_item_file,temp_size_mail);
    {$I-} reset(mail_item_file); {$I+}
    ok := not io_err(temp_size_mail);
    if ok then begin
      mail_item_file_ln := longfilesize(mail_item_file); {size of mail item}
      close(mail_item_file);
    end;

datetime(now);                            {gets system date time}

{we need to parse the original filename out of drive:\path\filename}

 i := length(temp_file);
 repeat
    i := i-1;
    ch := copy(temp_file,i,1);
 until (ch = '\') or (i = 1);
 if i = 1  {there was no backslash}
    then parse_file := temp_file
 else
    parse_file := copy(temp_file,i+1,length(temp_file)-i);


 with temp_queue_entry do begin           {start filling in mail_queue info}

   sender_adrs.unit     :=  sys_info.unit;            {from e_rinfo.sys    }
   sender_adrs.attn     :=  temp_attn;                {from INPUT          }
   recvr_adrs.unit      :=  temp_adrs.unit;           {from INPUT          }
   recvr_adrs.attn      :=  temp_adrs.attn;           {from INPUT          }
   host_sys             :=  sys_info.host_no;         {from CONST          }
   dist_list            :=  temp_dist_fname;          {distrib./conf list  }
   dist_length          :=  dist_list_file_ln;        {size                }
   type_mail            :=  letter;                   {from INPUT          }
   priority             :=  routine;                  {from INPUT          }
   when_mailed          :=  now;                      {from system         }
   mail_item            :=  temp_size_mail;           {from INPUT          }
   original_name        :=  parse_file;               {from INPUT & parse  }
   mail_length          :=  mail_item_file_ln;        {size                }

 end;  {with temp_queue_entry}

add_queue_entry(outgoing,temp_queue_entry);       {add this item to queue}


end;   {e_send_mail  procedure}

{============================================================================}
procedure e_outgoing;         {outgoing mail section main routine}

{revisions:         9-29-86  AFAB kind of reworked the whole thing to allow
                    additional screens of outgoing, make the presentation
                    pretty, and forcing it to stay in outgoing until otherwise
                    desired.
                                                                             }
var
         ok,more       : boolean;
         rn, i         : integer;

begin
   clrscr;
   writeln('+=+=+=+=+=+=+=+=+=+=+=+=+=+= OUTGOING MAIL ROUTINE ',
           '=+=+=+=+=+=+=+=+=+=+=+=+=+=+=');
   gotoxy(9,2);
   write('From:');
   gotoxy(29,2);
   write('To: Unit');
   gotoxy(49,2);
   write('To: Indiv/Office');
   gotoxy(69,2);
   write('Filename');

   rn   := 2;     {for outgoing record}
   col  := 4;
   ch   := 'X';

   get_first_queue_entry(rn,mail_queue_entry,mail_queue_rn,ok);
                                       {gets first record <-----------****}

   more := ok;    {the flag more used for more control over termination}
                  {we needed the menu to show after not ok}
   repeat
      if (not ok) or (col > 21) then begin
         if (col > 21) and ok then begin
            gotoxy(8,23);
            writeln('(N)ext page, (S)end new Item, (C)ancel item, (H)elp,',
            ' (M)ain menu');
            gotoxy(73,23);
          end
          else if (not ok) and (more) then begin
            gotoxy(14,23);
            writeln('(S)end new Item, (C)ancel item, (H)elp, (M)ain menu');
            gotoxy(66,23);
          end
          else begin
            gotoxy(28,10);
            Writeln('No Outgoing Files Today.');
            gotoxy(22,23);
            writeln('(S)end new Item, (H)elp, (M)ain menu');
            gotoxy(59,23);
          end;
         repeat
            read(kbd,ch);
            ch := upcase(ch);
         until (ch in ['N','S','C','H','M']);
         case ch of
            'N' :  if ok then begin
                      ClrEos(4);
                      col := 4;
                   end;
            'S' :  begin
                      e_send_mail;
                      e_outgoing;
                   end;
            'C' :  if more then begin
                      trash(2);
                      e_outgoing;
                   end;
            'H' :  begin
                      e_help2;
                      e_outgoing;
                   end;
            'M' :  exit;
         end;
      end;  {not ok or col > 21}
      gotoxy(1,col);
      more := ok;
      if (more) and (ch <> 'M') then with mail_queue_entry do begin
         write('rec#=');
         gotoxy(6,col);  {handles up to 99 without being overwritten}
         write(trunc(mail_queue_rn));
         gotoxy(9,col);
         write(sender_adrs.attn);
         for i := (length(sender_adrs.attn)+1) to 20 do write (' ');
         write(recvr_adrs.unit);
         for i := (length(recvr_adrs.unit)+1) to 20 do write (' ');
         write(recvr_adrs.attn);
         for i := (length(recvr_adrs.attn)+1) to 20 do write (' ');
         write(original_name);
         get_next_queue_entry(recn,mail_queue_entry,mail_queue_rn,ok);
         col := col + 1;
      end;  {that entry}
   until (not more) or (ch = 'M');
end;  {end of reading mail routine}

{============================================================================}
procedure e_night_ops;          {night time operations main routine}

{revisions:         9-29-86  AFAB kind of reworked the whole thing to allow
                    additional screens of outgoing, make the presentation
                    pretty, and forcing it to stay in nite ops until otherwise
                    desired.
                                                                             }
var
         ok,more       : boolean;
         rn, i         : integer;

begin
   clrscr;
   writeln('+=+=+=+=+=+=+=+=+=+=+=+=+=+ NIGHT OPERATIONS ROUTINE ',
           '+=+=+=+=+=+=+=+=+=+=+=+=+=+');
   gotoxy(9,2);
   write('From:');
   gotoxy(29,2);
   write('To: Unit');
   gotoxy(49,2);
   write('To: Indiv/Office');
   gotoxy(69,2);
   write('Filename');

   rn   := 2;     {for outgoing record}
   col  := 4;
   ch   := 'X';

   get_first_queue_entry(rn,mail_queue_entry,mail_queue_rn,ok);
                                       {gets first record <-----------****}

   more := ok;    {the flag more used for more control over termination}
                  {we needed the menu to show after not ok}
   repeat
      if (not ok) or (col > 21) then begin
         if (col > 21) and ok then begin
            gotoxy(10,23);
            writeln('(N)ext page, (G)oodnight, (C)ancel item, (H)elp,',
            ' (M)ain menu');
            gotoxy(71,23);
         end
         else if (not ok) and (more) then begin
            gotoxy(16,23);
            writeln('(G)oodnight, (C)ancel item, (H)elp, (M)ain menu');
            gotoxy(64,23);
         end
         else begin
            gotoxy(28,10);
            Writeln('No Outgoing Files Today.');
            gotoxy(24,23);
            writeln('(G)oodnight, (H)elp, (M)ain menu');
            gotoxy(57,23);
         end;
         repeat
            read(kbd,ch);
            ch := upcase(ch);
         until (ch in ['N','G','C','H','M']);
         case ch of
            'N' :  if ok then begin
                      ClrEos(4);
                      col := 4;
                   end;
            'G' :  begin
                      await_mail;
                      e_night_ops;
                   end;
            'C' :  if more then begin
                      trash(2);
                      e_night_ops;
                   end;
            'H' :  begin
                      e_help3;
                      e_night_ops;
                   end;
            'M' :  exit;
         end;
      end;  {not ok or col > 21}
      gotoxy(1,col);
      more := ok;
      if (more) and (ch <> 'M') then with mail_queue_entry do begin
         write('rec#=');
         gotoxy(6,col);  {handles up to 99 without being overwritten}
         write(trunc(mail_queue_rn));
         gotoxy(9,col);
         write(sender_adrs.attn);
         for i := (length(sender_adrs.attn)+1) to 20 do write (' ');
         write(recvr_adrs.unit);
         for i := (length(recvr_adrs.unit)+1) to 20 do write (' ');
         write(recvr_adrs.attn);
         for i := (length(recvr_adrs.attn)+1) to 20 do write (' ');
         write(original_name);
         get_next_queue_entry(recn,mail_queue_entry,mail_queue_rn,ok);
         col := col + 1;
      end;  {that entry}
   until (not more) or (ch = 'M');
end;  {end of night ops outgoing mail procedure}
{============================================================================}
procedure e_build_dist;         {builds distribution list}
var
   fname : file_path_type;
   f     : text;
   ch    : char;
   u     : unit_array_type;
   a     : attn_array_type;

begin
   clrscr;
   writeln(' This procedure will build a distribution list for your mail.');
   writeln(' It will be saved according to the Drive:Path\Filename that  ');
   writeln(' you designate.  Here goes......                             ');
  repeat
   gotoxy(1,5);
   writeln(' Drive:Path\Filename for list --> ');
   gotoxy(36,5);
   readln(fname);
   gotoxy(1,7);
   writeln(' Will create a list by name of: ',fname,'  OK? (Y/N) ');
   repeat
      gotoxy(54,7);
      read(kbd,ch);
      ch := upcase(ch);
   until (ch in ['Y','N']);
  until (ch = 'Y');              {he now likes the filename}
   gotoxy(1,8);
   writeln('         enter a blank unit to QUIT');
   assign(f,fname);
   rewrite(f);
   gotoxy(1,9);
   repeat
        fillchar(u,sizeof(u),' ');
        write('Unit : ');
        readln(u);
        write('Attn : ');
        readln(a);
        writeln(f,u,a);
   until (u = '                    ');

      close(f);

end;                           {procedure e_build_dist }
{============================================================================}
procedure e_utilities;          {utilities   ie.  list master address file}
begin
   clrscr;
    initgraph;                         {initialize screen graphics for menus}
    ans := 0;
    i := 1;
    while ans <> 1 do begin
        ans := menu(utilmenu);         {call util menu for remote system}

      if (ans = 1) then begin
        ans := 0;
        exit;
        end;

        case ans of
        2    : list_addresses;  {procedure in e_addres.inc for ADDRESS.DTA}
        3    : e_build_dist;    {data file of units addresses and listing }
        4    : e_help4;          {will be EDIT routine for distr. list?}
        5    : e_help4;          {will be INSTALL routine!}
        6    : e_help4;
       end;
    end;


end;  {end procedure e_utilities!}
{============================================================================}

{============================================================================}
procedure e_exit;                {exit routine and housekeeping ??}
begin
   clrscr;
   writeln('+=+=+=+=+=+=+=+=+=+=+= EXITING  ROUTINE =+=+=+=+=+=+=+=+=+=+=+=+');




end;
{============================================================================}

{============================================================================}
{------------------- main program area --------------------------------------}
label 999;

begin
                                             {Open All the files !!}
   host := false;

   assign(queue_file,queue_fname);
   {$I-}reset(queue_file); {$I+}        {this is Queue file that mail}
   ok := not io_err(queue_fname);        {will hang on                }

   if not ok then goto 999;

   assign(queue_hdr_file,queue_hdr_fname);  {this file is HEADER info}
   {$I-} reset(queue_hdr_file); {$I+}
   ok := not io_err(queue_hdr_fname);

   if not ok then goto 999;

   assign(sys_info_file,sys_info_fname);    {this file is SYSTEM info}
   {$I-} reset(sys_info_file); {$I+}        {configured with INSTALL}
   ok := not io_err(sys_info_fname);

   if not ok then goto 999;

   if ok then read(sys_info_file,sys_info);

    initgraph;                         {initialize screen graphics for menus}
    ans := 0;
    i := 1;

    while ans <> 1 do begin
        ans := menu(mainmenu);         {call main menu for remote system}

      if (ans = 1) then e_exit;

        case ans of
        2    : e_incoming;
        3    : e_outgoing;
        4    : e_night_ops;
        5    : e_utilities;
        6    : e_help;
       end;
    end;

999:                               {energency exit}

{$I-}close(queue_hdr_file);
     close(queue_file);
     close(sys_info_file);

{$I+}

end.                                  {end main program area}
