{$A+,F+,O+,Q-,R-,S-}

{******************************************}
{*                                        *}
{* Example for MGLZH unit.                *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

{NOTE: this examples does not implemented cache buffer for I/O if you
want to compress large amout of data create one or compression will be
very slow.}

uses mglzh;

var
 infile,outfile: file of byte;

{ This function is call by LHZ unit to get next character. }
function get:integer;far;
var
   b:byte;
begin
   if eof(infile) then
     get := -1
   else
   begin
     read(infile, b);
     get := integer(b);
   end;
end;

{ This function is call by LHZ unit to store next character. }
procedure put(b:integer);far;
begin
   if b = -1 then
   begin
    writeln('Error occur!');
    Halt;
   end
   else
     write(outfile, byte(b));
end;


var
  L:Longint;
  Z:Array[1..4] of byte absolute L;

begin

  { Error in command line ? }
  if paramcount <> 3 then
  begin
    writeln;
    writeln('lzh (e,d) infile outfile');
  end
  else
  begin
      writeln;
      writeln('infile = ',paramstr(2), ' outfile = ',paramstr(3));
      assign(infile, paramstr(2));
      reset(infile);
      assign(outfile, paramstr(3));
      rewrite(outfile);

      { set I/O functions }
      lzhputc := put;
      lzhgetc := get;

      if (paramstr(1) = 'e') or (paramstr(1) = 'E') then
      begin
        seek(outfile, 4);
        { Start compression }
        CompressLzh(L);
        seek(outfile, 0);    {Save cmp size at start of file}
        put(Integer(Z[1]));
        put(Integer(Z[2]));
        put(Integer(Z[3]));
        put(Integer(Z[4]));
      end
      else
      begin
        seek(outfile, 0);    {Save cmp size at start of file}
        L := 0;
        Z[1] := get;
        Z[2] := get;
        Z[3] := get;
        Z[4] := get;
        { Start decompression }
        ExpandLzh(L);
      end;

      { Close I/O files }
      close(infile);
      close(outfile);

  end;


end.
