
{******************************************}
{*                                        *}
{* Example for MGNUMBER unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgnumber;

var
 ArrayLong  : array[1..10] of longint;
 ArrayWord  : array[1..10] of word;
 ArrayInt   : array[1..10] of integer;
 ArrayByte  : array[1..10] of byte;
 ArrayShort : array[1..10] of shortint;
 l1,l2      : longint;
 w1,w2      : word;
 i1,i2      : integer;
 s1,s2      : shortint;
 b1,b2      : byte;

begin

 l1 := $FFFF0000;
 w1 := lolong(l1);
 w2 := hilong(l1);

 i1 := integer($FF00);
 b1 := loint(i1);
 b2 := hiint(i1);

 l1  := 1;
 writeln(longodd(l1));
 l1  := 2;
 writeln(longodd(l1));

 w1 := 1;
 writeln(wordodd(w1));
 w1 := 2;
 writeln(wordodd(w1));

 b1 := 1;
 writeln(byteodd(b1));
 b1 := 4;
 writeln(byteodd(b1));

 l1  := -1;
 writeln(longsign(l1));
 l1  := 2;
 writeln(longsign(l1));

 i1  := 1;
 writeln(intsign(i1));
 i1  := -2;
 writeln(intsign(i1));

 for w1 := 1 to 10 do
   ArrayWord[w1] := nrandom(10,1000);
 sortword (@ArrayWord, 10);

 for w1 := 1 to 10 do
   ArrayByte[w1] := nrandom(0,$ff);
 sortbyte (@ArrayByte, 10);

 for w1 := 1 to 10 do
   ArrayInt[w1] := nrandom(0,1000);
 sortInt (@ArrayInt, 10);

 for w1 := 1 to 10 do
   ArrayShort[w1] := nrandom(0,$ff);
 sortshort (@ArrayShort, 10);

 for w1 := 1 to 10 do
   ArrayLong[w1] := nrandom(10,1000);
 sortlong (@ArrayLong, 10);


 writeln('36 to base 16 = ',basechange (36,16));

 l1:=1;
 l2:=2;
 swapl (l1,l2);

 w1:=1;
 w2:=2;
 swapw (w1,w2);

 l1:=1;
 l2:=2;
 swapl (l1,l2);

 b1:=$80;
 writeln('bit 7 = ',getbit (b1, 7));
 writeln('bit 0 = ',getbit (b1, 0));

 setbit (b1, 0, true);
 writeln(b1);

 setbitarray (@ArrayByte, 700, true);
 setbitarray (@ArrayByte, 599, true);
 writeln(getbitarray (@ArrayByte, 700));
 writeln(getbitarray (@ArrayByte, 599));

 i1 := nrandom (10,5999);

 l1 := $F0000000;
 rotlongleft (l1, 4);

 l1 := $F0000000;
 rotlongright (l1, 4);

 w1 := $F000;
 rotwordleft (w1, 8);

 w1 := $F000;
 rotwordright (w1, 8);

 b1 := $F0;
 rotbyteleft (b1, 4);

 b1 := $F0;
 rotbyteright (b1, 4);

 s1:=-5;
 s2:=7;
 writeln(maxs (s1,s2));
 writeln(mins (s1,s2));

 b1:=5;
 b2:=7;
 writeln(maxb (b1,b2));
 writeln(minb (b1,b2));

 i1:=-5;
 i2:=7;
 writeln(maxi (i1,i2));
 writeln(mini (i1,i2));

 w1:=5;
 w2:=7;
 writeln(maxw (w1,w2));
 writeln(minw (w1,w2));

 l1:=-5;
 l2:=7;
 writeln(maxl (l1,l2));
 writeln(minl (l1,l2));

end.