
{ *****************************************

                Prime Numbers

    (c) 1995 by Topical Software

    Demo programm of DOS-Extender Swallow

  ***************************************** }

program Primes;

{$I-,R-,G+,S-,X+}

uses
  Swallow, CRT, Prim32, PrimUnit;


{ We use a huge bit-field to store, whether a number was prime or not.
  (0=prime, 1=not prime)

  Because with TP we can handle only small fields, we have to split it
  into pieces, which addresses are stored in MainTable }

const
  ERR_USERABORT = -1;
  ERR_OUTOFMEM = -2;

  MAXNUMBER = $40000000;                { maximum number }
  BYTEARRAYSHIFT = 3;                   { bits per byte }
  MAINTABLESHIFT = 14 + BYTEARRAYSHIFT; { address bits per main table entry }

type
  PByteArray = ^ByteArray;              { one piece of the bit-field }
  ByteArray = array[0..(1 shl (MAINTABLESHIFT - BYTEARRAYSHIFT)) - 1] of byte;

const
  BYTEARRAYMASK =                       { mask to get address bits within
                                          ByteArray }
    longint(sizeof(ByteArray) - 1) shl BYTEARRAYSHIFT;
  BITMASK = (1 shl BYTEARRAYSHIFT) - 1; { mask to get address within byte }

var
  MainTable :                           { table of bit-field pieces }
    array[0..(MAXNUMBER shr MAINTABLESHIFT) - 1] of PByteArray;

const
  MainTableEntrys : Integer = 0;        { current entries }


{ time stopping routines and variables }
var
  TickCount : ^LongInt;
  StartTime : LongInt;

procedure StartStopping;
begin
  TickCount := Ptr(Seg0040, $6c);
  StartTime := TickCount^;
end;

procedure ShowDuration;
var
  Duration : LongInt;
  Milliseconds : Real;

begin
  Duration := TickCount^ - StartTime;
  Milliseconds := Duration * $100 / $1234;
  writeln('The search took ', Milliseconds:0:3, ' seconds.');
end;

{ Show search result
  HighestNumber - highest number to check
  Count - count of prime numbers <= HighestNumber, or:
     ERR_OUTOFMEM = Out of memory
     ERR_USERABORT = User abort
}
procedure ShowResult(HighestNumber, Count : LongInt);
begin
  ClrEol;
  Writeln;
  if Count = ERR_OUTOFMEM then begin
    Writeln('Not enough memory available!');
    Writeln;
  end else
    if Count = ERR_USERABORT then begin
      Writeln('Abort by user!');
      Writeln;
    end else begin
      ShowDuration;
      Writeln('Within the first ', HighestNumber, ' numbers are ',
	Count, ' prime numbers.');
      Writeln;
    end
end;

{ free complete bit-field
}
procedure FreeMainTable;
var
  i : Integer;

begin
  for i:= 0 to MainTableEntrys - 1 do
    if MainTable[i] <> NIL then
      Dispose(MainTable[i]);
  MainTableEntrys := 0;
end;

{ Count prime numbers within the first "HighestNumber" numbers
  -> ERR_OUTOFMEM = Out of memory
     ERR_USERABORT = Use abort
     >=0 count of prime numbers
}
function CountPrimes1(MaxNumber : LongInt): LongInt;
var
  i : Integer;
  OldTime : LongInt;
  Count, CurNumber, TmpNumber : LongInt;
  PByte : ^Byte;

begin
  { prepare bit-field }
  FillChar(MainTable, sizeof(MainTable), 0);
  MainTableEntrys :=
    (MaxNumber + (longint(1) shl MAINTABLESHIFT) - 1) shr MAINTABLESHIFT;
  for i := 0 to MainTableEntrys - 1 do begin
    MainTable[i]:= SaveGetMem(sizeof(ByteArray));
    if MainTable[i] = NIL then begin
      CountPrimes1:= ERR_OUTOFMEM;
      exit
    end;
    FillChar(MainTable[i]^, sizeof(ByteArray), 0)
  end;
  Count := 0;
  OldTime := TickCount^ - 1;

  { Search number by number }
  for CurNumber := 2 to MaxNumber do begin
    if TickCount^ - OldTime > 0 then begin
      OldTime := TickCount^;
      if CheckBreak(0, CurNumber, Count, 0) then begin
        CountPrimes1 := ERR_USERABORT;
        exit
      end
    end;
    if MainTable[CurNumber shr MAINTABLESHIFT]^
       [(CurNumber and BYTEARRAYMASK) shr BYTEARRAYSHIFT] and
       (1 shl (CurNumber and BITMASK)) = 0 then begin
      { there is a prime number }
      inc(Count);
      TmpNumber := CurNumber;
      { mark all multiples of the prime number as non-primes }
      while (TmpNumber <= MaxNumber) do begin
        PByte := @MainTable[TmpNumber shr MAINTABLESHIFT]^
	  [(TmpNumber and BYTEARRAYMASK) shr BYTEARRAYSHIFT];
        PByte^ := PByte^ or (1 shl (TmpNumber and BITMASK));
        inc(TmpNumber, CurNumber)
      end
    end
  end;

  { that's all }
  CountPrimes1:= Count;
end;


{ Count prime numbers within the first "HighestNumber" numbers
  -> ERR_OUTOFMEM = Out of memory
     ERR_USERABORT = Use abort
     >=0 count of prime numbers
  only the odd numbers are regarded
}
function CountPrimes2(MaxNumber : LongInt): LongInt;
var
  i : Integer;
  OldTime : LongInt;
  Count : LongInt;
  CurNumber, TmpNumber : LongInt;
  CurIndex, TmpIndex, Increment : LongInt;
  MaxIndex : LongInt;
  PByte : ^Byte;

begin
  { prepare bit-field, it has only half of the size }
  FillChar(MainTable, sizeof(MainTable), 0);
  MaxIndex := (MaxNumber + 1) shr 1;
  MainTableEntrys :=
    (MaxIndex + (longint(1) shl MAINTABLESHIFT) - 1) shr MAINTABLESHIFT;
  for i := 0 to MainTableEntrys - 1 do begin
    MainTable[i] := SaveGetMem(sizeof(ByteArray));
    if MainTable[i] = NIL then begin
      CountPrimes2:= ERR_OUTOFMEM;
      exit
    end;
    FillChar(MainTable[i]^, sizeof(ByteArray), 0)
  end;
  Count := 1;
  OldTime := TickCount^ - 1;

  { Search number by number, only the odd ones }
  CurNumber := 3;
  while CurNumber <= MaxNumber do begin
    CurIndex := CurNumber shr 1;
    if TickCount^ - OldTime > 0 then begin
      OldTime := TickCount^;
      if CheckBreak(0, CurNumber, Count, 0) then begin
	CountPrimes2:= ERR_USERABORT;
	exit
      end
    end;
    if MainTable[CurIndex shr MAINTABLESHIFT]^
       [(CurIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT] and
       (1 shl (CurIndex and BITMASK)) = 0 then begin
      { there is a prime number }
      inc(Count);
      Increment := CurNumber shl 1;
      TmpNumber := CurNumber + Increment;
      { mark all _odd_ multiples of the prime number as non-primes }
      while TmpNumber <= MaxNumber do begin
	TmpIndex := TmpNumber shr 1;
        PByte := @MainTable[TmpIndex shr MAINTABLESHIFT]^
	  [(TmpIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT];
        PByte^ := PByte^ or (1 shl (TmpIndex and BITMASK));
        inc(TmpNumber, Increment)
      end
    end;
    inc(CurNumber, 2)
  end;

  { that's all }
  CountPrimes2 := Count
end;


{ Count prime numbers within the first "HighestNumber" numbers
  -> ERR_OUTOFMEM = Out of memory
     ERR_USERABORT = Use abort
     >=0 count of prime numbers
  only the odd numbers are regarded;
  additionally we search block by block to access memory only local
    - very important with virtual memory!
    - at first we check the first "BlockLen" numbers (=1 block) normally
    - now we mark multiples of the prime number within the 2. block
    - now we search the primes within the 2. block
    - now we mark multiples of the first 2 blocks within the 3.
    - and so on...
}
function CountPrimes3(MaxNumber : LongInt): LongInt;
var
  i : Integer;
  OldTime : LongInt;
  Count, CurNumber, TmpNumber : LongInt;
  CurIndex, TmpIndex, Increment : LongInt;
  MaxIndex, BlockLen : LongInt;
  BlockNumber : Integer;
  BlockBegin, BlockEnd : LongInt;
  ScanBlockBegin, ScanBlockEnd : LongInt;
  ScanEnd : LongInt;
  LastScanBlock, ScanBlock : Integer;
  CurBlock, CurScanBlock, TmpBlock : PByteArray;
  Factor : LongInt;
  PByte : ^Byte;

begin
  { prepare bit-field, it has only half of the size;
    additionally we need a temporary block for marking of primes within
    current block}
  FillChar(MainTable, sizeof(MainTable), 0);
  TmpBlock := SaveGetMem(SizeOf(ByteArray));
  if TmpBlock = NIL then begin
    CountPrimes3 := ERR_OUTOFMEM;
    exit;
  end;
  FillChar(TmpBlock^, sizeof(ByteArray), 0);
  MaxIndex := (MaxNumber + 1) shr 1;
  MainTableEntrys :=
    (MaxIndex + (longint(1) shl MAINTABLESHIFT) - 1) shr MAINTABLESHIFT;
  for i := 0 to MainTableEntrys - 1 do begin
    MainTable[i] := SaveGetMem(Sizeof(ByteArray));
    if MainTable[i] = NIL then begin
      Dispose(TmpBlock);
      CountPrimes3 := ERR_OUTOFMEM;
      exit
    end;
    FillChar(MainTable[i]^, sizeof(ByteArray), 0);
  end;
  Count := 1;
  BlockLen := (longint(1) shl MAINTABLESHIFT) shl 1; { Length of 1 block }
  OldTime := TickCount^ - 1;

  { search block by block }
  for BlockNumber := 0 to MainTableEntrys - 1 do begin

    { prepare copying primes from previous blocks }
    BlockBegin := longint(BlockNumber) * BlockLen + 1;
    BlockEnd := BlockBegin + BlockLen - 2;
    if BlockBegin < 3 then BlockBegin := 3;
    if BlockEnd > MaxNumber then BlockEnd := MaxNumber;
    ScanEnd := Round(sqrt(BlockEnd));
    if ScanEnd > BlockBegin then ScanEnd := BlockBegin - 2;
    CurBlock := MainTable[BlockNumber];
    LastScanBlock := ScanEnd shr (MAINTABLESHIFT + 1);

    { clear current block (all number are primes up to now) }
    Move(CurBlock^, TmpBlock^, sizeof(ByteArray));

    { copy prime number from previous block, block by block }
    for ScanBlock := 0 to LastScanBlock do begin

      { prepare copying }
      ScanBlockBegin := longint(ScanBlock) * BlockLen + 1;
      ScanBlockEnd := ScanBlockBegin + BlockLen - 2;
      if ScanBlockEnd > ScanEnd then ScanBlockEnd := ScanEnd;
      if ScanBlockBegin < 3 then ScanBlockBegin := 3;
      CurScanBlock := MainTable[ScanBlock];
      CurNumber := ScanBlockBegin;

      { scan known block bit by bit }
      while CurNumber <= ScanBlockEnd do begin
	CurIndex := CurNumber shr 1;
	if CurScanBlock^[(CurIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT] and
	   (1 shl (CurIndex and BITMASK)) <> 0 then begin

	  { there is a known prime number }
	  if TickCount^ - OldTime > 0 then begin
	    OldTime := TickCount^;
	    if CheckBreak(1, BlockBegin, Count, CurNumber) then begin
              Dispose(TmpBlock);
              CountPrimes3:= ERR_USERABORT;
              exit
            end
          end;
	  Increment := CurNumber shl 1;
	  Factor := (BlockBegin + CurNumber - 1) div CurNumber;
	  if Factor and 1 = 0 then inc(Factor);
          TmpNumber := Factor * CurNumber;

	  { mark multiples of the prime number as non-primes }
          while TmpNumber <= BlockEnd do begin
	    TmpIndex := TmpNumber shr 1;
	    PByte := @TmpBlock^[(TmpIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT];
            PByte^ := PByte^ or (1 shl (TmpIndex and BITMASK));
            inc(TmpNumber, Increment)
          end
        end;
        inc(CurNumber, 2)
      end
    end;

    { now search primes within the current block }
    CurNumber := BlockBegin;
    while CurNumber <= BlockEnd do begin
      CurIndex := CurNumber shr 1;
      if TmpBlock^[(CurIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT] and
	 (1 shl (CurIndex and BITMASK)) = 0 then begin

	{ there is one }
	if TickCount^ - OldTime > 0 then begin
	  OldTime := TickCount^;
	  if CheckBreak(0, CurNumber, Count, 0) then begin
            Dispose(TmpBlock);
            CountPrimes3:= ERR_USERABORT;
            exit
          end
        end;
	inc(Count);
	PByte := @CurBlock^[(CurIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT];
        PByte^ := PByte^ or (1 shl (CurIndex and BITMASK));
	Increment := CurNumber shl 1;
        TmpNumber := CurNumber + Increment;

	{ mark multples }
        while TmpNumber <= BlockEnd do begin
	  TmpIndex := TmpNumber shr 1;
	  PByte := @TmpBlock^[(TmpIndex and BYTEARRAYMASK) shr BYTEARRAYSHIFT];
          PByte^ := PByte^ or (1 shl (TmpIndex and BITMASK));
          inc(TmpNumber, Increment)
        end
      end;
      inc(CurNumber, 2)
    end
  end;
  Dispose(TmpBlock);

  { phew... }
  CountPrimes3:= Count
end;

{ parameter input }
procedure GetParameters(var MaximumNumber, BufferLen : LongInt; var Kind : Integer);
var
  Maximum : LongInt;
  Dummy : Char;

begin
  highvideo;
  Writeln(#13#10'Prime Number Calculation                         (c) 1995 Topical Software'#13#10);
  lowvideo;
  Writeln('This program searches all prime numbers within the first n');
  Writeln('numbers by the Sieve of Eratosthenes.'#13#10);
  Writeln('There is: method 1 - simple search');
  Writeln('          method 2 - skip odd numbers');
  Writeln('          method 3 - like method 2, but with optimized access');
  Writeln('          method 4 - method 3, but with 32 bit assembler code'#13#10);

  Maximum := MemAvail * 16;
  if Maximum > MAXNUMBER then Maximum := MAXNUMBER;
  Write('Up to which number should be searched (< ', Maximum, ')? ');
  repeat
    Readln(MaximumNumber);
  until (IOResult = 0) and (MaximumNumber >= 2);
  Write('Which system should be used (1..4; 0=Abort) ? ');
  repeat
    Readln(Kind);
  until (IOResult = 0) and (Kind >= 0) and (Kind <= 4);
  if Kind = 4 then begin
    Write('How much buffer memory should be used (4096..', MaxAvail, ')? ');
    repeat
      Readln(BufferLen);
    until (IOResult = 0) and (BufferLen >= 2) and (BufferLen < MaxAvail);
  end
end;

var
  MaximumNumber, BufferLen, Count : LongInt;
  Kind : Integer;

begin
  SetBreakCheck(true);
  InitSwapFile(-1, 0);
  UseBaseMem;
  GetParameters(MaximumNumber, BufferLen, Kind);
  StartStopping;
  case Kind of
    1: Count := CountPrimes1(MaximumNumber);
    2: Count := CountPrimes2(MaximumNumber);
    3: Count := CountPrimes3(MaximumNumber);
    4:
      if SwallowIsActive <> swa_Protected then begin
        Writeln;
        Writeln('Sorry, 32 bit assembler code does not work within Real Mode.');
        Count := 0
      end else
        Count := CountPrimes4(MaximumNumber, BufferLen);
  end;
  if Kind > 0 then ShowResult(MaximumNumber, Count);
end.