unit SwaTV2;

interface

{$X+,G+,F+}

implementation

uses
  Swallow, Drivers, Memory;

{ unit memory }

type
  PMemBuffer = ^TMemBuffer;
  TMemBuffer = record
    Size: Word;
    Master: ^Pointer;
    Data: record end;
  end;

  PtrRec = record
    Ofs, Seg: Word;
  end;

  PWord = ^Word;

const
  BufferPtr: Pointer = nil;


function Swallow_LowMemory: Boolean;
begin
  if SwallowIsActive = swa_inactive then asm
	MOV	AX,HeapEnd.Word[2]
	SUB	AX,HeapPtr.Word[2]
	SUB	AX,LowMemSize
	SBB	AX,AX
	NEG	AX
        mov     @Result,al
  end else asm
        mov     ax,knf_getlinearmeminfo
        int     32h
        db      66h
        xor     bx,bx
        mov     bx,LowMemSize
        db      66h
        sub     ax,bx
        db      66h
        sub     ax,12*1024
        dw      0
        db      66h
        sbb     ax,ax
        neg     ax
        mov     @Result,al
  end
end;

function Swallow_MemAllocSeg(Size: Word): Pointer;
var
  P, T: Pointer;
begin
  if SwallowIsActive = swa_inactive then begin
    Size := (Size + 7) and $FFF8;
    P := MemAlloc(Size + 8);
    if P <> nil then
    begin
      if PtrRec(P).Ofs = 0 then
      begin
        PtrRec(T).Ofs := Size and 15;
        PtrRec(T).Seg := PtrRec(P).Seg + Size shr 4;
      end else
      begin
        T := P;
        PtrRec(P).Ofs := 0;
        Inc(PtrRec(P).Seg);
      end;
      FreeMem(T, 8);
    end;
    Swallow_MemAllocSeg := P;
  end else begin
    P:= Swallow.MemAllocSeg(Size);
    if LowMemory then begin
      FreeMem(P, Size);
      Swallow_MemAllocSeg := NIL
    end else
      Swallow_MemAllocSeg := P;
  end
end;

procedure Swallow_GetBufMem(var P: Pointer; Size: Word);
var
  Rec : PMemBuffer;

begin
  if SwallowIsActive = swa_inactive then asm
	LES	DI,P
	MOV	AX,Size
	ADD	AX,(TYPE TMemBuffer)+15
	MOV	CL,4
	SHR	AX,CL
	MOV	DX,BufferPtr.Word[2]
	SUB	DX,AX
	JC	@@1
	CMP	DX,HeapPtr.Word[2]
	JBE	@@1
	MOV     CX,HeapEnd.Word[2]
	SUB	CX,DX
	CMP	CX,MaxBufMem
	JA	@@1
	MOV	BufferPtr.Word[2],DX
	PUSH	DS
	MOV	DS,DX
	XOR	SI,SI
	MOV	DS:[SI].TMemBuffer.Size,AX
	MOV	DS:[SI].TMemBuffer.Master.Word[0],DI
	MOV	DS:[SI].TMemBuffer.Master.Word[2],ES
	POP	DS
	MOV	AX,OFFSET TMemBuffer.Data
	JMP	@@2
@@1:	XOR	AX,AX
	CWD
@@2:	CLD
	STOSW
	XCHG	AX,DX
	STOSW
  end else begin
    Rec := MemAllocSeg(Size+sizeof(TMemBuffer));
    if Rec = Nil then
      P := Nil
    else begin
      Rec^.Master := @P;
      Rec^.Size := Size;
      P := @Rec^.Data
    end
  end
end;

procedure Swallow_FreeBufMem(P: Pointer);
var
  Rec : PMemBuffer;

begin
  if SwallowIsActive = swa_Inactive then asm
	MOV	AX,BufferPtr.Word[2]
	XOR	BX,BX
	XOR	CX,CX
	MOV	DX,P.Word[2]
@@1:	MOV	ES,AX
	CMP	AX,DX
	JE	@@2
	ADD	AX,ES:[BX].TMemBuffer.Size
	CMP	AX,HeapEnd.Word[2]
	JE	@@2
	PUSH	ES
	INC	CX
	JMP	@@1
@@2:	PUSH	ES
	LES	DI,ES:[BX].TMemBuffer.Master
	XOR	AX,AX
	CLD
	STOSW
	STOSW
	POP	ES
	MOV	AX,ES:[BX].TMemBuffer.Size
	JCXZ	@@4
@@3:	POP	DX
	PUSH	DS
	PUSH	CX
	MOV	DS,DX
	ADD	DX,AX
	MOV	ES,DX
	MOV	SI,DS:[BX].TMemBuffer.Size
	MOV	CL,3
	SHL	SI,CL
	MOV	CX,SI
	SHL	SI,1
	DEC	SI
	DEC	SI
	MOV	DI,SI
	STD
	REP	MOVSW
	LDS	SI,ES:[BX].TMemBuffer.Master
	MOV	DS:[SI].Word[2],ES
	POP	CX
	POP	DS
	LOOP	@@3
@@4:	ADD	BufferPtr.Word[2],AX
  end else begin
    if P <> NIL then begin
      Rec := Ptr(PtrRec(P).Seg, PtrRec(P).Ofs - sizeof(TMemBuffer));
      Rec^.Master^ := Nil;
      FreeMem(Rec, Rec^.Size + sizeof(TMemBuffer));
    end
  end
end;

procedure Swallow_SetMemTop(MemTop: Pointer);
begin
  if SwallowIsActive = swa_Inactive then asm
	MOV	BX,MemTop.Word[0]
	ADD	BX,15
	MOV	CL,4
	SHR	BX,CL
	ADD	BX,MemTop.Word[2]
	MOV	AX,PrefixSeg
	SUB	BX,AX
	MOV	ES,AX
	MOV	AH,4AH
	INT	21H
  end
end;


{ unit buffers }

const
  BufHeapSize: Word = 0;
  BufHeapPtr: Word = 0;
  BufHeapEnd: Word = 0;

type
  PBufBuffer = ^TBufBuffer;
  TBufBuffer = record
    Master: ^Word;
    Size: Word;
  end;

procedure MoveSeg(Source, Dest, Size: Word); assembler;
asm
	PUSH	DS
	MOV	AX,Source
	MOV	DX,Dest
	MOV	BX,Size
	CMP	AX,DX
	JB	@@3
	CLD
@@1:	MOV	CX,0FFFH
	CMP	CX,BX
	JB	@@2
	MOV	CX,BX
@@2:	MOV	DS,AX
	MOV	ES,DX
	ADD	AX,CX
	ADD	DX,CX
	SUB	BX,CX
	SHL	CX,1
	SHL	CX,1
	SHL	CX,1
	XOR	SI,SI
	XOR	DI,DI
	REP	MOVSW
	OR	BX,BX
	JNE	@@1
	JMP	@@6
@@3:	ADD	AX,BX
	ADD	DX,BX
	STD
@@4:	MOV	CX,0FFFH
	CMP	CX,BX
	JB	@@5
	MOV	CX,BX
@@5:    SUB	AX,CX
	SUB	DX,CX
	SUB	BX,CX
	MOV	DS,AX
	MOV	ES,DX
	SHL	CX,1
	SHL	CX,1
	SHL	CX,1
	MOV	SI,CX
	DEC	SI
	SHL	SI,1
	MOV	DI,SI
	REP	MOVSW
	OR	BX,BX
	JNE	@@4
@@6:	POP	DS
end;

function Swallow_GetBufSize(P: PBufBuffer): Word;
begin
  Swallow_GetBufSize := (P^.Size + 15) shr 4 + 1;
end;

procedure Swallow_SetBufSize(P: PBufBuffer; NewSize: Word);
var
  CurSize: Word;
begin
  CurSize := Swallow_GetBufSize(P);
  MoveSeg(PtrRec(P).Seg + CurSize, PtrRec(P).Seg + NewSize,
    BufHeapPtr - PtrRec(P).Seg - CurSize);
  Inc(BufHeapPtr, NewSize - CurSize);
  Inc(PtrRec(P).Seg, NewSize);
  while PtrRec(P).Seg < BufHeapPtr do
  begin
    Inc(P^.Master^, NewSize - CurSize);
    Inc(PtrRec(P).Seg, (P^.Size + 15) shr 4 + 1);
  end;
end;

procedure Swallow_InitBuffers;
var
  HeapSize: Word;
begin
  if SwallowIsActive = swa_Inactive then begin
    HeapSize := PtrRec(HeapEnd).Seg - PtrRec(HeapOrg).Seg;
    BufHeapPtr := PtrRec(HeapEnd).Seg - BufHeapSize;
    BufHeapEnd := PtrRec(HeapEnd).Seg;
    PtrRec(HeapEnd).Seg := BufHeapPtr;
  end
end;

procedure Swallow_DoneBuffers;
begin
  if SwallowIsActive = swa_Inactive then
    PtrRec(HeapEnd).Seg := BufHeapEnd;
end;

procedure Swallow_NewBuffer(var P: Pointer; Size: Word);
var
  BufSize: Word;

begin
  if SwallowIsActive = swa_Inactive then begin
    BufSize := (Size + 15) shr 4 + 1;
    if BufHeapPtr = BufHeapEnd then P := nil else
    begin
      with PBufBuffer(Ptr(BufHeapPtr, 0))^ do
      begin
        Master := @PtrRec(P).Seg;
        Size := 0;
      end;
      P := Ptr(BufHeapPtr + 1, 0);
      Inc(BufHeapPtr, BufSize);
    end;
  end else
    P := MemAllocSeg(Size);
end;

procedure Swallow_DisposeBuffer(P: Pointer);
begin
  if SwallowIsActive = swa_Inactive then begin
    Dec(PtrRec(P).Seg);
    Swallow_SetBufSize(P, 0);
  end else
    if P <> Nil then FreeMem(P, 0)      { swallow doesn't need the size }
end;

function Swallow_GetBufferSize(P: Pointer): Word;
begin
  case SwallowIsActive of
    swa_Inactive:
      begin
        Dec(PtrRec(P).Seg);
        Swallow_GetBufferSize := PBufBuffer(P)^.Size;
      end;
    swa_Protected:
      asm
        lsl ax,word ptr P + 2
        mov @Result,ax
      end;
    swa_Emulated:
      Swallow_GetBufferSize :=        { it's only a trick and not reliable }
        PWord(Ptr(PtrRec(P).Seg - 1, PtrRec(P).Ofs))^;
  end
end;

function Swallow_SetBufferSize(P: Pointer; Size: Word): Boolean;
var
  NewSize: Word;
begin
  if SwallowIsActive = swa_Inactive then begin
    Dec(PtrRec(P).Seg);
    NewSize := (Size + 15) shr 4 + 1;
    Swallow_SetBufferSize := False;
    if BufHeapPtr + NewSize - Swallow_GetBufSize(P) <= BufHeapEnd then
    begin
      Swallow_SetBufSize(P, NewSize);
      PBufBuffer(P)^.Size := Size;
      Swallow_SetBufferSize := True;
    end;
  end else begin
    Swallow_SetBufferSize := true;
    if Size = 0 then Size := 1;
    asm
        mov     bx,word ptr P + 2
        db      66h
        xor     cx,cx
        mov     cx,Size
        mov     ax,knf_resizewatchedmem
        int     32h
        jnc     @@1
        mov     @Result,false
    @@1:
    end
  end
end;

procedure Swallow_InitSysError; external;
procedure Swallow_DoneSysError; external;
{$L SwaSysIn.obj}

const
  PatchNum = 15;
  PatchAddr : array[1..PatchNum] of Pointer =
    (@LowMemory, @MemAllocSeg, @GetBufMem, @NewCache, @FreeBufMem,
     @DisposeCache, @SetMemTop, @InitMemory, @DoneMemory,
     @NewBuffer, @DisposeBuffer, @GetBufferSize, @SetBufferSize,
     @InitSysError, @DoneSysError);
  PatchProc : array[1..PatchNum] of Pointer =
    (@Swallow_LowMemory, @Swallow_MemAllocSeg,
     @Swallow_GetBufMem, @Swallow_GetBufMem, @Swallow_FreeBufMem,
     @Swallow_FreeBufMem, @Swallow_SetMemTop, @Swallow_InitBuffers,
     @Swallow_DoneBuffers,
     @Swallow_NewBuffer, @Swallow_DisposeBuffer,
     @Swallow_GetBufferSize, @Swallow_SetBufferSize, @Swallow_InitSysError,
     @Swallow_DoneSysError);

procedure PatchTurboVision;
var
  Counter : Integer;
  VPatchAddr, VPatchProc : Pointer;

begin
  for Counter := 1 to PatchNum do begin
    VPatchAddr := PatchAddr[Counter];
    VPatchProc := PatchProc[Counter];
    asm
        mov     di,word ptr VPatchAddr
        mov     bx,word ptr VPatchAddr + 2
        mov     ax,knf_AllocAliasLD
        int     32h
        mov     es,ax
        mov     bx,ax
        cld
        mov     al,0eah
        stosb
        mov     ax,word ptr VPatchProc
        stosw
        mov     ax,word ptr VPatchProc + 2
        stosw
        mov     ax,knf_FreeLD
        int     32h
    end
  end
end;

begin
  PatchTurboVision
end.