#ifdef __cplusplus
extern "C" {
#endif

#ifndef MEDV12_H
#define MEDV12_H

/************************************************************************
*
* MedV12.H
*
* Copyright (c) Microsoft Corporation 1993 -1994
* All rights reserved.
*
*************************************************************************
*
* Module intent: Header file for the MEDV12.DLL.
*
*************************************************************************
*
* Current owner: RHobbs
*
************************************************************************/

#include <mverror.h>

typedef struct de_tag MV, FAR *LPMV;

#ifndef VA_DEFINED
#define VA_DEFINED
typedef union va {
  DWORD dword;
  struct va_bitfields {
    unsigned long byteoff:14;   // allows max of 16K post-compress block
    unsigned long blknum:18;
  } bf;
} VA, FAR *QVA;
#define vaNil ((DWORD)-1)
#endif // VA_DEFINED

typedef LONG  ADDR;

typedef struct {
    VA vaStartSelection;
    long lichStartSelection;
    VA vaEndSelection;
    long lichEndSelection;
    } SELECTION, FAR *LPSELECTION;

typedef struct {
  RECT  Bound;  // Bounding rectange that polygon lies within
  WORD  NumPt;  // Number of points in polygon
  POINT Pt[1];  // Will have # of points defined by NumPt not 1
  } MVPOLYGON, FAR *LPMVPOLYGON;

typedef void (CALLBACK* MVCBPROC)();

// constants for keyboard selection
#define MVKEY_NONE  1
#define MVKEY_UP    2
#define MVKEY_DOWN  3
#define MVKEY_LEFT  4
#define MVKEY_RIGHT 5
#define MVKEY_START 6
#define MVKEY_END   7

#define MVSEL_CHAR      1
#define MVSEL_WORD      2
#define MVSEL_SENTENCE  3
#define MVSEL_PARAGRAPH 4
#define MVSEL_ALL       5


#ifndef CONTENTTYPE_DEFINED
#define CONTENTTYPE_DEFINED
enum CONTENTTYPE
{
  CONTENT_TEXT,
  CONTENT_BITMAP,
  CONTENT_WINDOW,
  CONTENT_UNKNOWN
};
#endif // CONTENTTYPE_DEFINED


#define HOTSPOT_STRING    0
#define HOTSPOT_HASH      1
#define HOTSPOT_POPUPHASH 2
#define HOTSPOT_UNKNOWN   3


VOID   _loadds FAR PASCAL MVSetInstance(HINSTANCE);
VOID   _loadds FAR PASCAL MVSetDCObtainer(LPMV, FARPROC);
LPMV   _loadds FAR PASCAL lpMVNew(LPERR);
LPMV   _loadds FAR PASCAL lpMVDuplicate(LPMV, LPERR);
VOID   _loadds FAR PASCAL MVDelete(LPMV);
BOOL   _loadds FAR PASCAL fMVApplyToDC(LPMV, HDC, LPRECT, LPERR);
BOOL   _loadds FAR PASCAL fMVSetWindow(LPMV, HWND, LPERR);
VOID   _loadds FAR PASCAL MVSetBkColor(LPMV, COLORREF);
VOID   _loadds FAR PASCAL MVSetTextColor(LPMV, COLORREF);
HWND   _loadds FAR PASCAL hwndMVGetWindow(LPMV);
HANDLE _loadds FAR PASCAL hMVSetFontTable(LPMV, HANDLE);
HANDLE _loadds FAR PASCAL hMVGetFontTable(LPMV);
VOID   _loadds FAR PASCAL MVSetKerningBoundary(LPMV, int);
int    _loadds FAR PASCAL iMVGetKerningBoundary(LPMV);
HWND   _loadds FAR PASCAL hwndMVGetEmbeddedWindow(LPMV, HWND, WORD);
POINT  _loadds FAR PASCAL ptMVGetSize(LPMV);
VOID   _loadds FAR PASCAL MVSetFileSystem(LPMV, HANDLE);
BOOL   _loadds FAR PASCAL fMVSetTitle(LPMV, HANDLE, LPCSTR, LPERR);
HANDLE _loadds FAR PASCAL hMVGetTitle(LPMV, LPCSTR);
BOOL   _loadds FAR PASCAL fMVHasNSR(LPMV);
BOOL   _loadds FAR PASCAL fMVHasSR(LPMV);
LONG   _loadds FAR PASCAL lMVTopicNumber(LPMV);
ADDR   _loadds FAR PASCAL addrMVGetNext(LPMV);
ADDR   _loadds FAR PASCAL addrMVGetPrev(LPMV);
BOOL   _loadds FAR PASCAL fMVSetAddress(LPMV, VA, int, LONG, LPERR);
VOID   _loadds FAR PASCAL MVGetAddress(LPMV, QVA, LPINT, LPLONG);
BOOL   _loadds FAR PASCAL fMVRealize(LPMV, LPRECT, LPERR);
VOID   _loadds FAR PASCAL MVUnrealize(LPMV);
HANDLE _loadds FAR PASCAL hMVCopyMedia(LPMV, LPERR);
BOOL   _loadds FAR PASCAL fMVPrintMedia(LPMV, HDC, RECT, LPRECT,
                                              FARPROC, LONG, LPERR);
BOOL   _loadds FAR PASCAL fMVMoveFocus(LPMV, BOOL, LPERR);
BOOL   _loadds FAR PASCAL fMVClickPoint(LPMV, POINT);
BOOL   _loadds FAR PASCAL fMVClickFocus(LPMV, LPERR);
HBRUSH _loadds FAR PASCAL hMVSetHighlightLook(LPMV, HBRUSH, int, LPERR);
HANDLE _loadds FAR PASCAL hMVSetHighlights(LPMV, HANDLE, BOOL, LPERR);
HANDLE _loadds FAR PASCAL hMVGetHighlights(LPMV);
BOOL   _loadds FAR PASCAL fMVGetHighlightRect(LPMV, int, LPRECT);
BOOL   _loadds FAR PASCAL fMVHighlightHotspots(LPMV, BOOL, LPERR);
BOOL   _loadds FAR PASCAL fMVOverHotspot(LPMV lpMv, POINT pt,
                                         enum CONTENTTYPE FAR *lpContent);
BOOL   _loadds FAR PASCAL fMVSetHotspotCallback(LPMV, MVCBPROC, LPVOID, LPERR);
BOOL   _loadds FAR PASCAL fMVGetHotspotCallback(LPMV, MVCBPROC FAR *,
                                                LPVOID FAR *, LPERR);
void   _loadds FAR PASCAL MVHidePartialLines(LPMV, BOOL);
POINT  _loadds FAR PASCAL ptMVGetScrollSizes(LPMV);
int    _loadds FAR PASCAL yMVScrollY(LPMV,
                                     LPPOINT, LPINT, LPINT, WORD, WORD, LPERR);
int    _loadds FAR PASCAL yMVGetYScrollPos(LPMV);
int    _loadds FAR PASCAL xMVScrollX(LPMV, LPPOINT, WORD, WORD, LPERR);
int    _loadds FAR PASCAL xMVGetXScrollPos(LPMV);
BOOL   _loadds FAR PASCAL fMVSetMagnifier(LPMV, int, LPERR);
int    _loadds FAR PASCAL iMVGetMagnifier(LPMV);
HANDLE _loadds FAR PASCAL hMVGetData(LPMV);
HANDLE _loadds FAR PASCAL hMVGetName(LPMV);

//
// Arbitrary Selection Funcitons
//
void   _loadds FAR PASCAL MVSelectPoint(LPMV, short, POINT, BOOL, LPERR);
void   _loadds FAR PASCAL MVSelectKey(LPMV, short, BOOL, LPERR);
void   _loadds FAR PASCAL MVGetSelectionPoints(LPMV, RECT FAR *, RECT FAR *);
BOOL   _loadds FAR PASCAL fMVClearSelection(LPMV, LPERR);
BOOL   _loadds FAR PASCAL fMVIsSelected(LPMV);
HANDLE _loadds FAR PASCAL hMVCopySelection(LPMV, LPERR);
VOID   _loadds FAR PASCAL MVSetSelection(LPMV, SELECTION);
BOOL   _loadds FAR PASCAL fMVGetSelection(LPMV, LPSELECTION);
BOOL   _loadds FAR PASCAL fMVPointInSelection(LPMV, POINT);


VOID   _loadds FAR PASCAL MVActivate(LPMV, BOOL);
BOOL   _loadds FAR PASCAL fMVSetPolygon(LPMV, LPMVPOLYGON, LPERR);
BOOL   _loadds FAR PASCAL fMVActivateHotspot(LPMV, LONG, LPERR);
LONG   _loadds FAR PASCAL lMVGetHotspotCount(LPMV, LPERR);

#endif // MEDV12_H

#ifdef __cplusplus
}
#endif
