/*
 * This file contains Application definitions and structures that
 * require NO MediaView knowlege.
 */

#define DIMENSION(x) (sizeof(x)/sizeof(x[0]))

#define NUMHISTORY 50
#define NUMBOOKMARKS 10

#define ALLOC(size)				Xalloc(size)
#define REALLOC(ptr, size)	Xrealloc(ptr, size)
#define FREE(ptr)				Xfree(ptr)

/*
 * In WIN16, any functions that are called from the HotspotCallback cannot
 * access global data (DS is wrong). Instead, we pass Application (Global)
 * information in the View.
 */
typedef struct tagAPPVIEW
	{
	int showSource;		/* update the source Window? */
	HWND hMain;				/* main application window */
	HWND hHist;				/* handle of history list window */
	HWND hSearch;			/* handle of the search results window */
	HWND hCallback;		/* popup window handle */
	int applyPolygon;		/* current layout polygon */
	} APPVIEW, far * LPAPPVIEW;

/*
 * These are supposed to be defined in windowsx.h on all platforms, 
 * but sometimes are not.
 */
#if !defined(GET_WM_COMMAND_CMD)
#define GET_WM_COMMAND_CMD(wp, lp)                   HIWORD(lp)
#endif
#if !defined(GET_WM_COMMAND_ID)
#define GET_WM_COMMAND_ID(wp, lp)                   (wp)
#endif
#if !defined(GET_WM_HSCROLL_CODE)
#define GET_WM_HSCROLL_CODE(wp, lp)                 (wp)
#endif
#if !defined(GET_WM_HSCROLL_POS)
#define GET_WM_HSCROLL_POS(wp, lp)                  LOWORD(lp)
#endif
#if !defined(GET_WM_VSCROLL_CODE)
#define GET_WM_VSCROLL_CODE(wp, lp)                 (wp)
#endif
#if !defined(GET_WM_VSCROLL_POS)
#define GET_WM_VSCROLL_POS(wp, lp)                  LOWORD(lp)
#endif
