// file.cpp : Defines the low level file (read) classes.
//
// Copyright (c) 1994 Michael Taylor
//

#include <zapp.hpp>
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
}
#include "fileview.h"

#include "file.hpp"

FileRead::FileRead (char * fname)
{
        gotfile = 0;
        currpos = filebuf = NULL;
        totallines = 0;
        lineno = 1;
        endline = startline = 1;
        findline = 1;
        
        if (!fname) {
		zFileOpenForm *OpenDlg = 
			ZNEW zFileOpenForm (app->rootWindow(), "Open a file", 
				                 "", NULL);
		if (OpenDlg->completed())
			strcpy (filename, OpenDlg->name ());
		else {
			delete OpenDlg;
		        return;
		}
		delete OpenDlg;
	} else 
		strcpy (filename, fname);
			
	if (!ReadInFile ())
		delete ZNEW zMessage (app->rootWindow(), (const char *)filename, 
				"File does not exist", 
        			MB_OK|MB_ICONINFORMATION);
}	  

FileRead::~FileRead () {
        if (filebuf) {
#ifdef WINDOWS
		GlobalUnlock (hglb); 
		GlobalFree (hglb); 
#else
        	free (filebuf);
#endif	
	}
}	  

int FileRead::ReadInFile () {
        struct _stat buf;
        FILE * fin;
        size_t i;
	char HUGE *p, HUGE *q, HUGE *r;
	char * vbuf;
        
	gotfile = 0;
	if (_stat((char *)filename, &buf)) {
	        return 0;
	}
	if (buf.st_mode & _S_IFDIR)
	        return 0;

	filesize = buf.st_size;
#ifdef WINDOWS
	hglb =  GlobalAlloc (GMEM_MOVEABLE, filesize+1); 
	currpos = filebuf = (char HUGE *) GlobalLock (hglb); 
#else
	currpos = filebuf = (char *) malloc (filesize+1); 
#endif	
	pageStart = pageEnd = findstart = currpos;
	
	if (!filebuf) {
		delete ZNEW zMessage (app->rootWindow(), "Memory unavailable", 
				"File could not be read", 
        			MB_OK|MB_ICONINFORMATION);
	        return 0;
	}

#if WINDOWS
	fin = fopen (filename, "rb");
#else
	fin = fopen (filename, "r");
#endif
	if (!fin) {
		delete ZNEW zMessage (app->rootWindow(), "File Open Error", 
				"File could not be read", 
        			MB_OK|MB_ICONINFORMATION);
	        return 0;
	}

  	totallines = 0;
	p = filebuf;
	i = 1024;
	
	vbuf = (char *)malloc (32760);
	if (vbuf)
		setvbuf (fin, vbuf, _IOFBF, 32760);
	
	filesize = 0;	// recalculate filesize as cr/lf are translated!
	while (!feof (fin)) {
//		if (filesize - (p - filebuf) < 1024)
//			i = (size_t)(filesize - (p - filebuf));
//		if (!i)
//		        break;	// no more to read
		if ((i = fread ((char *)p, 1, 1024, fin)) != 1024) {
		        if (ferror (fin)) {
				delete ZNEW zMessage (app->rootWindow(), 
					"Error: File could not be read", 
					"File View", 
					MB_OK|MB_ICONINFORMATION);
				fclose (fin);
        			return 0;
        		}
        	}
        	for (r = (q = p) + i; q < r; ++q)
                	if (*q == '\n' || *q == '\f') 
                        	++totallines; 
        	p += i;	// next section to read
        	filesize += i;
        }

	fclose (fin);
	if (vbuf)
		free (vbuf);
	
	gotfile = 1;
	
    	return 1;
}

int FileRead::completed () {
        return gotfile;
} 

char * FileRead::name () {
	if (!gotfile)
	        return NULL;
	else        
    		return filename;
}

/* 
   GetLine
   =======

   returns the next line in the file.
   
   Parameters
   ----------
   numchars:	number of characters in line returned
   dir:		direction to go from current position in file
*/
char HUGE * FileRead::GetLine (long *numchars, int dir) {
        char HUGE *start, HUGE *last, HUGE *p, HUGE *end;
        
        *numchars = 0;
        if (PREV==dir && atStart ())
		return NULL;
	        
        if (NEXT==dir && atEnd ()) {
		return NULL;
	}

	if (PREV==dir) { // scan backwards for previous line
	        p = last = currpos;	// end of line
	        if (last > filebuf)
                	--p;
	        for (; p > filebuf && *p != '\n' && *p != '\f'; --p);
	        currpos = p;
	        if (*p == '\n' || *p == '\f')
	                ++p;
	        start = p;
       	        --lineno;
	        *numchars = last - start;
	    
	        return start;	// start of line
	} else if (NEXT==dir) {
	        start = currpos;		// start of line
	        if (currpos > filebuf || lineno > 1) {
	                ++start;
		}
	                        
	        end = filebuf + filesize;	// end of file buffer
	        for (p = start; p < end && *p != '\n' && *p != '\f'; ++p);
	        currpos = p;
       	        ++lineno;
	        *numchars = currpos - start/* - 1*/;
	        
//char str1[256];
//sprintf (str1, "start=%d\ncurrpos=%d", 
//*start, *currpos);
//MessageBox (0, str1, "FileRead - GetLine", MB_OK);	
	        return start;	// start of line
	} else	// bad direction parameter
		return NULL;
}

int FileRead::ch(zKeyEvt*Ev) {
	return 1;
}

char HUGE * FileRead::moveToLineNo (long i) {
        char HUGE * sline;
        
        if (i <= 1) {			// sanity checks
                toStart ();
                
                return filebuf;
        } else if (i >= totallines) {
        	toEnd ();
                goto findstart;
	}
	
	if (i > lineno) {
	        while (!atEnd () && i >= lineno) {
                	++currpos;
        	        if (*currpos == '\n')
                	        ++lineno;
	        }
	} else if (i < lineno) {
	        while (!atStart () && i < lineno) {
                	--currpos;
        	        if (*currpos == '\n') {
                	        --lineno;
			}
	        }
	}
//	if (!atStart ())
//		--currpos;	// adjust currpos to last character in line
	
findstart:	
	sline = currpos;
	while (!atStart ()) {	// scan to find start of line
               	--sline;
               	if (sline == filebuf)
               	        break;
       	        if (*sline == '\n') {
			sline += 1;
			break;
               	}
	}
	
//char str1[256];
//sprintf (str1, "sline=%d\ncurrpos=%d\nsline=%-80.80s", 
//*sline, *currpos, (char *)sline);
//MessageBox (0, str1, "FileRead - moveToNextLine", MB_OK);	
	return sline;		// return start of line
}

void FileRead::moveToPageEnd () {
        currpos = pageEnd;
        lineno = endline;
}

void FileRead::moveToPageStart () {
        currpos = pageStart;
        lineno = startline;
}

void FileRead::setpageStart () {
        pageStart = currpos;
        startline = lineno;
}

void FileRead::setpageStart (char HUGE * setpos) {
        if (setpos) {
	        pageStart = setpos;
		startline = findline;
	} else {
	        pageStart = currpos;
		startline = lineno;
	}
}

void FileRead::setpageEnd () {
        pageEnd = currpos;
        endline = lineno;
}

int FileRead::atStart () {
        return currpos <= filebuf; // || pageStart <= filebuf;
} 

int FileRead::atEnd () {
        return currpos >= filebuf + filesize - 1;
} 

void FileRead::toEnd () {
        currpos = filebuf + filesize - 1;
        lineno = totallines;
        setpageStart ();
} 

void FileRead::toStart () {
        currpos = filebuf;
        lineno = 1;
        findline = 1;
        setpageStart ();
}
