//
// view.hpp : Declares the class interfaces for the low level view classes.
//
// Copyright (c) 1994 Michael Taylor
//

#ifndef __VIEW_HPP__
#define __VIEW_HPP__

#include <zapph\mdi.hpp>

void ResetMenu ();	/* defined by Parent Window to reset Menus */

class FileText : public zPane, public FileRead
{
public:
	FileText (zMDIChildFrame *, zSizeWithParent *, char *, int, int);
	~FileText ();
	zMDIChildFrame *parent;
	void 	ShowNextPage ();
	void 	ShowPrevPage ();
	void 	ShowCurrPage ();
	void 	HiliteCurrPage ();
	void 	ShowFoundPage (int dir);
	void 	ShowLastPage ();
	void 	ShowFirstPage ();
	void 	ShowNextLine ();
	void 	ShowPrevLine ();
	void	AddToOffset (int i) { horzOffset += i; }
	int	Offset () { return horzOffset; }
	void	SetOffset (int i) { horzOffset = i;}
	int	Rows () { return rows;}
	int	Cols () { return cols;}
	int  	FindString (char *, unsigned long, int);
	int	copyToClip ();		// copy selected region to clipboard
	int	startmarkx;		// start of the highlighted area
	int	startmarky;		// start of the highlighted area
	int	endmarkx;		// end   of the highlighted area
	int	endmarky;		// end   of the highlighted area
	long    startmline;		// line first marked
	long    endmline;		// line last marked
	int	prevmarky;		// max marked area
	int	highlight;		// area of the window needs highlighting
	int 	keyDown(zKeyEvt*);
	int 	keyUp(zKeyEvt*);
	void 	SetSize (int x, int y);
	void 	ResetScrollPos ();
	void	Setfindoffset (int i) { findoffset = i; }
	void	SetWordWrap (int i);
	void	SetHexMode (int i) { hexmode = i;}	
	int	printFile (zPrinterDisplay *);
	void	pageSetup (int, int, int, int, zFontSpec *);
	void    setpageStart ();
protected:
private:
	virtual int  printSetup(zPrinterDisplay *pr,zPrintJob *pj);
	virtual BOOL morePages();
	virtual int  print (zPrinterDisplay *pd, zRect *);
	virtual int  mouseMove(zMouseMoveEvt *);
	virtual int  mouseButtonDown(zMouseClickEvt*);
	virtual int  mouseButtonUp(zMouseClickEvt*);
	virtual int  draw (zDrawEvt*);
	int	down;			// mouse button is pressed
	int	emarkx;			// start of the highlighted area
	int	emarky;			// end   of the highlighted area
	long    smline;			// line first marked
	long    emline;			// line last marked
	int	scrolling;		// scrolling window
	int     inPrint;
	char HUGE *printPos;
	int	wordwrap;
	int	hexmode;
	int 	rows;
	int 	cols;
	int 	horzOffset;
	int	findoffset;
	int	rightMargin;
	int	leftMargin;
	int	topMargin;
	int	bottomMargin;
	void	clearRect ();
	void    gotoPageStart ();
	void    gotoPageEnd ();
	void    setpageEnd ();
	void    setpageStart (char HUGE *);
	char *	GetNextLine (int, int);
	char *	FormatLine (int , char HUGE *, char *);
	int 	DisplayLine (char *, int, int, int);
	void	MarkEndLine (int, int);
	void	SetMark ();
	zClipboard *clip;
	char  * dline;		// screen output line
	char HUGE * line;	// line from file
	long 	woffset;	// wrap offset
	long 	noffset;	// wrap offset
	long	dlen;		// length of screen line
	long	rlen;		// length of line from file
	long 	start_woffset;	// wrap offset
	long	start_rlen;	// length of line from file
	long 	end_woffset;	// wrap offset
	long	start_noffset;	//
	long	end_noffset;	//
	long	end_rlen;	// length of line from file
	zFontSpec *font;
};

class FileView : public zMDIChildFrame /*FileRead*/
{
public:
	FileView (zFrameWin *, zFontSpec *font=0, int vscroll=0, int hscroll=0, 
		char * fname=NULL);
	~FileView ();
        FileText *tWnd;
protected:
private:
	int 	keyDown (zKeyEvt*);
	int 	keyUp (zKeyEvt*);
	virtual int MDIActivate (zActivateEvt *);
	virtual int ch (zKeyEvt*);
	virtual int size (zSizeEvt *szEvt);
};

class FileEdit : public FileView
{
public:
	FileEdit (char * fname);
	~FileEdit ();
private:
};

class FVScroller : public zScrollerBase
{
public:
	FVScroller (FileText *);
	~FVScroller ();
private:
	FileText * parent;
	virtual int vertThumbPos ();
	virtual int horzThumbPos ();
	virtual int vertBottom ();
	virtual int vertTop ();
	virtual int horzLeft ();
	virtual int horzRight ();
	virtual int horzPageMove ();
	virtual int vertPageMove ();	
	virtual int horzLineMove ();
	virtual int vertLineMove ();	
};

// the maximum right scroll allowed
#define MAXRIGHT	256

#endif // __VIEW_HPP__
