**********************************************************************
*		PROFILER LIBRARY
**********************************************************************

xROMID 29A ( 666 )

ASSEMBLE
=FREEINTEMP?	EQU #06B3E
=TRAVERSE+	EQU #08400
=G_X@		EQU #0931B
=MPYAC		EQU #0DB9B
=SETNOLIBERR	EQU #11056
=GETPTREVALC	EQU #15C77
='EvalNoCK:	EQu #18F6A
=xSTO		EQU #20CCD
=XEQXPURGE	EQU #217F1
=GPPushR0Lp	EQU #307D2
=IDIV		EQU #65807
=G_NEXTIRQ	EQU #80058
=G_GraphPrtHook	EQU #8030E
=G_RSKTOP	EQU #806F3
=G_USEROB	EQU #80711
=G_ROMPARTS	EQU #80716
=G_ROMPTAB	EQU #809A3
RPL

EXTERNAL xTMK		( Make profiled library )
EXTERNAL xTINI		( Init profile data variable )
EXTERNAL xTRES		( Analyze profiled data )
EXTERNAL xTPG		( Purge latest profiled library )
EXTERNAL xTMOD		( Modify a command in a library )
EXTERNAL xTNAM		( Create 'Names' and 'Romps' )

EXTERNAL RclLib		( Finds a library )
EXTERNAL Profiled?	( Test if library is profiled )
EXTERNAL RclProfiled	( Finds latest profiled library )


ASSEMBLE
=CfgOb
RPL
:: 666 TOSRRP ;

**********************************************************************
* Library structure:
*
*	CON(5)	=DOLIB
*	REL(5)	EndOfLib
*	CON(2)	title length
*	NIBASC	'title'
*	CON(2)	title length
*	CON(3)	#romid
*	REL(5)	HashTable
*	REL(5)	MessageTable
*	REL(5)	LinkTable
*	REL(5)	ConfigObject
*	NIBHEX	body
*	CON(4)	CRC
**********************************************************************

**********************************************************************
* Desc:		Given a romid will create a duplicate with
*		a modified link table so that an execution profile
*		can be produced.
* Stack:	( %romid --> )
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME TMK
::
  CK1&Dispatch
  ONE
  ::

* Find the library to modify

	COERCE RclLib			( --> lib )

* Check if library is already profiled by checking for an ID

	Profiled?		( --> lib flag )

* If already profiled then just initialize timer variable

	casedrop xTINI

	FREEINTEMP? ?SKIP TOTEMPOB	( Make duplicate for modification )
	GARBAGE
	
	CODE
		GOSBVL	=SAVPTR
		A=DAT1	A
		D0=A			->lib
		D0=D0+	5
		C=DAT0	A		libsize
		AD0EX
		D0=A
		A=A+C	A
		R4=A			->libend
		D0=D0+	5
		GOSBVL	=TRAVERSE+	Skip name
		D0=D0+	13
		C=DAT0	A		linkoff
		AD0EX
		D0=A
		C=C+A	A
		R3=C			->linktable
		C=R4			->libend
		C=C-A	A
		DAT0=C	A		Set linkoff to new link table

* Required expansion:
* Link:		10+5*N
* Hack ID:	8
* Dummies:	52*N
* Starter:	Size1
* Stopper:	Size2
* CRC:		4
*
* Total:	22+57*N+Size1+Size2

		C=R3			->linktable
		D0=C
		D0=D0+	5
		C=DAT0	A
		C=C-CON	A,5
		GOSBVL	=DIV5
		R2=C			romptrs

		LA(5)	57
		GOSBVL	=MUL#
		LC(5)	22+(Size1)+(Size2)
		C=C+B	A

* Fix length field
		GOSBVL	=D0=DSKTOP
		A=DAT0	A
		D1=A
		D1=D1+	5
		A=DAT1	A
		A=A+C	A		libsize += expansion
		DAT1=A	A
* Fix link in tempob
		A=R4			->libend
		D0=A
		A=DAT0	A
		A=A+C	A		link += expansion
		DAT0=A	A
* Expand library
		A=R4			->libend
		GOSBVL	=MOVERSU
* Output new link table
		C=R4
		D0=C			->libend (old)
		LC(5)	=DOHSTR
		DAT0=C	A
		D0=D0+	5
		C=R2			romptrs
		A=C	A
		A=A+A	A
		A=A+A	A
		C=C+A	A		5*romptrs
		C=C+CON	A,5
		DAT0=C	A

		D0=D0+	5
		C=C+CON	A,8-5
		A=R2
		B=A	A		romptrs
		LA(5)	52-5
LinkLp		DAT0=C	A
		D0=D0+	5
		C=C+A	A
		B=B-1	A
		?B#0	A
		GOYES	LinkLp

* Output ID
		LCSTR	'Time'
		DAT0=C	8
		D0=D0+	8

* Output dummies
		B=0	A
dummylp		LC(N)	15
		CON(5)	=DOCOL
		CON(5)	=DOCODE
		CON(5)	5+5+6
		DAT0=C	15
		D0=D0+	15		

		LCHEX	23		LC(3)
		DAT0=C	B
		D0=D0+	2
		C=B	A		romptr
		DAT0=C	X
		D0=D0+	3
		LCHEX	C8		GOLONG
		DAT0=C	B
		D0=D0+	2
		C=R2			N
		C=C-B	A
		A=C	A
		A=A+A	A
		A=A+A	A		4*	
		C=A-C	A		3*
		CSL	A
		A=A+C	A	52*
		LC(5)	5+5+5+5+2-10
		C=A-C	A
		DAT0=C	4
		D0=D0+	4
		LC(N)	12
		CON(5)	=DOCODE
		CON(5)	5+5+6
		CON(2)	#23
		DAT0=C	12	
		D0=D0+	12
		C=B	A
		DAT0=C	X
		D0=D0+	3
		LCHEX	C8
		DAT0=C	B
		D0=D0+	2
		LC(5)	5+10+5+6+10+5+2-(Size1)-10
		C=A-C	A
		DAT0=C	4
		D0=D0+	4
		LC(5)	=SEMI
		DAT0=C	A
		D0=D0+	5
		B=B+1	A
		A=R2		N
		?B>=A	A
		GOYES	dummyok
		GOTO	dummylp
dummyok

* Output starter & finisher
* from end of stream
		AD0EX
		R1=A			->starter
		GOSBVL	=GETPTR
		AD1EX
		LC(5)	(Size1)+(Size2)
		GOSBVL	=MOVEDOWN
		AD0EX
		GOSBVL	=GETPTR
		AD0EX
		GOSBVL	=SAVPTR
* Fix ref to old link table
		A=R1			->starter
		LC(5)	(LinkRef)-(Start1)
		A=A+C	A
		A=A+CON	A,5+5
		C=R3			->link
		C=A-C	A		offset
		D0=A
		D0=D0+	2
		DAT0=C	A
* Fix CRC
*		GOSBVL	=D1=DSKTOP
		A=DAT1	A
		D0=A
		D0=D0+	5
		A=DAT0	A
		A=A-CON	A,4
		GOSBVL	=DoCRC
		DAT0=A	4
		GOVLNG	=GETPTRLOOP
	ENDCODE

* This object takes as input the command number, and starts the timer
* for it.

	CODE
Start1		GOSUB	Prepare
* Increase call counter
		AD0EX
		C=DAT0	A
		C=C+1	A
		B=C	A		callcounter
		DAT0=C	A
		D0=A			->calls
* Wind back total overhead
		D1=(5)	=TIMER2
		ST=0	15
		C=DAT1	8
		C=C+CON	W,12		Experimental
		DAT1=C	8
		ST=1	15
* Update counters in the slot
		A=DAT0	A
		A=A+1	A		Calls++
		DAT0=A	A
		D0=D0+	5
		A=DAT0	A
		A=A+1	A		Depth++
		DAT0=A	A
		D0=D0+	5
		D0=D0+	13
		C=B	A		callcounter
		DAT0=C	A
		D0=D0-	13

		A=A-1	A
		ST=0	0
		?A#0	A
		GOYES	noneed
		ST=1	0
noneed
* Get current time, sub stored value to get 'cumulative' start
* time, store that
		GOSUB	ThisTime
		A=0	W
		A=DAT0	13
		C=C-A	W
		?ST=0	0
		GOYES	nowork
		DAT0=C	13
nowork
* Execute wanted romp
		A=PC
LinkRef		LC(5)	0		This will be overwritten above
		A=A-C	A		to get offset to the old link table
		C=D	A		rompnumber
		A=A+C	A
		C=C+C	A
		C=C+C	A
		A=A+C	A
		A=A+CON	A,10
		D0=A
		C=DAT0	A
		A=A+C	A
		GOSBVL	=GETPTR
		PC=(A)	

Size1	EQU (*)-(Start1)+10
  ENDCODE

* This object takes command number as input, and stops the timer for it
  CODE
Start2		GOSUB	Prepare

* Update callnumber
		AD0EX
		C=DAT0	A
		C=C-1	A
		DAT0=C	A
		D0=A
* Update slot counters
		D0=D0+	5
		A=DAT0	A
		A=A-1	A		Depth--
		DAT0=A	A
		D0=D0+	5
		D0=D0+	13
		DAT0=C	A		callnumber
		D0=D0-	13

		ST=0	0
		?A#0	A
		GOYES	noneed2
		ST=1	0	
noneed2
* Get current time, sub stored start time, store that
		GOSUB	ThisTime
		A=0	W
		A=DAT0	13
		C=C-A	W
* Fix individual overhead
		C=C-CON	W,5	Estimated
		?ST=0	0
		GOYES	nowork2
		DAT0=C	13
nowork2		GOVLNG	=GETPTRLOOP

* Preparation for starting/stopping timers
* Returns:
*		A[A] = ->callcounter
*		D0   = ->slot	(calls)
*		D[A] = rompnumber

Prepare		RSTK=C
		GOSBVL	=SAVPTR
		C=RSTK
		D=0	A
		D=C	X			rompnumber

FindTimes	D0=(5)	=G_GraphPrtHook		Storage for 'Times' address
		A=DAT0	A
		D0=(5)	=G_USEROB		Validity check
		C=DAT0	A
		?A<=C	A
		GOYES	scanit			Below userob - rescan
		D0=A
		A=DAT0	A
		LC(5)	=DOHSTR
		?A=C	A
		GOYES	FoundT			Is HXS - assume ok
		D0=(5)	=G_USEROB
scanit		A=DAT0	A			Scan for 'Times'
		D0=A
		D0=D0+	5
		C=0	A
		C=DAT0	X
		A=A-C	A
		A=A-C	A
		A=A-C	A	-3*
		CSL	A
		A=A+C	A	+16*
		D0=A
		D0=D0+	8
		C=DAT0	A
		C=-C	A
FindTLp		?C=0	A
		GOYES	NoTimes
		AD0EX
		A=A-C	A
		AD0EX
		A=DAT0	12
		C=A	W
		LCSTR	'\5Times'
		?A=C	W
		GOYES	thisisT
		D0=D0-	5
		C=DAT0	A
		GONC	FindTLp
thisisT		GOSBVL	=TRAVERSE+
		AD0EX
		D0=(5)	=G_GraphPrtHook
		DAT0=A	A
		AD0EX
FoundT		D0=D0+	10		->callcounter
		AD0EX
		D0=A
		C=D	A		romp
		CSL	A		romp*16
		A=A+C	A
		A=A+C	A		->times + romp*32 +10
		AD0EX
		D0=D0+	5		->calls
		RTNCC

NoTimes		LC(5)	#204
		GOVLNG	=GPErrjmpC

**
** Quick time fetch with no sanity checks

ThisTime	A=0	W
		C=0	W
		D1=(5)	=G_NEXTIRQ
		ST=0	15
		A=DAT1	13
		D1=(5)	=TIMER2
		C=DAT1	8
		ST=1	15
		P=C	7
		C=P	15
		C=C+C	S
		C=0	S
		GONC	tims+
		P=	7
		C=-C	W
		C=-C	WP
tims+		C=A-C	W
		P=	0
		RTNCC

Size2	EQU (*)-(Start2)+10
	ENDCODE

* Now install the profiled library

	%0 OVER
	CODE
		GOSBVL	=PopASavptr
		D0=A
		B=A	A
		D0=D0+	10
		GOSBVL	=TRAVERSE+
		A=0	A
		A=DAT0	X
		R0=A			romid
		AD0EX
		A=A-B	A		offset to romid for ROMPTAB
		R1=A
		GOVLNG	=Push2#Loop
	ENDCODE

	4UNROLL UNROTDUP UNROT
	'EvalNoCK: xSTO
	COERCE G_X@ ?SKIP SETNOLIBERR
	ROT
	GARBAGE
	CODE
		GOSBVL	=POP#
		R3=A
		GOSBVL	=PopASavptr
		R4=A
		GOSBVL	=POP#
		R2=A
		A=R4
		D1=A
		A=DAT1	A
		LC(5)	=DOEXT1
		?C#A	A
		GOYES	+
		D1=D1+	5
		C=DAT1	A
		D1=D1+	5
		A=DAT1	A
		GONC	++
+		CD1EX
		A=0	A
++		R1=A
		A=R3
		A=A+C	A
		R0=A
		D0=(5)	=G_ROMPTAB
		C=DAT0	A
		B=C	A
		C=C+1	X
		GONC	+
		GOVLNG	=GPMEMERR
+		A=R2
		D0=D0+	3
		GONC	LF4188
LF417D		C=DAT0	A
		?C>=A	X
		GOYES	LF418E
		D0=D0+	16
LF4188		B=B-1	X
		GONC	LF417D
LF418E		AD0EX
		R3=A
		ST=0	10
LF4197		LC(5)	#10
		GOSBVL	=MOVERSU
		GONC	LF41B5
		GOSBVL	=DOGARBAGE
		A=R3
		GONC	LF4197
LF41B5		LC(5)	#10
		GOSBVL	#2541
		GOSBVL	=disprange
		D0=(5)	=G_RSKTOP
		A=DAT0	A
		B=A	A
		A=R3
		LC(5)	#10
		GOSBVL	#B340
		A=R3
		D0=A
		C=R2
		DAT0=C	A
		D0=D0+	3
		C=R0
		DAT0=C	A
		D0=D0+	5
		C=R1
		DAT0=C	A
		D0=(5)	=G_ROMPTAB
		C=DAT0	A
		C=C+1	X
		DAT0=C	A
		GOVLNG	=GETPTRLOOP
	ENDCODE

* Attach the library

	TOSRRP

* And finally initialize Times variable

	xTINI
  ;

;

**********************************************************************
* Desc:		Initialize Times variable
* Stack:	( --> )
* Note:		Relevant info is sought from the latest profiled lib
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME TINI
::
	CK0

	RclProfiled			( --> lib #romid #romps )

	DUP#0= case SYNTAXERR		( No romps to profile )

	UNROT2DROP			( --> #romps )

	NULLHXS SWAP			( Create and store variable )
	THIRTYTWO #* #5+ EXPAND
	' ID Times SysSTO		

	' ID Times Sys@ DROP		( Create hook for quick access )
	CODE
		A=DAT1	A
		LC(5)	=G_GraphPrtHook
		CD1EX
		DAT1=A	A
		CD1EX
		LOOP
	ENDCODE
	DROP
;

**********************************************************************
* Desc:		Analyze results from Times variable
* Stack:	( --> $ )
*
* Times variable format:
*		CON(5)	=DOHSTR
*		REL(5)	sizeoffset
*		CON(5)	callnumber
*		<N slots>
*
*	Slot:
*		CON(5)	Calls
*		CON(5)	Depth		(recursion counter)
*		CON(13)	Ticks
*		CON(5)	callnumber
*		CON(4)	FreeSpace
*
* Output format:
*
*	+--------------------------------------------
*	|Cmd Calls    Time Percent Name
*	|  0     0   0.000 %100.00 <optional name>
*	|  1     0   0.000 %  0.00 <optional name>
*	|...
*
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME TRES
::
	CK0
	GARBAGE
        ONE TestUserFlag		( reduced? )

	CODE

sSPC	EQU 4
sNAMES	EQU 5
sPACK	EQU 6

		GOSBVL	=popflag
		ST=1	sPACK		Packed representation
		GONC	+
		ST=0	sPACK
+
		GOSBVL	=SAVPTR

* Establish Names pointer

		ST=1	sNAMES
		GOSUB	Names@
		AD0EX
		R3=A			R3[A] = ->Names
		GONC	namsok
		ST=0	sNAMES
namsok

* Establish Times pointer

		GOSUB	Times@
		GONC	timsok
		LC(5)	#204
		GOVLNG	=GPErrjmpC
timsok

* Calculate number of romps

		D0=D0+	5
		A=DAT0	A
		A=A-CON	A,5		-5 for callnumber

		ASR	A		N*2
		ASRB.F	A		N
		R1=A			R1[A] = N

		A=A+1	A		+1 row for titles
		LC(5)	40		Max chars on row
		GOSBVL	=MUL#

* If Names variable exists then add it's size

		C=0	A
		?ST=0	sNAMES
		GOYES	noadd
		C=R3			->names
		D1=C
		D1=D1+	5
		C=DAT1	A
noadd		C=C+B	A
		GOSBVL	=MAKE$		R0[A] = ->output

* Find biggest execution time for % calculations

		GOSUB	Times@
		D0=D0+	10
		D0=D0+	5+5		Skip callnumber & Calls(1st)
		B=0	W		Current max = 0
		C=R1			N

		A=0	W		Clear high nibbles for ticks
MaxLp		A=DAT0	A		Depth
		D0=D0+	5
		?A#0	A		ROMPTR never finished! Exclude it
		GOYES	maxok
		A=DAT0	13		Compare time to max
		?A<=B	W
		GOYES	maxok
		B=A	W		New max
maxok		D0=D0+	16-5
		D0=D0+	16
		C=C-1	A		N--
		?C#0	A
		GOYES	MaxLp
		C=B	W
		R2=C			R2[W] = maxtime

* Output titles
		C=R0
		D1=C
		D1=D1+	10
		GOSUB	+
		NIBASC	'Cmd Calls    Time Percent Name\n'
+		C=RSTK
		D0=C
		LCASC	'\n'		Copy until newline (including it)
OutTit		A=DAT0	B
		DAT1=A	B
		D0=D0+	2
		D1=D1+	2
		?A#C	B
		GOYES	OutTit

**
** Start outputting data
**

		A=R3
		A=A+CON	A,5
		D0=A
		C=DAT0	A
		C=C+A	A
		R4=C			->namend
		A=A+CON	A,5
		R3=A			->nam1
		GOSUB	Times@
		D0=D0+	10+5		->calls (1st)
		D=0	A

* Output loop

ProfLp

* If packed representation then check calls first

		?ST=0	sPACK
		GOYES	nopack
		A=DAT0	A
		?A#0	A
		GOYES	nopack

* Slot has zero calls - don't output anything for it

		D0=D0+	16		Slot size = 32 nibbles
		D0=D0+	16

		?ST=0	sNAMES
		GOYES	++		Nothing to skip if names are off
		AD0EX
		AR3EX			A[A]=->line	R3[A] = ->times
		AD0EX
-		AD0EX
		D0=A
		C=R4	A
		?A>=C	A
		GOYES	+		end of 'Names' - done skipping
		A=DAT0	B
		D0=D0+	2
		LCASC	'\n'
		?A#C	B
		GOYES	-
+		AD0EX
		AR3EX			A[A]=->times	R3[A]=->line
		D0=A
++		GOTO	ProfCont	Continue with end test

* Output index
nopack		C=D	A
		P=	3-1
		GOSUB	OutHexC
* Output Calls
		LCSTR	' '
		DAT1=C	B
		D1=D1+	2
		A=0	W
		A=DAT0	A		Calls
		P=	5-1
		GOSUB	OutDec
		D0=D0+	5
* Now decide from Depth what to show

		A=DAT0	A		Depth
		D0=D0+	5
		?A=0	A
		GOYES	outtimeinfo

* Show invalid depth info

		D0=D0+	13		->callnumber
		LCSTR	'   ['
		DAT1=C	8
		D1=D1+	8
		A=0	W
		A=DAT0	A		callnumber
		P=	5-1
		GOSUB	OutDec
		LCSTR	']      '
		DAT1=C	14
		D1=D1+	14
		D0=D0+	5		skip callnumber
		GOTO	outnameinfo

* Show valid execution time info

outtimeinfo	A=0	W
		A=DAT0	13		Execution time
		C=0	W
		LC(5)	1000
		GOSBVL	=MPYAC		*1000
		C=0	W
		LC(5)	8192
		GOSBVL	=IDIV		/8192 = milliseconds
		GOSBVL	=HXDCW		In decimal
		SETHEX
		B=A	X
		ASR	W
		ASR	W
		ASR	W
		P=	4-1
		GOSUB	OutHex		Output 4 digits for seconds
		LCASC	'.'
		DAT1=C	B
		D1=D1+	2
		A=B	X
		P=	3-1		Output 3 unstripped digits for ms
		GOSUB	OutHexN
* Output % of total time
		LCSTR	' %'
		DAT1=C	4
		D1=D1+	4
		A=0	W
		A=DAT0	13
		C=0	W
		LC(5)	10000		time*10000
		GOSBVL	=MPYAC
		C=R2			maxtime
		?C=0	W
		GOYES	notim!		max time = 0 - % is 0
		GOSBVL	=IDIV
		GOSBVL	=HXDCW		% in decimal
		SETHEX
notim!		B=A	A
		ASR	A
		ASR	A
		P=	3-1
		GOSUB	OutHex		integer part
		LCASC	'.'
		DAT1=C	B
		D1=D1+	2
		A=B	A
		P=	2-1
		GOSUB	OutHexN		fractional part
		D0=D0+	13		skip time
		D0=D0+	5		skip call counter

* Output optional name
outnameinfo	?ST=0	sNAMES
		GOYES	linend
		ST=0	sSPC
		AD0EX
		AR3EX			A[A]=->line	R3[A] = ->times

		D0=A			Skip possible "DEFINE "
		A=DAT0	W
		C=A	W
		LCSTR	'DEFINE '
		?A#C	W
		GOYES	+
		D0=D0+	14
+		AD0EX

NameLp		D0=A
		C=R4
		?A>=C	A
		GOYES	NameEnd		end of 'Names' - no name
		A=DAT0	B
		D0=D0+	2
		LCASC	'\n'
		?A=C	B
		GOYES	NameEnd		No name on this line - skip
		?ST=1	sSPC
		GOYES	spcok
		ST=1	sSPC
		LCASC	' '		Put space to separate name
		DAT1=C	B
		D1=D1+	2
spcok		DAT1=A	B
		D1=D1+	2
		AD0EX
		GONC	NameLp		Copy until end of row/text

NameEnd		AD0EX			Swap Times pointer back in
		AR3EX
		AD0EX

* End line
linend		D0=D0+	4		Skip Free
		LCASC	'\n'
		DAT1=C	B
		D1=D1+	2

ProfCont	D=D+1	A
		C=R1
		?D>=C	A
		GOYES	ProfOk
		GOTO	ProfLp

ProfOk		AD1EX
		D0=A
		GOSBVL	=Shrink$
		GOVLNG	=GPPushR0Lp			

* Output stripped decimal number

OutDecC		A=0	W
		A=C	WP
OutDec		C=0	W
		C=A	WP
		A=C	W
		GOSBVL	=HXDCW

* Output stripped hex number

OutHexC		A=C	W
OutHex		SETHEX
		C=0	S
		CPEX	15
		LCASC	' '
		P=C	15
out0s		?A#0	P
		GOYES	outnon
		DAT1=C	B
		D1=D1+	2
		P=P-1
		GONC	out0s
		P=	0
		D1=D1-	2
		LCASC	'0'
		DAT1=C	B
		D1=D1+	2
		RTN

* Output hex number

OutHexN
outnon		DAT1=A	P
		C=0	B
		C=DAT1	1
		C=C-CON	B,10
		C=C+CON	B,10
		C=P	1
		P=	3
		CPEX	1
		GOC	ouh9
		C=C+CON	B,7
ouh9		DAT1=C	B
		D1=D1+	2
		P=P-1
		GONC	outnon
		P=	0
		RTN	

* Find related variables from HOME

Times@		LCSTR	'\5Times'
		P=	2*6-1
		GOTO	FindVar
Names@		LCSTR	'\5Names'
		P=	2*6-1

FindVar		B=C	W
		D0=(5)	=G_USEROB
		A=DAT0	A
		D0=A
		D0=D0+	5
		C=0	A
		C=DAT0	X
		A=A-C	A
		A=A-C	A
		A=A-C	A	-3*
		CSL	A
		A=A+C	A	+16*
		D0=A
		D0=D0+	8
		C=DAT0	A
		C=-C	A
FindVarLoop	?C=0	A
		GOYES	FindVarFail
		AD0EX
		A=A-C	A
		AD0EX
		A=B	W
		A=DAT0	WP
		?A=B	W
		GOYES	FoundVar
		D0=D0-	5
		C=DAT0	A
		GONC	FindVarLoop
FoundVar	P=	0
		GOVLNG	=TRAVERSE+
FindVarFail	P=	0
		RTNSC
	ENDCODE
;

**********************************************************************
* Desc:		Purge latest profiled lib
* Stack:	( --> )
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME TPG
::
	CK0

	RclProfiled			( --> lib #romid #romps )

	DROPSWAPDROP			( --> #romid )

* Detach the library

	DUP
	CODE
		GOSBVL	#77B2
		D=0	A
		GONC	inoff
offlp		C=DAT0	A
		?C=A	X
		GOYES	offthis
		D0=D0+	13
inoff		B=B-1	X
		GONC	offlp
offexit		GOVLNG	=GETPTRLOOP
offthis		D1=D1+	5
		C=DAT1	A
		C=C-1	A
		DAT1=C	A
		AD0EX
		LC(5)	13
		GOSBVL	=MOVEDSU
		GOTO	offexit
	ENDCODE

* Purge it
	DUP UNCOERCE ' ID 0 ID>TAG XEQXPURGE

* There must have been an earlier original, attach it

	TOSRRP
;

**********************************************************************
* Desc:		Given a ROMPTR and an object, this command
*		produces a new library in which the ROMPTR body
*		has been changed into the new object.
* Stack:
*		( ob ROMPTR --> lib )
* Notes:
*		The old object is not lost, so any code jumps
*		will still execute it. The actual change is really
*		just appending the object into the library and changing
*		the respective link field
* Error:
*		The library must be original, eg not a profiled one.
*		No such romp in the library
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME TMOD
::
  CK2&Dispatch
  FIFTEEN	( any romptr )
  ::

	ROMPTR># SWAP			( ob #cmd #romid )

* Find the library to modify

	RclLib				( ob #cmd lib )

* Error if profiled

	Profiled? case SYNTAXERR	( ob #cmd lib )

	FREEINTEMP? ?SKIP TOTEMPOB	( Make new copy for modification )

	UNROT				( lib ob #cmd )

* Now append the new command in

	GARBAGE
	CODE
		GOSBVL	=POP#		cmd
		R4=A	A		R4[A] = romptr
		GOSBVL	=SAVPTR

* Calculate object size

		A=DAT1	A
		D0=A
		GOSBVL	=SKIPOB
		CD0EX
		A=DAT1	A
		C=C-A	A		obsize
		R3=C	A		R3[A] = obsize

* Fix length field
		D1=D1+	5
		A=DAT1	A		->lib
		D0=A
		D0=D0+	5
		A=DAT0	A
		A=A+C	A		libsize += obsize
		DAT0=A	A

* Fix link in tempob
		A=A-C	A		old libsize
		CD0EX
		C=C+A	A		->libend (old)
		CD0EX
		A=DAT0	A
		A=A+C	A		link += expansion
		DAT0=A	A
* Expand library
		AD0EX			->libend (old)
		GOSBVL	=MOVERSU
* Append object to the end

		GOSBVL	=D1=DSKTOP
		A=DAT1	A
		D0=A			->ob
		D1=D1+	5
		A=DAT1	A
		A=A+CON	A,5		->libsize
		D1=A
		C=DAT1	A		libsize
		A=A+C	A		->libend (new)

		C=R3	A		obsize
		A=A-C	A		->libend - obsize
		A=A-CON	A,4		->target (4 nibs for CRC)
		R2=A			R2[A] = ->target
		D1=A
		GOSBVL	=MOVEDOWN

* Fix link table

		GOSBVL	=D1=DSKTOP
		D1=D1+	5
		A=DAT1	A
		D0=A			->lib

		D0=D0+	10
		GOSBVL	=TRAVERSE+
		D0=D0+	13		->linkoff

		C=DAT0	A
		?C=0	A
		GOYES	tmoderr		Oops!!!
		AD0EX
		A=A+C	A
		AD0EX
		A=DAT0	A
		LC(5)	=DOHSTR
		?A#C	A
		GOYES	tmoderr		Oops!!!

		D0=D0+	5
		C=DAT0	A
		AD0EX
		C=C+A	A
		B=C	A		->linkend

		C=R4	A		romptr
		C=C+1	A		to skip linksize too
		A=A+C	A
		C=C+C	A
		C=C+C	A
		A=A+C	A		->linkslot

		?A>B	A
		GOYES	tmoderr		Ooops!!

		D0=A			->linkslot
		C=R2	A		->target
		C=C-A	A
		DAT0=C	A

		A=DAT1	A		->lib
		D0=A
		D0=D0+	5
		A=DAT0	A
		A=A-CON	A,4
		GOSBVL	=DoCRC
		DAT0=A	4
		LC(5)	=DROP
		GOTO	+

tmoderr		LC(5)	=SYNTAXERR
+		GOVLNG	=GETPTREVALC
	ENDCODE
  ;
;

**********************************************************************
* Desc:		Given a text file of ROMPTR names and a romid,
*		creates the corresponding 'Names' and 'Romps' variables.
* Stack:	( $ %romid --> )
* Errors:	If any line is too long to be an identifier name.
*		If there are no lines at all.
* Notes:
*		Each line ending in '\n' is interpreted to be
*		a name for the romptr in the library indicated by romid.
*		The line number indicates the command number.
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME TNAM
::
  CK2&Dispatch
  #31
  ::
	COERCE

* Build Romps

	GARBAGE
	CODE
		GOSBVL	=SAVPTR
		GOSBVL	=POP#
		R1=A			R1[A] = romid

		A=DAT1	A
		D0=A
		GOSUB	Lines		B[A] = lines
		?B#0	A
		GOYES	+
tnamerror	LC(5)	=SYNTAXERR	Error - no lines
		GOVLNG	=GETPTREVALC
+		C=B	A
		R2=C	A		R2[A] = lines

* Final size needed =
*
*	$length
*	+ 5*lines	(DOIDNT)
*	+ 11*lines	(ROMPTR)
*	+ 10		(DOLIST SEMI )

	
		CSL	A		16*lines
		C=C+CON	A,5		+5
		A=DAT1	A
		D0=A
		D0=D0+	5	
		A=DAT0	A
		C=C+A	A		+size+5
		GOSBVL	=GETTEMP

		GOSBVL	=D1=DSKTOP
		D1=D1+	5
		A=DAT1	A		->$
		AD0EX
		D0=D0+	10
		R0=A	A		R0[A] = ->list
		D1=A

		LC(5)	=DOLIST		Output DOLIST
		DAT1=C	A
		D1=D1+	5

		C=0	A		rompnum counter = 0
		R3=C	A

-		GOSUB	OutRomp
		GOSUB	OutIdnt
		C=R3	A
		C=C+1	A		rompnum++
		R3=C	A
		A=R2	A		lines
		?C<A	A
		GOYES	-		Loop until rompnum = lines

		LC(5)	=SEMI		Output SEMI
		DAT1=C	A
		GOVLNG	=GPPushR0Lp	Return list

OutRomp		LC(5)	=DOROMP		Output DOROMP
		DAT1=C	A
		D1=D1+	5
		C=R1	X		Output romid
		DAT1=C	X
		D1=D1+	3
		C=R3	X		Output rompnum
		DAT1=C	X
		D1=D1+	3
		RTN

OutIdnt		LC(5)	=DOIDNT		Output DOIDNT
		DAT1=C	A
		D1=D1+	5+2		Skip to name part
		CD1EX
		B=C	A		->name part
		CD1EX
		LCASC	'\n'		Output until \n
-		A=DAT0	B
		DAT1=A	B
		D0=D0+	2
		D1=D1+	2
		?A#C	B
		GOYES	-
		D1=D1-	2		Back to \n
		CD1EX
		D1=C
		C=C-B	A
		CSRB.F	A		chars copied
		A=B	A
		AD1EX
		D1=D1-	2
		DAT1=C	B		Set IDNT length
		D1=A
		C=0	B		Error if too long to be IDNT
		?C=0	A
		RTNYES
		GOTO	tnamerror

Lines		D0=D0+	5		Count number of newline chars
		C=DAT0	A		in $ at D0 - result in B[A]
		D0=D0+	5
		C=C-CON	A,5
		D=C	A
		DSRB.F	A
		B=0	A
		LCASC	'\n'
-		D=D-1	A
		RTNC
		A=DAT0	B
		D0=D0+	2
		?A#C	B
		GOYES	-
		B=B+1	A
		GONC	-
	ENDCODE

	' ID Romps STO
  
* Build Names

	CODE
		GOSBVL	=POP#
		R1=A			R1[A] = romid
		GOSBVL	=SAVPTR

		A=DAT1	A
		D0=A			->$
		GOSUB	Lines
		C=B	A
		R2=C	A		R2[A] = lines

* Allocation for text:
*
*	$length
*	+ lines*7	"DEFINE "
*	+ lines*15	" ROMPTR xxx xxx"

		A=C	A
		CSL	A		16*
		A=A+A	A
		C=C+A	A		18*
		A=A+A	A
		C=C+A	A		22*
		A=DAT1	A
		D0=A
		D0=D0+	5
		A=DAT0	A
		A=A-CON	A,5		$nibbles
		ASRB.F	A		$length
		C=C+A	A
		GOSBVL	=MAKE$

		A=DAT1	A		->$
		AD0EX
		D0=D0+	10		->$
		D1=A			->output
	
		C=0	A
		R3=C	A		rompnum counter = 0

--		LCSTR	'DEFINE '	Output "DEFINE "
		DAT1=C	14
		D1=D1+	14
		LCASC	'\n'		Output name
-		A=DAT0	B
		D0=D0+	2
		?A=C	B
		GOYES	+
		DAT1=A	B
		D1=D1+	2
		GONC	-	
+		LCSTR	'\tROMPTR '	Output " ROMPTR "
		DAT1=C	16
		D1=D1+	16
		A=R1	X		Output romid as hex
		GOSUB	Out[X]
		LCASC	' '
		DAT1=C	B
		D1=D1+	2
		A=R3	X		Output rompnum as hex
		GOSUB	Out[X]
		LCASC	'\n'		Output \n
		DAT1=C	B
		D1=D1+	2

		C=R3	A
		C=C+1	A		rompnum++
		R3=C	A
		A=R2	A		lines
		?C<A	A
		GOYES	--		Loop until rompnum = lines
		GOVLNG	=GPOverWrR0Lp

Out[X]		ASRC			Shit A[X] to high nibbles
		ASRC
		ASRC
		LCASC	'9'		For comparison
		P=	16-3		Always 3 digits
-		A=0	A
		A=A+CON	B,3		A[B] = 03
		ASLC			A[0] = digit
		?A<=C	B		Change to hex character
		GOYES	+
		A=A+CON	B,7
+		DAT1=A	B
		D1=D1+	2
		P=P+1
		GONC	-		Loop until 3 digits done
		RTN
	ENDCODE

	' ID Names STO
 ;
;


**********************************************************************
* Desc:		Find library from ports
* Stack:	( #romid --> lib )
* Errors:	If library not found
**********************************************************************
NULLNAME RclLib
::
	THIRTYTHREE ZERO_DO (DO)
		INDEX@ G_X@ IT
		:: ?ACCPTR> ExitAtLOOP ;
	LOOP
	DUPTYPEBINT? case SETNOLIBERR
	SWAPDROP
;
**********************************************************************
* Desc:		Test if library is profiled
* Stack:	( lib --> lib flag )
**********************************************************************
NULLNAME Profiled?
CODE
		GOSBVL	=SAVPTR	
		A=DAT1	A
		D0=A
		D0=D0+	10		Skip DOLIB, size
		GOSBVL	=TRAVERSE+	Skip name
		D0=D0+	13		->link offset
		C=DAT0	A
		?C=0	A
		GOYES	liberr		Cannot profile an empty lib
		AD0EX
		A=A+C	A		->link table
		AD0EX
		A=DAT0	A		Check the table is ok
		LC(5)	=DOHSTR
		?A#C	A
		GOYES	liberr
		GOSBVL	=SKIPOB		->linkend
		A=DAT0	W
		C=A	W
		LCSTR	'Time'		Profiler ID
		?A=C	W
		GOYES	+
+		GOVLNG	=GPPushT/FLp	Push T if already profiled
liberr		LC(5)	=SYNTAXERR
		GOVLNG	=GETPTREVALC
ENDCODE
**********************************************************************
* Desc:		Finds latest profiled library
* Stack:	( --> lib #romid #romptrs )
* Errors:	If no profiled library is found
**********************************************************************
NULLNAME RclProfiled
CODE
		GOSBVL	=SAVPTR
		D0=(5)	=G_ROMPARTS
		A=DAT0	A
		R0=A			R0[A] = ->port0ptr
ScanLp		A=R0
		D0=A
		A=DAT0	A
		?A=0	A
		GOYES	ScanFail	End of port0 - no profiled library

		LC(5)	=DOLIB
		?A#C	A
		GOYES	ScanNxt		Not library - skip it

		D0=D0+	10
		GOSBVL	=TRAVERSE+	Skip name
		A=0	A
		A=DAT0	X		#romid
		R2=A	A		R0[A] = #romid

		D0=D0+	13		Skip to linkoff
		C=DAT0	A
		?C=0	A
		GOYES	ScanNxt		No link table - skip lib
		AD0EX
		A=A+C	A		->link table
		B=A	A		B[A] = ->link table
		AD0EX
		GOSBVL	=SKIPOB
		A=DAT0	W		Test for ID
		C=A	W
		A=DAT0	8
		LCSTR	'Time'
		?A=C	W
		GOYES	ScanOk		Found it - done

ScanNxt		A=R0			->port0 ptr
		D0=A
		GOSBVL	=SKIPOB		Skip object
		AD0EX
		R0=A
		GOTO	ScanLp		And continue loop

ScanFail	LC(5)	=SETNOLIBERR
		GOVLNG	=GETPTREVALC

ScanOk		A=B	A		->link table
		D0=A
		D0=D0+	5
		C=DAT0	A		link table size + 5
		GOSBVL	=DIV5
		C=C-1	A
		R1=C	A		R1[A] = romps

		A=R0	A		->lib
		GOSBVL	=GPPushA
		GOSBVL	=SAVPTR
		A=R2	A		#romid
		R0=A
		GOVLNG	=Push2#Loop
ENDCODE
**********************************************************************

