********************************************************
*	Anim3D v1.0 by Tamir Demri

ASSEMBLE
		NIBASC	\HPHP48-X\
RPL

ASSEMBLE
Tsize		EQU	104	table size
sDRAW		EQU	5

LINE		MACRO
		CON(1)	1
		CON(2)	0$1
		CON(2)	0$2
		CON(2)	0$3
		CON(1)	1
		CON(2)	0$4
		CON(2)	0$5
		CON(2)	0$6
LINE		ENDM

POINT		MACRO
		CON(1)	1
		CON(2)	0$1
		CON(2)	0$2
		CON(2)	0$3
POINT		ENDM

OLD_PNT		MACRO
		CON(1)	0
		CON(2)	$1
OLD_PNT		ENDM

RPL
::
 ClrDA1IsStat  RECLAIMDISP  TURNMENUOFF
 HARDBUFF  TOTEMPOB
CODE
*		GOSBVL	=DisableIntr
		INTOFF
		GOSBVL	=PopASavptr
		C=0	A
		LC(2)	20
		C=C+A	A
		GOSBVL	=D0->Row1
		GOSBVL	=ASLW5
		A=C	A
		R0=A		display info
	
		D1=(5)	#11B
		C=DAT1	A
		CD1EX
		D1=(4)	#100	D1->IRAMBUF

*--------------------------------------------------------------
*	Buffer description
*	~~~~~~~~~~~~~~~~~~
*	00 :	table address
*	05 :	phi speed
*	0A :	phi
*	0F :	quarter(1nib)
*	10 :	sin(phi)
*	15 :	cos(phi)
*	1A :	theta speed
*	1F :	theta
*	24 :	quarter(1nib)
*	25 :	sin(theta)
*	2A :	cos(phi)
*	2F :	GARBAGE AREA : #C2h=194 NIBS
*	enouph place for 24 line data.
*	F1 :	NOT ALLOWED!
*--------------------------------------------------------------

		GOSUB	TBLend
************************
* to get the sin value:
* take the proper element add 1 and devide by #100 (exept for the first
* element that corresponds to 0) 
TBLstrt
		CON(2)	#FF
		CON(2)	#3
		CON(2)	#7
		CON(2)	#B
		CON(2)	#F
		CON(2)	#13
		CON(2)	#16
		CON(2)	#1A
		CON(2)	#1E
		CON(2)	#22
		CON(2)	#26
		CON(2)	#2A
		CON(2)	#2E
		CON(2)	#31
		CON(2)	#35
		CON(2)	#39
		CON(2)	#3D
		CON(2)	#41
		CON(2)	#44
		CON(2)	#48
		CON(2)	#4C
		CON(2)	#50
		CON(2)	#53
		CON(2)	#57
		CON(2)	#5B
		CON(2)	#5E
		CON(2)	#62
		CON(2)	#65
		CON(2)	#69
		CON(2)	#6D
		CON(2)	#70
		CON(2)	#74
		CON(2)	#77
		CON(2)	#7A
		CON(2)	#7E
		CON(2)	#81
		CON(2)	#85
		CON(2)	#88
		CON(2)	#8B
		CON(2)	#8E
		CON(2)	#92
		CON(2)	#95
		CON(2)	#98
		CON(2)	#9B
		CON(2)	#9E
		CON(2)	#A1
		CON(2)	#A4
		CON(2)	#A7
		CON(2)	#AA
		CON(2)	#AD
		CON(2)	#B0
		CON(2)	#B3
		CON(2)	#B5
		CON(2)	#B8
		CON(2)	#BB
		CON(2)	#BD
		CON(2)	#C0
		CON(2)	#C3
		CON(2)	#C5
		CON(2)	#C7
		CON(2)	#CA
		CON(2)	#CC
		CON(2)	#CF
		CON(2)	#D1
		CON(2)	#D3
		CON(2)	#D5
		CON(2)	#D7
		CON(2)	#D9
		CON(2)	#DB
		CON(2)	#DD
		CON(2)	#DF
		CON(2)	#E1
		CON(2)	#E3
		CON(2)	#E5
		CON(2)	#E6
		CON(2)	#E8
		CON(2)	#EA
		CON(2)	#EB
		CON(2)	#ED
		CON(2)	#EE
		CON(2)	#EF
		CON(2)	#F1
		CON(2)	#F2
		CON(2)	#F3
		CON(2)	#F4
		CON(2)	#F5
		CON(2)	#F6
		CON(2)	#F7
		CON(2)	#F8
		CON(2)	#F9
		CON(2)	#FA
		CON(2)	#FB
		CON(2)	#FB
		CON(2)	#FC
		CON(2)	#FD
		CON(2)	#FD
		CON(2)	#FE
		CON(2)	#FE
		CON(2)	#FE
		CON(2)	#FF
		CON(2)	#FF
		CON(2)	#FF
		CON(2)	#FF
		CON(2)	#FF

TBLend		C=RSTK		table address
		DAT1=C	A
		D1=D1+	5
		R4=C		keep &table in R4
		C=0	W
		LC(1)	10
		DAT1=C	A	phi speed
		D1=D1+	5
		DAT1=C	6	phi+quarter
		GOSUB	sincos	
		D1=D1+	5	because	sincos return D1 -> speed
		C=DAT1	W	phi,quarter,sin,cos = 16 nibs
		D1=D1+	5+1+5+5
		DAT1=C	A	theta speed
		D1=D1+	5
		DAT1=C	W	phi,quarter,sin,cos = 16 nibs
		D1=D1-	5+5+5	D1 -> sin(phi)


************************************************************
* input :	D1 -> sin(phi)
************************************************************
draw		GOSUB	figEnd
		INCLUDE	Shape.dat

		CON(1)	0-1	end sign

figEnd		C=RSTK		figure address
		D0=C
		AD1EX
		D1=A
		C=0	A
		LC(2)	5+5+5+16	
		A=A+C	A	junk area
		R4=A

* here :	D0 -> x,y,z  , R4 -> x',y' , D1 -> sin(phi) , R3 = loop counter
nxpoint		C=DAT0	B
		D0=D0+	1
		?C=0	P	old point?
		GOYES	copyOld
		C=C+1	P
		GOC	calced

nwPoint		GOSUB	ftrans	*can be included*
		AD0EX		swap D0 and R4
		AR4EX
		AD0EX
		B=C	A
		C=0	A
		LC(2)	132/2	middle x
		A=A+C	A	result should be positive < 131 
		DAT0=A	B	store (x'+x_middle)
		C=C+C	A	CHECKING
		?A<C	A	CHECKING
		GOYES	ok	CHECKING
quit		GOTO	finito	CHECKING
ok
		LC(2)	64/2
		B=C-B	A	should be positive < 56
		CBEX	A
		D0=D0+	2
		DAT0=C	B	store (y'+y_middle)
		D0=D0+	2
		B=B+B	A	CHECKING
		?C>=B	A	CHECKING
		GOYES	quit	CHECKING
written		AD0EX		swap back
		AR4EX
		AD0EX
		GOTO	nxpoint

*********************************************
*	copy old point
* input:	D0 -> distance back , R4 -> x',y'
* output:	D0 -> x',y' , R4 -> next x,y,z
copyOld		C=0	A
		C=DAT0	B	points between
		D0=D0+	2	-> next 3d point
		AD0EX
		AR4EX		R4=next 3d point	A=next 2d point
		C=C+C	A
		C=C+C	A	C*=4 ( every point takes 4 nibs ) 
		C=A-C	A	old point address
		D0=C
		C=DAT0	A	old point val (4 nibs)
		D0=A		next 2d point place
		DAT0=C	4	write old x',y'
		D0=D0+	4
		GOTO	written

*********************************************
* here: all points calced
* R4 -> end of 2d point area

calced
* clear the display before redrawing
clrDisp		A=R0
		D0=A
		LC(2)	34*64/16-1	iteration counter
		A=0	W
clr		DAT0=A	W
		D0=D0+	16
		C=C-1	B
		GONC	clr

		A=R4
		D0=A
*		C=0	A
*		C=C-1	A
		DAT0=C	B	end sign
		LC(5)	(Points)*4
		C=A-C	A
nxtline		D0=C
		C=0	A
		C=DAT0	B
		D0=D0+	2
		B=C	A	x1
		C=C+1	B	check for valid value
		GOC	drwDone
		C=DAT0	B
		D0=D0+	2
		D=C	A	y1
		C=DAT0	B
		D0=D0+	2
		A=C	A	x2
		C=DAT0	B	y2
		D0=D0+	2
		CD0EX	
		RSTK=C		save next line address
		CD0EX		y2
		GOSUB	MakeLine	//** CAN BE INCLUDED ***//
		C=RSTK
		GOTO	nxtline

drwDone
		GOSUB	swpDisp		show what we drawed

		D1=D1-	5+5+6
		A=DAT1	A	&table
		R4=A
		D1=D1+	5	-> phi speed
*************************************************************

*********************************************************
* Key handling routine

		ST=0	sDRAW
waitkey		D0=(5)	(=addrATTNFLG)+2	#4226A+2
		A=DAT0	A
		D0=A
		A=DAT0	A
		?A=0	A	On key was not pressed?
		GOYES	noAttn
		A=0	A
		DAT0=A	A	FlushAttn
finito		GOSUB	restoreDisp
		GOSBVL	=Flush
		INTON
*		GOSBVL	=AllowIntr
		GOVLNG	=GETPTRLOOP
noAttn		LC(3)	#1FF
		GOSUB	OutIn
		?C#0	A
		GOYES	row2
		D0=(5)	=ANNCTRL	#10B
		C=DAT0	B
		A=C	A
		CBIT=0	4
		DAT0=C	B
		SHUTDN
		DAT0=A	B
		GOTO	waitkey

row2		LC(3)	#080	2nd row of the keyboard
		GOSUB	OutIn
		?C=0	B
		GOYES	row3

thetaS		?CBIT=0	3
		GOYES	phiS
		A=DAT1	A	A=speed
		A=A+1	A
		DAT1=A	A	higher speed
		ST=1	sDRAW
phiS		?CBIT=0	4
		GOYES	up
		D1=D1+	16
		D1=D1+	5
		A=DAT1	A
		A=A+1	A
		DAT1=A	A
		D1=D1-	16
		D1=D1-	5
		ST=1	sDRAW
up		?CBIT=0	1	up key?
		GOYES	row3

		D1=D1+	16
		D1=D1+	5
		GOSUB	incAngl
		D1=D1-	16
		D1=D1-	5
		ST=1	sDRAW

row3		LC(3)	#040	3rd row of the keboard
		GOSUB	OutIn
		?C=0	B
		GOYES	chkDraw

thetaSd		?CBIT=0	3
		GOYES	phiSd
		A=DAT1	A
		A=A-1	A
		DAT1=A	A
		ST=1	sDRAW

phiSd		?CBIT=0	4
		GOYES	right
		D1=D1+	16
		D1=D1+	5
		A=DAT1	A
		A=A-1	A
		DAT1=A	A
		D1=D1-	16
		D1=D1-	5
		ST=1	sDRAW

right		?CBIT=0	0	right key?
		GOYES	left
		D=C	A
		GOSUB	incAngl
		C=D	A
		ST=1	sDRAW

left		?CBIT=0	2	left key
		GOYES	down
		D=C	A	
		GOSUB	decAngl
		C=D	A
		ST=1	sDRAW

down		?CBIT=0	1	down key?
		GOYES	chkDraw
		D1=D1+	16
		D1=D1+	5
		GOSUB	decAngl
		D1=D1-	16
		D1=D1-	5
		ST=1	sDRAW

chkDraw		?ST=0	sDRAW
		GOYES	notdraw
		D1=D1+	5+6	D1 -> sin(phi)
		GOTO	draw
notdraw		GOTO	waitkey

**********************************
OutIn		OUT=C
		C=0	A
		GOVLNG	=CINRTN

**********************************	
* multiplies : B.A = A.A * C.A  (signed)

mul		B=A	A
		B=B+B	A
		GONC	pos1
		P=P+1
		A=-A	A
pos1		B=C	A
		B=B+B	A
		GONC	pos2
		P=P+1
		C=-C	A
pos2		GOSBVL	=MUL#
		?P#	1
		GOYES	resPos
		B=-B	A
resPos		P=	0
		RTN

***********************************************
* transform
* input :	A=x , C=y , D1 -> sin(angle)
* output :	C = x'= y*cos(angle)-x*sin(angle)
*		B = y*cos(angle)
*		D = x*sin(angle)

trans		D=C	A
		C=DAT1	A	sin
		GOSUB	mul
		C=B	A
		DCEX	A
		D1=D1+	5
		A=DAT1	A	cos
		GOSUB	mul
		C=B	A
		C=C-D	A	x'=(y*cos(phi)-x*sin(phi))*256
		D1=D1-	5	D1 -> sin
*		GOTO	Cdiv256

********************************************
* C shift right twice keeping correct sign
Cdiv256		B=C	A
		C=0	A
		LC(2)	#80
		C=C+B	A	so that will be round and not trunc 
		B=C	A
		CSR	A
		CSR	A
		B=B+B	A	if cary then C negative
		RTNNC
		P=	15
		C=P	3	do sign extention
		CPEX	4	P=0
		RTN
* bad alternative
*		P=C	4
*		CSR	A
*		CSR	A
*		C=P	3
*		CPEX	4
*		RTN

************************************
* load 2 nibs (*D0) into C.B and 
* do sign extention to C.A.   uses D.
* input :	D0 -> data
* output :	C.A= *D0

load2		C=0	A
		C=DAT0	B
		D0=D0+	2
		D=C	A
		D=D+D	A
		D=0	B	now D.A=#100h only if C.B is negative (else #0)
		C=C-D	A
		RTN

************************************************
* full transform : x,y,z -> x',y'
* input :	D0 -> x,y,z  ,  D1 -> sin(phi)
* output :	A=x' , C=y'

ftrans		GOSUB	load2
		A=C	A	x
		R1=C
		GOSUB	load2
		R2=C		y
		GOSUB	trans
		CR1EX
		A=R2
		A=-A	A
		GOSUB	trans
		A=C	A
		GOSUB	load2	z
		D1=D1+	16
		D1=D1+	5
		GOSUB	trans
		A=R1
		D1=D1-	16
		D1=D1-	5
		RTN

*********************************
* increase angle 
* input :	D1 -> angle speed
incAngl		C=DAT1	A	speed
		D1=D1+	5
		GOTO	adjAngl

decAngl		C=DAT1	A	speed
		D1=D1+	5
		C=-C	A
*		GOTO	adjAngl

***********************************************
* change angle.
* input :  D1 -> angle , C = the change , R4 = &table
* changes cos,sin too.

adjAngl		A=DAT1	A	A=angle
		A=A+C	A	each table element is 2 nibs
		A=A+C	A	so add twice
		B=0	A	make B quarter counter
		C=C+C	A
		LC(5)	2*(Tsize)-2	ovf angle (dont effect cary)
		GOC	Bneg	if carry then C (the change) was negative
Bpos		?A<C	A	angle value ok?
		GOYES	Qok
		A=A-C	A	next quarter so decr angl (angl-=90)
		B=B+1	A	num of quarters passed
		GOTO	Bpos
Bneg		?A<C	A
		GOYES	Qok
		A=A+C	A
		B=B-1	A
		GOTO	Bneg

Qok		DAT1=A	A	store the new angle
		?B=0	A	need to adjust quarter?
		GOYES	sincos
		D1=D1+	5	D1 -> quarter
		C=DAT1	B
		B=B+C	A	adjust quarter
		LC(1)	#3	mask: C.1=#0011b
		C=C&B	P	keep only bits 0,1
		DAT1=C	1
		D1=D1-	5	D1 -> angle
*		GOTO	sincos	change sin,cos


*******************************************	
* calculates and stores sin cos.
* input : R4 -> table , D1 -> angle

sincos		A=R4
		D0=A		table address
		C=DAT1	A	angle
		B=C	A
		D1=D1+	5
		A=A+C	A	adr(angle)
		AD0EX		A=&table
		A=A-C	A
		LC(5)	2*(Tsize)-2
		A=A+C	A	adr(90-angle)
		C=0	A
		C=DAT0	B
		C=C+1	A
		?B#0	A
		GOYES	skip
		C=0	A
skip		AD0EX
		A=0	A
		A=DAT0	B
		A=A+1	A	cos
		C=DAT1	S	quarter
		D1=D1+	1
Qloop		C=C-1	S
		GOC	store
		C=-C	A
		ACEX	A
		GOTO	Qloop
store		DAT1=C	A
		D1=D1+	5
		DAT1=A	A
		D1=D1-	5+1+5+5		-> speed
		RTN

*************************************************
* changes the grob displayed
* input:	R0 = [ cur grob ],[ new grob ]
* output:	R0 = [ cur grob ],[ (prev=next) grob ]
* uses:		A,C,R0

swpDisp		A=R0
		GOSUB	storDisp
		C=A	A	new grob
		GOSBVL	=ASRW5	A.A=cur grob
		ACEX	A	A.A=new grob
		GOSBVL	=ASLW5
		A=C	A	prev grob
		R0=A
		RTN

restoreDisp	GOSBVL	=D0->Row1
*		GOTO	storDisp

*********************************************
* changes the display grob
* input:	A -> Grob data (Prolog+20)
* uses:		C, D0

storDisp	D0=(5)	=DISP1CTL
		DAT0=A	A	display new grob
		D0=(2)	=BITOFFSET	
		?ABIT=1	0
		GOYES	odd
even		LC(1)	8	DON=1 , no offset
		DAT0=C	1
		C=0	A
		GOTO	wrNibs
odd		LC(1)	8+4	4 bit offset
		DAT0=C	1
		LC(3)	#FFE
wrNibs		D0=(2)	=LINENIBS
		DAT0=C	X
		RTN

*********************************************************
* make line (x1,y1)->(x2,y2). if ST(sDEL)=1 then delete line
* R0.A = ADDR OF GROB
* A=X2 B=X1 C=Y2 D=Y1
* uses D0,A,B,C,D,R1,R2,R3,R4,cary

MakeLine
sREV		EQU	7
*sDEL		EQU	6
		?C>=D	A
		GOYES	DLT
		CDEX	A	EXCHANGE
		ABEX	A	POINTS
DLT		ST=0	sREV
		A=A-B	A	DELTA X
		GONC	STX
		A=-A	A
		ST=1	sREV
STX		A=A+1	A
		R1=A		SAVE Xmax
		C=C-D	A	DELTA Y
		C=C+1	A
		R2=C		SAVE Ymax
		C=B	A
		CDEX	A	C=Y1,D=X1
		A=0	A
		LA(2)	#22	NIBBS ON LINE
		GOSBVL	=MUL#
		A=R0		A -> the grob we don't look at
		A=A+B	A	A=address of line
		C=D	A	X1
SAME_LN		B=0	A
		B=B+1	A	MASK
		?CBIT=0	0
		GOYES	N_SHFT1
		B=B+B	A
N_SHFT1		CSRB.F	A
		?CBIT=0	0
		GOYES	N_SHFT2
		B=B+B	A
		B=B+B	A
N_SHFT2		CSRB.F	A
		C=C+A	A
		D0=C     address of nibble
		A=R1		DELTA X
		C=R2		DELTA Y
		?C>A	A
		GOYES	Yindep
* run over X and check Y
Xindep		R3=A
		CSRB.F	A
		R4=C
		C=A	A
		D=C	A
		D=D-1	A
NXTDOT		GOSUB	DOT
		GOSUB	CHKNEXT
		GOC	IX
		GOSUB	INCY
IX		GOSUB	INCX
		D=D-1	A
		GONC	NXTDOT
		RTN

* run over Y and check X
Yindep		R1=C
		R2=A
		R3=C
		ASRB.F	A
		R4=A
		D=C	A
		D=D-1	A
NXTDT		GOSUB	DOT
		GOSUB	CHKNEXT
		GOC	INX
		GOSUB	INCX
INX		GOSUB	INCY
		D=D-1	A
		GONC	NXTDT
		RTN

CHKNEXT		A=R4.F	A	min
		C=R2.F	A	min
		A=A+C	A
		R4=A.F	A
		C=R3.F	A	max
		?A<C	A
		RTNYES		(CARY)
		A=R1.F	A
		C=C+A	A
		R3=C.F	A
		RTNCC		(NO CARY)

INCY		AD0EX
		LC(5)	#22
		A=A+C	A
		AD0EX
		RTN

INCX		?ST=1	sREV
		GOYES	MX
		C=B	B
		B=B+B	B
		?CBIT=0	3
		RTNYES	
		B=B-CON	B,15
		D0=D0+	1
		RTN

MX		BSRB.F	B
		?B#0	B
		RTNYES
		B=B+CON	B,8
		D0=D0-	1
		RTN
	
DOT		A=DAT0	B
		A=A!B	B turn on dot
*		?ST=0	sDEL
*		GOYES	WRITE
*		C=B	B
*		C=-C-1	B
*		A=A&C	B turn off dot
WRITE		DAT0=A	B
		RTN

ENDCODE
 ClrDAsOK
;
