
; This is the source code for the default "QED.font"
; You may create other fonts as you wish - if you want
; to create a font of a different size, please contact
; me to gain further help.
;                              Lutz Vieweg

; Assembler invocation: CLASS -a FONT.a -rn
; Rename FONT.o into QED.font at your HP48sx

nib_per_row	equ	(((131+7)/8)*8)/4	; do not change

font	
	textr	"HPHP48-E"		; do not change
	
	dcr.5	$02b88
fontbeg	
	dcr.5	fontend-fontbeg
	
	move.a	(d0),a
	add.a	#5,d0
	jmp	(a)
font_base	
	dcr.5	$5146f		; do not change
	dcr.5	font_bpl-font_base
	dcr.5	font_xnotab-font_base
	dcr.5	font_xshtab-font_base
	dcr.5	font_ynotab-font_base
	dcr.5	font_name-font_base
font_paras	
	dcr.5	5	;f_xsize   | width in points with space
	dcr.5	2	;f_xnsize  | width in int(nibbles)
	dcr.5	6-1	;f_ysize-1 | lenght in points
	dcr.5	10	;f_rows    | number of text lines on screen
	dcr.5	26	;f_cols    | number of text cols on screen
	dcr.5	4	;f_dtalensh| total lenght of one-char-data in 2^x nibbles
	dcr.16	%11100000	;f_xmask   | masks out unused bits 
	dcr.5	59*nib_per_row;f_lloffs  | last line offset ((8rows*8lines)-1)*nib_per_row
	dcr.5	60-2	;f_tlines-2| total used lines - 2
	
fontbase_end	
	
font_xnotab	; how many nibbles is the character away from the beginning
	; of the row? Have to be (f_cols) values
	dcr.8	0,1,2,3,5,6,7,8,10,11
	dcr.8	12,13,15,16,17,18,20,21
	dcr.8	22,23,25,26,27,28,30,31
	
font_xshtab	; how many pixels is the char-data to be shifted for
	; each colum?
	dcr.1	0,1,2,3,0,1,2,3,0,1,2,3
	dcr.1	0,1,2,3,0,1,2,3,0,1,2,3
	dcr.1	0,1
	
font_ynotab	; offsets for each row (have to be f_rows values)
	dcr.8	0*nib_per_row
	dcr.8	6*nib_per_row
	dcr.8	12*nib_per_row
	dcr.8	18*nib_per_row
	dcr.8	24*nib_per_row
	dcr.8	30*nib_per_row
	dcr.8	36*nib_per_row
	dcr.8	42*nib_per_row
	dcr.8	48*nib_per_row
	dcr.8	54*nib_per_row
	
font_name	textr	"HP48sx 5*6 "		; FontName terminated with 0
	dc.2	0
	
font_bpl	; Char-Data  (not complete yet)
			;0
	dcg.b	%11111000
	dcg.b	%10001000
	dcg.b	%10001000
	dcg.b	%10001000
	dcg.b	%10001000
	dcg.b	%11111000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00001000
	dcg.b	%00011000
	dcg.b	%00111000
	dcg.b	%01111000
	dcg.b	%11111000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
			;20
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01010000
	dcg.b	%11111000
	dcg.b	%01010000
	dcg.b	%11111000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01110000
	dcg.b	%10100000
	dcg.b	%01110000
	dcg.b	%00101000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%10100000
	dcg.b	%01000000
	dcg.b	%10110000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000 
	dcg.b	%01000000 
	dcg.b	%01000000 
	dcg.b	%01000000 
	dcg.b	%00100000 
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%11000000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00010000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	%00000000
	dcg.b	0,0
			;30
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%11000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%00010000
	dcg.b	%01100000
	dcg.b	%00010000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%11110000
	dcg.b	%00010000
	dcg.b	%00010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%00010000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01110000
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%00010000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%00010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
			;40
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10110000
	dcg.b	%10000000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%11110000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10000000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%10000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01110000
	dcg.b	%10000000
	dcg.b	%10110000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%11110000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%00010000
	dcg.b	%00010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10001000
	dcg.b	%11011000
	dcg.b	%10101000
	dcg.b	%10001000
	dcg.b	%10001000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%11010000
	dcg.b	%10110000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
			;50
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10100000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01110000
	dcg.b	%10000000
	dcg.b	%01100000
	dcg.b	%00010000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10001000
	dcg.b	%10001000
	dcg.b	%10101000
	dcg.b	%10101000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%10100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%00010000
	dcg.b	%01100000
	dcg.b	%10000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%00010000
	dcg.b	%00010000
	dcg.b	%00010000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%11111000
	dcg.b	%00000000
	dcg.b	0,0
			;60
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01110000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01110000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00010000
	dcg.b	%01110000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%11110000
	dcg.b	%10000000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00110000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00010000
	dcg.b	%11100000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%11000000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%10100000
	dcg.b	%11000000
	dcg.b	%10100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%11010000
	dcg.b	%10101000
	dcg.b	%10101000
	dcg.b	%10101000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
			;70
	dcg.b	%00000000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01110000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00010000
	dcg.b	%00010000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10110000
	dcg.b	%11000000
	dcg.b	%10000000
	dcg.b	%10000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01110000
	dcg.b	%11000000
	dcg.b	%00110000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10001000
	dcg.b	%10101000
	dcg.b	%10101000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01110000
	dcg.b	%00010000
	dcg.b	%01100000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	%01000000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11000000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%11000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01010000
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%11110000
	dcg.b	%11110000
	dcg.b	%11110000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
			; 80
	dcg.b	%00010000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%10100000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00110000
	dcg.b	%00100000
	dcg.b	%10100000
	dcg.b	%01100000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11000000
	dcg.b	%11100000
	dcg.b	%11110000
	dcg.b	%11100000
	dcg.b	%11000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%11111000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10000000
	dcg.b	%01000000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01010000
	dcg.b	%10100000
	dcg.b	%10100000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%11110000
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%01000000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%10101000
	dcg.b	%01110000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01110000
	dcg.b	%10101000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01010000
	dcg.b	%10100000
	dcg.b	%00100000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00010000
	dcg.b	%00100000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01110000
	dcg.b	%10000000
	dcg.b	%11110000
	dcg.b	%10000000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10100000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%00010000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%11110000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10000000
	dcg.b	%01000000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%01010000
	dcg.b	%01100000
	dcg.b	%01000000
	dcg.b	%10000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01110000
	dcg.b	%10100000
	dcg.b	%10100000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01110000
	dcg.b	%10100000
	dcg.b	%00100000
	dcg.b	%00010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01010000
	dcg.b	%10001000
	dcg.b	%10101000
	dcg.b	%10101000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11111000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11111000
	dcg.b	%11111000
	dcg.b	%11111000
	dcg.b	%11111000
	dcg.b	%11111000
	dcg.b	%11111000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%01010000
	dcg.b	%10101000
	dcg.b	%10101000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01110000
	dcg.b	%10100000
	dcg.b	%01110000
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00110000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00110000
	dcg.b	%01000000
	dcg.b	%11110000
	dcg.b	%00100000
	dcg.b	%11000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10001000
	dcg.b	%11101000
	dcg.b	%11001000
	dcg.b	%11101000
	dcg.b	%10001000
	dcg.b	%11111000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%00010000
	dcg.b	%01110000
	dcg.b	%10010000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00101000
	dcg.b	%01010000
	dcg.b	%10100000
	dcg.b	%01010000
	dcg.b	%00101000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00010000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10001000
	dcg.b	%11101000
	dcg.b	%11011000
	dcg.b	%10111000
	dcg.b	%10001000
	dcg.b	%11111000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%10100000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%00100000
	dcg.b	%11100000
	dcg.b	%10000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%11100000
	dcg.b	%00100000
	dcg.b	%11100000
	dcg.b	%00100000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10100000
	dcg.b	%10100000
	dcg.b	%10100000
	dcg.b	%11010000
	dcg.b	%10000000
	dcg.b	0,0
	
	dcg.b	%11110000
	dcg.b	%11010000
	dcg.b	%11010000
	dcg.b	%01010000
	dcg.b	%01010000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00100000
	dcg.b	%00010000
	dcg.b	%01100000
	dcg.b	0,0
	
	dcg.b	%11000000
	dcg.b	%01000000
	dcg.b	%01000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	%11110000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%01010000
	dcg.b	%00101000
	dcg.b	%01010000
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10110000
	dcg.b	%10110000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10110000
	dcg.b	%10110000
	dcg.b	%10110000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10110000
	dcg.b	%10110000
	dcg.b	%11110000
	dcg.b	%01100000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00100000
	dcg.b	%00000000
	dcg.b	%01100000
	dcg.b	%11000000
	dcg.b	%01110000
	dcg.b	%00000000
	dcg.b	0,0
			; C0
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
			; D0
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%10010000
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10010000
	dcg.b	%11100000
	dcg.b	%10000000
	dcg.b	0,0
			; E0
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
			; F0
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	%11100000
	dcg.b	%00000000
	dcg.b	%01000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	%00000000
	dcg.b	0,0
	
	dcg.b	%10100000
	dcg.b	%00000000
	dcg.b	%10100000
	dcg.b	%01100000
	dcg.b	%00100000
	dcg.b	%01100000
	dcg.b	0,0
	
	
fontend	
