/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTableRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private ProvisionedThroughput provisionedThroughput;
    private ListWithAutoConstructFlag<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;

    public UpdateTableRequest() {
    }

    public UpdateTableRequest(String tableName, ProvisionedThroughput provisionedThroughput) {
        this.setTableName(tableName);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public UpdateTableRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public UpdateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
        return this;
    }

    public List<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
        if (globalSecondaryIndexUpdates == null) {
            this.globalSecondaryIndexUpdates = null;
            return;
        }
        ListWithAutoConstructFlag globalSecondaryIndexUpdatesCopy = new ListWithAutoConstructFlag(globalSecondaryIndexUpdates.size());
        globalSecondaryIndexUpdatesCopy.addAll(globalSecondaryIndexUpdates);
        this.globalSecondaryIndexUpdates = globalSecondaryIndexUpdatesCopy;
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdates) {
        if (this.getGlobalSecondaryIndexUpdates() == null) {
            this.setGlobalSecondaryIndexUpdates(new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdates.length));
        }
        for (GlobalSecondaryIndexUpdate value : globalSecondaryIndexUpdates) {
            this.getGlobalSecondaryIndexUpdates().add(value);
        }
        return this;
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
        if (globalSecondaryIndexUpdates == null) {
            this.globalSecondaryIndexUpdates = null;
        } else {
            ListWithAutoConstructFlag globalSecondaryIndexUpdatesCopy = new ListWithAutoConstructFlag(globalSecondaryIndexUpdates.size());
            globalSecondaryIndexUpdatesCopy.addAll(globalSecondaryIndexUpdates);
            this.globalSecondaryIndexUpdates = globalSecondaryIndexUpdatesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: " + this.getProvisionedThroughput() + ",");
        }
        if (this.getGlobalSecondaryIndexUpdates() != null) {
            sb.append("GlobalSecondaryIndexUpdates: " + this.getGlobalSecondaryIndexUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexUpdates() == null ? 0 : this.getGlobalSecondaryIndexUpdates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexUpdates() == null ^ this.getGlobalSecondaryIndexUpdates() == null) {
            return false;
        }
        return other.getGlobalSecondaryIndexUpdates() == null || other.getGlobalSecondaryIndexUpdates().equals(this.getGlobalSecondaryIndexUpdates());
    }
}

