/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceCount;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceCountStaxUnmarshaller
implements Unmarshaller<InstanceCount, StaxUnmarshallerContext> {
    private static InstanceCountStaxUnmarshaller instance;

    @Override
    public InstanceCount unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceCount instanceCount = new InstanceCount();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return instanceCount;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("state", targetDepth)) {
                    instanceCount.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceCount", targetDepth)) continue;
                instanceCount.setInstanceCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceCount;
    }

    public static InstanceCountStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceCountStaxUnmarshaller();
        }
        return instance;
    }
}

