/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.interceptors.InvocationSchedule;
import java.util.Date;

public class FixedIntervalInvocationSchedule
implements InvocationSchedule {
    protected static final int SECOND = 1000;
    private final long intervalMilliseconds;
    private final long expirationMilliseconds;
    private final int maxInvocationCount;

    public FixedIntervalInvocationSchedule(int intervalSeconds, int expirationSeconds, int maxInvocationCount) {
        this.intervalMilliseconds = intervalSeconds * 1000;
        this.expirationMilliseconds = expirationSeconds * 1000;
        this.maxInvocationCount = maxInvocationCount;
    }

    public FixedIntervalInvocationSchedule(int intervalSeconds, int expirationSeconds) {
        this.intervalMilliseconds = intervalSeconds * 1000;
        this.expirationMilliseconds = expirationSeconds * 1000;
        this.maxInvocationCount = Integer.MAX_VALUE;
    }

    public long nextInvocationDelaySeconds(Date currentTime, Date startTime, Date lastInvocationTime, int pastInvocatonsCount) {
        if (pastInvocatonsCount >= this.maxInvocationCount) {
            return -1L;
        }
        long resultMilliseconds = lastInvocationTime == null ? startTime.getTime() + this.intervalMilliseconds - currentTime.getTime() : lastInvocationTime.getTime() + this.intervalMilliseconds - currentTime.getTime();
        if (resultMilliseconds < 0L) {
            resultMilliseconds = 0L;
        }
        if (currentTime.getTime() + resultMilliseconds - startTime.getTime() >= this.expirationMilliseconds) {
            return -1L;
        }
        return resultMilliseconds / 1000L;
    }
}

