#include <stdio.h>
#include <stdlib.h>
#include "mylink.h"
#include "main.h"
#include "symbol.h"
#include "assign.h"

struct	sFreeArea
{
	SLONG	nOrg;
	SLONG	nSize;
	struct	sFreeArea	*pPrev, *pNext;
};

struct	sFreeArea	*BankFree[MAXBANKS];
SLONG	MaxAvail[MAXBANKS];
SLONG	MaxBankUsed;

#define	DOMAXBANK(x)	{if( (x)>MaxBankUsed ) MaxBankUsed=(x);}

SLONG	area_Avail( SLONG bank )
{
	SLONG	r;
	struct	sFreeArea	*pArea;

	r=0;
	pArea=BankFree[bank];

	while( pArea )
	{
		r+=pArea->nSize;
		pArea=pArea->pNext;
	}

	return( r );
}

SLONG	area_AllocAbs( struct sFreeArea **ppArea, SLONG org, SLONG size )
{
	struct	sFreeArea	*pArea;

	pArea=*ppArea;
	while( pArea )
	{
		if( org>=pArea->nOrg && (org+size-1)<=(pArea->nOrg+pArea->nSize-1) )
		{
			if( org==pArea->nOrg )
			{
				pArea->nOrg+=size;
				pArea->nSize-=size;
				return( org );
			}
			else
			{
				if( (org+size-1)==(pArea->nOrg+pArea->nSize-1) )
				{
					pArea->nSize-=size;
					return( org );
				}
				else
				{
					struct	sFreeArea	*pNewArea;

					if( (pNewArea=(struct sFreeArea *)malloc(sizeof(struct sFreeArea)))!=NULL )
					{
						*pNewArea=*pArea;
						pNewArea->pPrev=pArea;
						pArea->pNext=pNewArea;
						pArea->nSize=org-pArea->nOrg;
						pNewArea->nOrg=org+size;
						pNewArea->nSize-=size+pArea->nSize;

						return( org );
					}
					else
						fatalerror( "Out of memory!" );
				}
			}
		}
		ppArea=&(pArea->pNext);
		pArea=*ppArea;
	}

	return( -1 );
}

SLONG	area_AllocAbsCODEAnyBank( SLONG org, SLONG size )
{
	SLONG	i;

	for( i=1; i<=255; i+=1 )
	{
		if( area_AllocAbs( &BankFree[i], org, size )==org )
			return( i );
	}

	return( -1 );
}

SLONG	area_Alloc( struct sFreeArea **ppArea, SLONG size )
{
	struct	sFreeArea	*pArea;

	pArea=*ppArea;
	while( pArea )
	{
		if( size<=pArea->nSize )
		{
			SLONG	r;

			r=pArea->nOrg;
			pArea->nOrg+=size;
			pArea->nSize-=size;

			return( r );
		}
		ppArea=&(pArea->pNext);
		pArea=*ppArea;
	}

	return( -1 );
}

SLONG	area_AllocCODEAnyBank( SLONG size )
{
	SLONG	i, org;

	for( i=1; i<=255; i+=1 )
	{
		if( (org=area_Alloc(&BankFree[i],size))!=-1 )
			return( (i<<16)|org );
	}

	return( -1 );
}


SLONG   area_AllocAligned( struct sFreeArea **ppArea, SLONG alignment, SLONG size )
{
        struct  sFreeArea       *pArea;
	SLONG 	org;
        pArea=*ppArea;
        while( pArea )
        {
		if( size <= pArea->nSize )
		{
			if( (pArea->nOrg % alignment) == 0 )
			{
				org = pArea->nOrg;
				pArea->nOrg+=size;
				pArea->nSize-=size;
				return( org );
			}
			else if( (pArea->nOrg+pArea->nSize - size) % alignment == 0  )
			{
				org = pArea->nOrg+pArea->nSize - size;
				pArea->nSize-=size;
				return( org ) ;
			}
			else
			{
				org = pArea->nOrg + alignment - (pArea->nOrg % alignment); 
				if( org+size <= pArea->nOrg+pArea->nSize )
				{
					struct  sFreeArea       *pNewArea;
					if( (pNewArea=(struct sFreeArea *)malloc(sizeof(struct sFreeArea)))!=NULL )
					{
						*pNewArea=*pArea;
						pNewArea->pPrev=pArea;
						pArea->pNext=pNewArea;
						pArea->nSize=org-pArea->nOrg;
						pNewArea->nOrg=org+size;
						pNewArea->nSize-=size+pArea->nSize;
						return( org );
					}
					else
						fatalerror( "Out of memory!" );
				}
				
			}
		}
		ppArea=&(pArea->pNext);
		pArea=*ppArea;
	}
	return( -1 );
}

SLONG	area_AllocAlignedCODEAnyBank( SLONG alignment, SLONG size )
{
	SLONG	i, org;

	for( i=1; i<=255; i+=1 )
	{
		if( (org=area_AllocAligned(&BankFree[i],alignment,size))!=-1 )
			return( (i<<16)|org );
	}

	return( -1 );
}

struct	sSection	*FindLargestAlignedCode( void )
{
	struct sSection *pSection, *r=NULL;
	SLONG	nLargest=0;

	pSection=pSections;
	while( pSection )
	{
		if( pSection->oAssigned==0 && pSection->Type==SECT_ALIGNED_CODE )
		{
			if( (pSection->nByteSize + (pSection->nOrg>>1)) > nLargest )
			{
				nLargest=pSection->nByteSize + (pSection->nOrg>>1);
				r=pSection;
			}
		}
		pSection=pSection->pNext;
	}
	return( r );
}


void AssignAlignedCodeSections( void )
{
	struct sSection *pSection;

	while( pSection=FindLargestAlignedCode() )
	{
		SLONG	org;

		if( (org=area_AllocAlignedCODEAnyBank( pSection->nOrg, pSection->nByteSize ))!=-1 )
		{
			pSection->nOrg=org&0xFFFF;
			pSection->nBank=org>>16;
			pSection->oAssigned=1;
			DOMAXBANK(pSection->nBank);
		}
		else
		{
			if(pSection->pzName!=NULL)
				fatalerror( "Unable to place aligned section \"%s\" anywhere",pSection->pzName );
			else
				fatalerror( "Unable to place ALIGNED_CODE or ALIGNED_DATA section anywhere" );
		}
	}
}


SLONG   area_AllocContained( struct sFreeArea **ppArea, SLONG containment_interval, SLONG size )
{
        struct  sFreeArea       *pArea;
	SLONG 	org;
        pArea=*ppArea;
        while( pArea )
        {
		if( size <= pArea->nSize )
		{
			if( (pArea->nOrg/containment_interval) == ((pArea->nOrg+size-1)/containment_interval) )
			{
				org = pArea->nOrg;
				pArea->nOrg+=size;
				pArea->nSize-=size;
				return( org );
			}
			else if( ((pArea->nOrg+pArea->nSize - size)/containment_interval) == ((pArea->nOrg+pArea->nSize - 1)/containment_interval)  )
			{
				org = pArea->nOrg+pArea->nSize - size;
				pArea->nSize-=size;
				return( org ) ;
			}
			else
			{
				SLONG org_offset_low, org_offset_high;
				org_offset_low  = containment_interval - (pArea->nOrg % containment_interval);
				org_offset_high = pArea->nSize - ((pArea->nOrg + pArea->nSize) % containment_interval) - size;
				if( org_offset_low < ( pArea->nSize - (org_offset_high + size) ) )
					org = pArea->nOrg + org_offset_low;
				else
					org = pArea->nOrg + org_offset_high;

				if( (org>=pArea->nOrg) && (org+size <= pArea->nOrg+pArea->nSize) )
				{
					struct  sFreeArea       *pNewArea;
					if( (pNewArea=(struct sFreeArea *)malloc(sizeof(struct sFreeArea)))!=NULL )
					{
						*pNewArea=*pArea;
						pNewArea->pPrev=pArea;
						pArea->pNext=pNewArea;
						pArea->nSize=org-pArea->nOrg;
						pNewArea->nOrg=org+size;
						pNewArea->nSize-=size+pArea->nSize;
						return( org );
					}
					else
						fatalerror( "Out of memory!" );
				}
				
			}
		}
		ppArea=&(pArea->pNext);
		pArea=*ppArea;
	}
	return( -1 );
}

SLONG	area_AllocContainedCODEAnyBank( SLONG containment_interval, SLONG size )
{
	SLONG	i, org;

	for( i=1; i<=255; i+=1 )
	{
		if( (org=area_AllocContained(&BankFree[i],containment_interval,size))!=-1 )
			return( (i<<16)|org );
	}

	return( -1 );
}

struct	sSection	*FindLargestContainedCode( void )
{
	struct sSection *pSection, *r=NULL;
	SLONG	nLargest=0;

	pSection=pSections;
	while( pSection )
	{
		if( pSection->oAssigned==0 && pSection->Type==SECT_CONTAINED_CODE )
		{
			if( pSection->nByteSize > nLargest )
			{
				nLargest=pSection->nByteSize;
				r=pSection;
			}
		}
		pSection=pSection->pNext;
	}
	return( r );
}


void AssignContainedCodeSections( void )
{
	struct sSection *pSection;

	while( pSection=FindLargestContainedCode() )
	{
		SLONG	org;

		if( (org=area_AllocContainedCODEAnyBank( pSection->nOrg, pSection->nByteSize ))!=-1 )
		{
			pSection->nOrg=org&0xFFFF;
			pSection->nBank=org>>16;
			pSection->oAssigned=1;
			DOMAXBANK(pSection->nBank);
		}
		else
		{
			if(pSection->pzName!=NULL)
				fatalerror( "Unable to place contained section \"%s\" anywhere",pSection->pzName );
			else
				fatalerror( "Unable to place CONTAINED_CODE or CONTAINED_DATA section anywhere" );
		}
	}
}
struct	sSection	*FindLargestCode( void )
{
	struct sSection *pSection, *r=NULL;
	SLONG	nLargest=0;

	pSection=pSections;
	while( pSection )
	{
		if( pSection->oAssigned==0 && pSection->Type==SECT_CODE )
		{
			if( pSection->nByteSize > nLargest )
			{
				nLargest=pSection->nByteSize;
				r=pSection;
			}
		}
		pSection=pSection->pNext;
	}
	return( r );
}


void AssignCodeSections( void )
{
	struct sSection *pSection;

	while( pSection=FindLargestCode() )
	{
		SLONG	org;

		if( (org=area_AllocCODEAnyBank( pSection->nByteSize ))!=-1 )
		{
			pSection->nOrg=org&0xFFFF;
			pSection->nBank=org>>16;
			pSection->oAssigned=1;
			DOMAXBANK(pSection->nBank);
		}
		else
		{
			if(pSection->pzName!=NULL)
				fatalerror( "Unable to place CODE or DATA section \"%s\" anywhere",pSection->pzName );
			else
				fatalerror( "Unable to place CODE or DATA section anywhere" );
		}
	}
}

void GBROM_AssignSections( void )
{
	SLONG	i;
	struct sSection *pSection;

	MaxBankUsed=0;

	/*
	 * Initialize the memory areas
	 *
	 */

	for( i=0; i<MAXBANKS; i+=1 )
	{
		if( BankFree[i]=(struct sFreeArea *)malloc(sizeof(struct sFreeArea)) )
		{
			if( i==0 )
			{
				BankFree[i]->nOrg=0x0000;
				if( options&OPT_SMALL )
				{
					BankFree[i]->nSize=0x8000;
					MaxAvail[i]=0x8000;
				}
				else
				{
					BankFree[i]->nSize=0x4000;
					MaxAvail[i]=0x4000;
				}
			}
			else if( i>=1 && i<=255 )
			{
				BankFree[i]->nOrg=0x4000;
				/*
					* Now, this shouldn't really be necessary... but for good
					* measure we'll do it anyway
					*
					*/
				if( options&OPT_SMALL )
				{
					BankFree[i]->nSize=0;
					MaxAvail[i]=0;
				}
				else
				{
					BankFree[i]->nSize=0x4000;
					MaxAvail[i]=0x4000;
				}
			}
			else if( i==BANK_BSS )
			{
				BankFree[i]->nOrg =0xC000;
				BankFree[i]->nSize=0x2000;
				MaxAvail[i]=0x2000;
			}
			else if( i==BANK_VRAM )
			{
				BankFree[i]->nOrg =0x8000;
				BankFree[i]->nSize=0x2000;
				MaxAvail[i]=0x2000;
			}
			else if( i==BANK_HRAM )
			{
				BankFree[i]->nOrg =0xFF80;
				BankFree[i]->nSize=0x007F;
				MaxAvail[i]=0x007F;
			}
			BankFree[i]->pPrev=NULL;
			BankFree[i]->pNext=NULL;
		}
		else
			fatalerror( "Out of memory!" );
	}

	/*
	 * First, let's assign all the fixed sections...
	 * And all because of that Jens Restemeier character ;)
	 *
	 */

	pSection=pSections;
	while( pSection )
	{
		if( (pSection->nOrg!=-1 || pSection->nBank!=-1) && pSection->oAssigned==0 )
		{
			/* User wants to have a say... */

			switch( pSection->Type )
			{
				case SECT_BSS:
					if( area_AllocAbs(&BankFree[BANK_BSS],pSection->nOrg,pSection->nByteSize)!=pSection->nOrg )
					{
						if(pSection->pzName!=NULL)
							fatalerror( "Unable to load fixed BSS section \"%s\" at $%X",pSection->pzName, pSection->nOrg );
						else
							fatalerror( "Unable to load fixed BSS section at $%X", pSection->nOrg );
					}
					pSection->oAssigned=1;
					pSection->nBank=BANK_BSS;
					break;
				case SECT_HRAM:
					if( area_AllocAbs(&BankFree[BANK_HRAM],pSection->nOrg,pSection->nByteSize)!=pSection->nOrg )
					{
						if(pSection->pzName!=NULL)
							fatalerror( "Unable to load fixed HRAM section \"%s\" at $%X",pSection->pzName, pSection->nOrg );
						else
							fatalerror( "Unable to load fixed HRAM section at $%X", pSection->nOrg );
					}
					pSection->oAssigned=1;
					pSection->nBank=BANK_HRAM;
					break;
				case SECT_VRAM:
					if( area_AllocAbs(&BankFree[BANK_VRAM],pSection->nOrg,pSection->nByteSize)!=pSection->nOrg )
					{
						if(pSection->pzName!=NULL)
							fatalerror( "Unable to load fixed VRAM section \"%s\" at $%X",pSection->pzName, pSection->nOrg );
						else
							fatalerror( "Unable to load fixed VRAM section at $%X", pSection->nOrg );
					}
					pSection->oAssigned=1;
					pSection->nBank=BANK_VRAM;
					break;
				case SECT_HOME:
					if( area_AllocAbs(&BankFree[BANK_HOME],pSection->nOrg,pSection->nByteSize)!=pSection->nOrg )
					{
						if(pSection->pzName!=NULL)
							fatalerror( "Unable to load fixed HOME section \"%s\" at $%X",pSection->pzName, pSection->nOrg );
						else
							fatalerror( "Unable to load fixed HOME section at $%X", pSection->nOrg );
					}
					pSection->oAssigned=1;
					pSection->nBank=BANK_HOME;
					break;
				case SECT_CODE:
					if( pSection->nBank==-1 )
					{
						/*
						 * User doesn't care which bank, so he must want to
						 * decide which position within that bank.
						 * We'll do that at a later stage when the really
						 * hardcoded things are allocated
						 *
						 */
					}
					else
					{
						/*
						 * User wants to decide which bank we use
						 * Does he care about the position as well?
						 *
						 */

						if( pSection->nOrg==-1 )
						{
							/*
							 * Nope, any position will do
							 * Again, we'll do that later
							 *
							 */
						}
						else
						{
							/*
							 * How hardcore can you possibly get? Why does
							 * he even USE this package? Yeah let's just
							 * direct address everything, shall we?
							 * Oh well, the customer is always right
							 *
							 */

							if( pSection->nBank>=1 && pSection->nBank<=255 )
							{
								if( area_AllocAbs(&BankFree[pSection->nBank],pSection->nOrg,pSection->nByteSize)!=pSection->nOrg )
								{
									if(pSection->pzName!=NULL)
										fatalerror( "Unable to load fixed CODE/DATA section \"%s\" at $%X in bank $%X",pSection->pzName, pSection->nOrg, pSection->nBank );
									else
										fatalerror( "Unable to load fixed CODE/DATA section at $%X in bank $%X", pSection->nOrg, pSection->nBank );
									
								}
								DOMAXBANK(pSection->nBank);
								pSection->oAssigned=1;
							}
							else
							{
								
								if(pSection->pzName!=NULL)
									fatalerror( "Unable to load fixed CODE/DATA section \"%s\" at $%X in bank $%X",pSection->pzName, pSection->nOrg, pSection->nBank );
								else
									fatalerror( "Unable to load fixed CODE/DATA section at $%X in bank $%X", pSection->nOrg, pSection->nBank );
							}
						}

					}
					break;
			}
		}
		pSection=pSection->pNext;
	}


	/*
	 * Next, let's assign all the bankfixed ONLY CODE sections...
	 *
	 */

	pSection=pSections;
	while( pSection )
	{
		if( pSection->oAssigned==0
		&&	pSection->Type==SECT_CODE
		&&	pSection->nOrg==-1
		&&	pSection->nBank!=-1 )
		{
			/* User wants to have a say... and he's pissed */
			if( pSection->nBank>=1 && pSection->nBank<=255 )
			{
				if( (pSection->nOrg=area_Alloc(&BankFree[pSection->nBank],pSection->nByteSize))==-1 )
				{
					if(pSection->pzName != NULL)
						fatalerror( "Bank $%X is full, can't fit section \"%s\"",pSection->nBank, pSection->pzName);
					else
						fatalerror( "Bank $%X is full",pSection->nBank );
				}
				pSection->oAssigned=1;
				DOMAXBANK(pSection->nBank);
			}
			else
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Unable to load CODE/DATA section \"%s\" into bank $%X",pSection->pzName, pSection->nBank );
				else
					fatalerror( "Unable to load CODE/DATA section into bank $%X", pSection->nBank );
			}
		}
		pSection=pSection->pNext;
	}


	/*
	 * Now, let's assign all the floating bank but fixed CODE sections...
	 *
	 */

	pSection=pSections;
	while( pSection )
	{
		if( pSection->oAssigned==0
		&&	pSection->Type==SECT_CODE
		&&	pSection->nOrg!=-1
		&&	pSection->nBank==-1 )
		{
			/* User wants to have a say... and he's back with a vengeance */
			if( (pSection->nBank=area_AllocAbsCODEAnyBank(pSection->nOrg,pSection->nByteSize))==-1 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Unable to load fixed CODE/DATA section \"%s\" at $%X into any bank",pSection->pzName, pSection->nOrg );
				else
					fatalerror( "Unable to load fixed CODE/DATA section at $%X into any bank", pSection->nOrg );
			}
			pSection->oAssigned=1;
			DOMAXBANK(pSection->nBank);
		}
		pSection=pSection->pNext;
	}

	/*
	 * Aligned bankfixed code sections
	 */

        pSection=pSections;
        while( pSection )
        {
                if( pSection->oAssigned==0
	                &&      pSection->Type==SECT_ALIGNED_CODE
	                &&      pSection->nBank!=-1 )
		{
	/* User wants to have a say... and he's pissed */
			if( pSection->nOrg <= 0 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Illegal alignment value in declaration of ALIGNED_CODE/ALIGNED_DATA section \"%s\"", pSection->pzName );
				else
					fatalerror( "Illegal alignment value in declaration of ALIGNED_CODE/ALIGNED_DATA section" );
			}

			if( pSection->nBank>=1 && pSection->nBank<=255 )
			{
				if( (pSection->nOrg=area_AllocAligned(&BankFree[pSection->nBank],pSection->nOrg,pSection->nByteSize))==-1 )
				{
					if(pSection->pzName!=NULL)
						fatalerror( "Unable to load ALIGNED_CODE/ALIGNED_DATA section \"%s\" into bank $%X", pSection->pzName, pSection->nBank );
					else
						fatalerror( "Unable to load ALIGNED_CODE/ALIGNED_DATA section into bank $%X", pSection->nBank );
				}
				pSection->oAssigned=1;
				DOMAXBANK(pSection->nBank);
			}
			else
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Unable to load ALIGNED_CODE/ALIGNED_DATA section \"%s\" into bank $%X", pSection->pzName, pSection->nBank );
				else
					fatalerror( "Unable to load ALIGNED_CODE/ALIGNED_DATA section into bank $%X", pSection->nBank );
			}
		}
		pSection=pSection->pNext;
	}


	/*
	 * Aligned home sections
	 */

        pSection=pSections;
        while( pSection )
        {
                if( pSection->oAssigned==0
			&&      pSection->Type==SECT_ALIGNED_HOME )
		{
		/* User wants to have a say... and he's shitting himself */
			if( pSection->nOrg <= 0 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Illegal alignment value in declaration of ALIGNED_HOME section \"%s\"", pSection->pzName );
				else
					fatalerror( "Illegal alignment value in declaration of ALIGNED_HOME section" );
			}
							
			if( (pSection->nOrg=area_AllocAligned(&BankFree[BANK_HOME],pSection->nOrg,pSection->nByteSize))==-1 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Unable to load aligned section \"%s\" into home bank", pSection->pzName );
				else
					fatalerror( "Unable to load aligned section into home bank" );
			}
			pSection->oAssigned=1;
			DOMAXBANK(pSection->nBank);
			
		}
		pSection=pSection->pNext;
	}
	
	/*
	 * Aligned code
	 */
	
	AssignAlignedCodeSections();


	/*
	 * Contained bankfixed code sections
	 */

        pSection=pSections;
        while( pSection )
        {
                if( pSection->oAssigned==0
	                &&      pSection->Type==SECT_CONTAINED_CODE
	                &&      pSection->nBank!=-1 )
		{
	/* User wants to have a say... and he's pissed */
			if( pSection->nOrg <= 0 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Illegal length of containment interval in declaration of section \"%s\"", pSection->pzName );
				else
					fatalerror( "Illegal length of containment interval in declaration of CONTAINED_CODE/CONTAINED_DATA section" );
			}

			if( pSection->nBank>=1 && pSection->nBank<=255 )
			{
				if( (pSection->nOrg=area_AllocContained(&BankFree[pSection->nBank],pSection->nOrg,pSection->nByteSize))==-1 )
				{
					if(pSection->pzName!=NULL)
						fatalerror( "Unable to load contained section \"%s\" into bank $%X", pSection->pzName, pSection->nBank );
					else
						fatalerror( "Unable to load CONTAINED_CODE/CONTAINED_DATA section into bank $%X", pSection->nBank );
				}
				pSection->oAssigned=1;
				DOMAXBANK(pSection->nBank);
			}
			else
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Unable to load contained section \"%s\" into bank $%X", pSection->pzName, pSection->nBank );
				else
					fatalerror( "Unable to load CONTAINED_CODE/CONTAINED_DATA section into bank $%X", pSection->nBank );
			}
		}
		pSection=pSection->pNext;
	}


	/*
	 * Contained home sections
	 */

        pSection=pSections;
        while( pSection )
        {
                if( pSection->oAssigned==0
			&&      pSection->Type==SECT_CONTAINED_HOME )
		{
		/* User wants to have a say... and he's shitting himself */
			if( pSection->nOrg <= 0 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Illegal length of containment interval in declaration of section \"%s\"", pSection->pzName );
				else
					fatalerror( "Illegal length of containment interval in declaration of CONTAINED_HOME section" );
			}
							
			if( (pSection->nOrg=area_AllocContained(&BankFree[BANK_HOME],pSection->nOrg,pSection->nByteSize))==-1 )
			{
				if(pSection->pzName!=NULL)
					fatalerror( "Unable to load contained section \"%s\" into home bank", pSection->pzName );
				else
					fatalerror( "Unable to load contained section into home bank" );
			}
			pSection->oAssigned=1;
			DOMAXBANK(pSection->nBank);
			
		}
		pSection=pSection->pNext;
	}
	
	/*
	 * Aligned code
	 */
	
	AssignContainedCodeSections();




	/*
	 * OK, all that nasty stuff is done so let's assign all the other
	 * sections
	 *
	 */

	pSection=pSections;
	while( pSection )
	{
		if( pSection->oAssigned==0 )
		{
			switch( pSection->Type )
			{
				case SECT_BSS:
					if( (pSection->nOrg=area_Alloc(&BankFree[BANK_BSS],pSection->nByteSize))==-1 )
					{
						fatalerror( "BSS section too large" );
					}
					pSection->nBank=BANK_BSS;
					pSection->oAssigned=1;
					break;
				case SECT_HRAM:
					if( (pSection->nOrg=area_Alloc(&BankFree[BANK_HRAM],pSection->nByteSize))==-1 )
					{
						fatalerror( "HRAM section too large" );
					}
					pSection->nBank=BANK_HRAM;
					pSection->oAssigned=1;
					break;
				case SECT_VRAM:
					if( (pSection->nOrg=area_Alloc(&BankFree[BANK_VRAM],pSection->nByteSize))==-1 )
					{
						fatalerror( "VRAM section too large" );
					}
					pSection->nBank=BANK_VRAM;
					pSection->oAssigned=1;
					break;
				case SECT_HOME:
					if( (pSection->nOrg=area_Alloc(&BankFree[BANK_HOME],pSection->nByteSize))==-1 )
					{
						fatalerror( "HOME section too large" );
					}
					pSection->nBank=BANK_HOME;
					pSection->oAssigned=1;
					break;
				case SECT_CODE:
					break;
				case SECT_ALIGNED_CODE:
				case SECT_ALIGNED_HOME:
				case SECT_CONTAINED_CODE:
				case SECT_CONTAINED_HOME:
					if(pSection->pzName != NULL)
						fatalerror( "(INTERNAL) Section \"%s\" not assigned by linker!", pSection->pzName);
					else
						fatalerror( "(INTERNAL) Section not assigned by linker!" );
					break;
				default:
					fatalerror( "(INTERNAL) Unknown section type!" );
					break;
			}
		}
		pSection=pSection->pNext;
	}

	AssignCodeSections();
	
}

void PSION2_AssignSections( void )
{
	struct sSection *pSection;

	if( BankFree[0]=(struct sFreeArea *)malloc(sizeof(struct sFreeArea)) )
	{
		BankFree[0]->nOrg=0x0000;
		BankFree[0]->nSize=0x10000;
		MaxAvail[0]=0x10000;
		BankFree[0]->pPrev=NULL;
		BankFree[0]->pNext=NULL;

		pSection=pSections;
		while( pSection )
		{
			if( pSection->oAssigned==0 && pSection->Type==SECT_CODE )
			{
				pSection->oAssigned=1;
				pSection->nBank=0;
				pSection->nOrg=BankFree[0]->nOrg;
				BankFree[0]->nOrg+=pSection->nByteSize;
				BankFree[0]->nSize-=pSection->nByteSize;
			}
			pSection=pSection->pNext;
		}

		pSection=pSections;
		while( pSection )
		{
			if( pSection->oAssigned==0 && pSection->Type==SECT_BSS )
			{
				pSection->oAssigned=1;
				pSection->nBank=0;
				pSection->nOrg=BankFree[0]->nOrg;
				BankFree[0]->nOrg+=pSection->nByteSize;
				BankFree[0]->nSize-=pSection->nByteSize;
			}
			pSection=pSection->pNext;
		}
	}
	else
		fatalerror( "Out of memory!" );
}

void	AssignSections( void )
{
	switch( outputtype )
	{
		case OUTPUT_GBROM:
			GBROM_AssignSections();
			break;
		case OUTPUT_PSION2:
			PSION2_AssignSections();
			break;
	}
}

void CreateSymbolTable( void )
{
	struct sSection *pSect;

	sym_Init();

	pSect=pSections;

	while( pSect )
	{
		SLONG	i;

		i=pSect->nNumberOfSymbols;

		while( i-- )
		{
			if( (pSect->tSymbols[i]->Type==SYM_EXPORT) &&
				 ( (pSect->tSymbols[i]->pSection==pSect) ||
					(pSect->tSymbols[i]->pSection==NULL)) )
			{
				if( pSect->tSymbols[i]->pSection==NULL )
					sym_CreateSymbol( pSect->tSymbols[i]->pzName,
											pSect->tSymbols[i]->nOffset,
											-1 );
				else
					sym_CreateSymbol( pSect->tSymbols[i]->pzName,
											pSect->nOrg+pSect->tSymbols[i]->nOffset,
											pSect->nBank );
			}
		}
		pSect=pSect->pNext;
	}
}
