#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<string.h>

#include	"object.h"
#include	"output.h"
#include	"assign.h"
#include	"patch.h"
#include	"asmotor.h"
#include	"mylink.h"
#include	"mapfile.h"
#include	"main.h"
#include	"library.h"

/*	Quick and dirty...but it works */
#ifdef __GNUC__
#define	strcmpi	strcasecmp
#endif

enum	eBlockType
{
	BLOCK_COMMENT,
	BLOCK_OBJECTS,
	BLOCK_LIBRARIES,
	BLOCK_OUTPUT
};

SLONG	options=0;
SLONG	fillchar=0xFF;
enum	eOutputType	outputtype=OUTPUT_GBROM;
char	smartlinkstartsymbol[256];

/*
 * Print out an errormessage
 *
 */


void 	vfatalerror( char *s, va_list ap)
{
#if EMACS_ERRORS
        fprintf(stderr, "xlink: error: ");
	vfprintf(stderr,s,ap);
	fprintf(stderr,"\n");
#else
        fprintf(stderr, "*ERROR* : ");
	vfprintf(stderr,s,ap);
	fprintf(stderr,"\n");
#endif
}

void	fatalerror( char *s, ... )
{
	va_list ap;
	va_start(ap,s);
	vfatalerror(s,ap);
	va_end(ap);
	exit( 5 );
}

/*
 * Print the usagescreen
 *
 */

void	PrintUsage( void )
{
	printf( "xLink v" LINK_VERSION " (part of ASMotor " ASMOTOR_VERSION ")\n\n"
			"Usage: xlink [options] linkfile\n"
			"Options:\n  -h\t\tThis text\n"
			"  -m<mapfile>\tWrite a mapfile\n"
			"  -n<symfile>\tWrite a NO$GMB compatible symfile\n"
    		"  -z<hx>\tSet the byte value used for uninitialised data (hex\n"
			"\t\tformat or ? for random, default is FF)\n"
    		"  -s<symbol>\tPerform smart linking starting with <symbol>\n"
			"  -t\t\tOutput target\n"
			"\t-tg\tGameboy ROM image(default)\n"
			"\t-ts\tGameboy small mode (32kB)\n"
			"\t-tp\tPsion2 reloc module\n" );
	exit( 0 );
}

/*
 * Parse the linkfile and load all the objectfiles
 *
 */

void	ProcessLinkfile( char *tzLinkfile )
{
	FILE	*pLinkfile;
	enum	eBlockType	CurrentBlock=BLOCK_COMMENT;

	if( pLinkfile=fopen(tzLinkfile,"rt") )
	{
		while( !feof(pLinkfile) )
		{
			char	tzLine[256];

			fscanf( pLinkfile, "%s\n", tzLine );
			if( tzLine[0]!='#' )
			{
				if( tzLine[0]=='[' && tzLine[strlen(tzLine)-1]==']' )
				{
					if( strcmpi("[objects]",tzLine)==0 )
						CurrentBlock=BLOCK_OBJECTS;
					else if( strcmpi("[output]",tzLine)==0 )
						CurrentBlock=BLOCK_OUTPUT;
					else if( strcmpi("[libraries]",tzLine)==0 )
						CurrentBlock=BLOCK_LIBRARIES;
					else if( strcmpi("[comment]",tzLine)==0 )
						CurrentBlock=BLOCK_COMMENT;
					else
					{
						fclose( pLinkfile );
						fatalerror( "Unknown block '%s'",tzLine );
					}
				}
				else
				{
					switch( CurrentBlock )
					{
						case BLOCK_COMMENT:
							break;
						case BLOCK_OBJECTS:
							obj_Readfile( tzLine );
							break;
						case BLOCK_LIBRARIES:
							lib_Readfile( tzLine );
							break;
						case BLOCK_OUTPUT:
							out_Setname( tzLine );
							break;
					}
				}
			}
		}
		fclose( pLinkfile );
	}
	else
	{
		fatalerror( "Unable to find linkfile '%s'",tzLinkfile );
	}

}

/*
 * The main routine
 *
 */

int	main( int argc, char *argv[] )
{
	SLONG	argn=1;


	if( argc==1 )
		PrintUsage();

	while( argn < argc )
	{
		char opt;
		if(argv[argn][0] == '-') {
			switch( opt=argv[argn][1] )
			{
				case '?':
				case 'h':
					PrintUsage();
					break;
				case 'm':
					SetMapfileName( argv[argn]+2 );
					break;
				case 'n':
					SetSymfileName( argv[argn]+2 );
					break;
				case 't':
					switch( opt=argv[argn][2] )
					{
						case 'g':
							outputtype=OUTPUT_GBROM;
							break;
						case 's':
							outputtype=OUTPUT_GBROM;
							options|=OPT_SMALL;
							break;
						case 'p':
							outputtype=OUTPUT_PSION2;
							break;
						default:
							fatalerror( "Unknown option 't%c'",opt );
							break;
					}
					break;
				case 'z':
					if( strlen(argv[argn]+2)<=2 )
					{
						if( strcmp(argv[argn]+2,"?")==0 )
						{
							fillchar=-1;
						}
						else
						{
							int	result;
	
							result=sscanf( argv[argn]+2, "%x", &fillchar );
							if( !((result==EOF) || (result==1)) )
							{
								fatalerror("Invalid argument for option 'z'" );
							}
						}
					}
					else
					{
						fatalerror("Invalid argument for option 'z'" );
					}
					break;
				case 's':
					options|=OPT_SMART_C_LINK;
					strcpy( smartlinkstartsymbol, argv[argn]+2 );
					break;
				default:
					fatalerror( "Unknown option '%c'",opt );
					break;
			}
		}
		argn++;
	}
	argn--;

	if( argv[argn][0]!='-' )
	{
		ProcessLinkfile( argv[argn++] );
		AddNeededModules();
		AssignSections();
		CreateSymbolTable();
		Patch();
		Output();
		CloseMapfile();
	}
	else
		PrintUsage();

	return( 0 );
}
